

#include "sfx.h"
#include "gamegine.h"


/* **************************************************************
************************************************************** */
void vfx_lens_corona::init(char *filename, float l, float s, unsigned char *c, float al, float colorScale) {

   corona = (texbase *)((frame_manager *)global_resource_manager)->read_tex(filename);

   if (!corona)
      return;

   loc_scale = l;
   size_scale = s;
   animation_time_scale = 1.0/al;
	 
   color[0] = (unsigned char)(c[0] * colorScale);
   color[1] = (unsigned char)(c[1] * colorScale);
   color[2] = (unsigned char)(c[2] * colorScale);
}


/* **************************************************************
************************************************************** */
void vfx_lens_corona::render(mapul *buffer, int index, float *pos, float *axis, float t) {

   vector2f position;
   vector4uc c;
   texbase *tob;
   float f;

   if (!corona)
      return;

   // calc position of corona
   position[0] = pos[0] + axis[0]*loc_scale;
   position[1] = pos[1] + axis[1]*loc_scale;

   c[0] = (unsigned char )(color[0]*t);
   c[1] = (unsigned char )(color[1]*t);
   c[2] = (unsigned char )(color[2]*t);

   f = index * animation_time_scale;
   corona->query_data(TEXTURE2D_QUERY_UNIT_TEXTURE, &f, &tob);
   complex->gfx->gfxPaste2D(buffer, tob, c, (int)(position[0]-size_scale), (int)(position[1]-size_scale), (int)(position[0]+size_scale), (int)(position[1]+size_scale), GFX_TRANSPARENT);
}

