

#include <stdlib.h>
#include <string.h>

#include "gamegine.h"
#include "pstring.h"


/* ***********************************************************************
*********************************************************************** */
rasterchar::rasterchar() {
	
   ll[0] = ll[1] = 0;
   ur[0] = ur[1] = 0;
   fssize = 0;
   fratio = 1.0f;
   tmap = NULL;
}


/* ***********************************************************************
*********************************************************************** */
int rasterchar::read_data(FILE *infile) {

   char token[MAXSTRLEN];
   float imaxx, imaxy;
   
   get_token(infile, token);
   ll[0] = (float)atof(token);

   get_token(infile, token);
   ll[1] = (float)atof(token);

   get_token(infile, token);
   ur[0] = (float)atof(token);

   get_token(infile, token);
   ur[1] = (float)atof(token);

   fssize = FLOAT_TO_FIXED(fratio = ur[0]/ur[1]);

   get_token(infile, token);
   tmap = (texbase *)((frame_manager *)global_resource_manager)->read_tex(token);

   if (!tmap) {
      sprintf(perror_buffer, "Warning: Invalid font bitmap %s...\n", token);
      pprintf(perror_buffer);
      return 0;
   }
         
   imaxx = (float)(1.0/tmap->oldx);
   imaxy = (float)(1.0/tmap->oldy);
   ur[0] = (ur[0] + ll[0]) * imaxx;
   ur[1] = (ur[1] + ll[1]) * imaxy;
   ll[0] *= imaxx;
   ll[1] *= imaxy;

   return 1;
}


/* ***********************************************************************
*********************************************************************** */
rasterfont::rasterfont() {

   vfont = NULL;
   ccolor[0] = ccolor[1] = ccolor[2] = 255;
}


/* ***********************************************************************
*********************************************************************** */
void rasterfont::set_color(char r, char g, char b) {

   ccolor[0] = r;
   ccolor[1] = g;
   ccolor[2] = b;
}


/* ***********************************************************************
*********************************************************************** */
int rasterfont::read_data(char *filename) {

   char token[MAXSTRLEN];
   FILE *infile;
   int i, j, count;

   if (vfont) {
      delete [] vfont;
      vfont = NULL;
   }

   vfont = new rasterchar[256];

   if (!find_file(filename, "r", TEXTURE_PATH.string, (char)PLATFORM_SLASH, NULL, &infile)) {
      sprintf(perror_buffer, "Error: Cannot access %s...\n", filename);
      pprintf(perror_buffer);
      return 0;
   }

   get_token(infile, token);
   if (strcmp(token, "FONT")) {
      sprintf(perror_buffer, "Error: Invalid font %s...\n", filename);
      pprintf(perror_buffer);
      fclose(infile);
      return 0;
   }
   
   fontname.stringcpy(filename);
   font_scale = 0;

   get_token(infile, token);
   for (i=0, count=atoi(token); i<count; i++) {
      get_token(infile, token);
      j = (!strcmp(token, "SPACE")) ? ' ' : token[0];

      vfont[j].read_data(infile);
   }

   fclose(infile);
   return 1;
}


/* ***********************************************************************
*********************************************************************** */
int rasterfont::pixel_length(unsigned char *str) {

   fixed_pt length = 0;

   for (; *str; str++)
      length += vfont[*str].fssize;

   return FIXED_TO_INT(length);
}


/* ***********************************************************************
*********************************************************************** */
void rasterfont::set_scale(float x) {

   int i;

   if (fabs(font_scale-x) < CORRECT)
      return;
      
   font_scale = x;

   for (i=0; i < 256; i++)
      if (vfont[i].tmap)
         vfont[i].fssize = FLOAT_TO_FIXED(x*vfont[i].fratio);
}


/* ***********************************************************************
*********************************************************************** */
void rasterfont::print(int x, int y, unsigned char *str, mapul *mapbuffer) {

   fixed_pt ur;
   vector2i ill, iur;
   rasterchar *v;
   
   iur[1] = (int)(y + font_scale);

   if (y >= (int)mapbuffer->maxy || iur[1] < 0 || x >= (int)mapbuffer->maxx || x + pixel_length(str) < 0)
      return;

   ill[1] = y;
   
   for (ur = INT_TO_FIXED(x); *str && ur < 0; str++, ur += vfont[*str].fssize);
	 
   for (iur[0] = FIXED_TO_INT(ur); *str && iur[0] < (int)mapbuffer->maxx; str++) {
      v = &vfont[*str];

      if (v->tmap) {
         ur += v->fssize;

         ill[0] = iur[0];
         iur[0] = FIXED_TO_INT(ur);

         complex->gfx->gfxPaste2D(mapbuffer, v->tmap, ccolor, ill, iur, v->ll, v->ur, GFX_INVISO);
      }

   }
   
}
