

#if !defined(GAMENOCHECKZ) || (!defined(GAMETRANS) && !defined(GAMENOZSET))
   int      *zdata = (int *)proc->zbuff.zdata;
#endif

   int      winx = proc->zbuff.maxx;
   int      winy = proc->zbuff.maxy;
   unsigned int *idata;

   edgetype *aet = NULL;
   edgetype *ptr, *qtr, *head, **btr;
   int      scany, scanxy, start, end;

   face_type *flist = &pot->flist[face];
   fixed_pt  gcolor[3], deltac[3];
   float     prenum;
   union     { int i; float f; } prediv;
   float     dy, predx;

   float div;
   vector4uc rcolor;

   idata = proc->zbuff.data;

   head = et[face];
   et[face] = NULL;

   scany  = head->starty;
   scanxy = scany*winx;

   div = 1.0f/flist->normal[3];
   flist->normal[0] *= div;
   flist->normal[1] *= div;

   prenum = parm->imscale*flist->normal[0];
   dy     = parm->imscale*flist->normal[1];
   predx  = parm->vrc[0]*flist->normal[0] + parm->vrc[2]*flist->normal[1] - flist->normal[2]*div;

   while (scany < winy) {

      // add new edges to aet
      while (head && head->starty == scany) {
         ptr = head;
         head = (edgetype *)head->next;
         ptr->start.point[1] = predx + ptr->starty*dy;
         fixed_sortbucket(&aet, ptr);
      }

      if (!aet)
         break;

      // scan each pair of edges
      for (ptr=aet; ptr; ptr=(edgetype *)qtr->next) {

         qtr = (edgetype *)ptr->next;

         start = FIXED_TO_INT(ptr->start.fxpoint[0]);
         end   = FIXED_TO_INT(qtr->start.fxpoint[0]);

         if (start == end)
            continue;

         prediv.f = ptr->start.point[1] + start*prenum;

         div = ((gengine *)proc)->xbuff[end-start];

         // setup delta gouraud
         deltac[0] = (int)((qtr->start.fxcolor[0] - ptr->start.fxcolor[0])*div);
         deltac[1] = (int)((qtr->start.fxcolor[1] - ptr->start.fxcolor[1])*div);
         deltac[2] = (int)((qtr->start.fxcolor[2] - ptr->start.fxcolor[2])*div);

         copyarray3(gcolor, ptr->start.fxcolor);

         for (start += scanxy, end += scanxy; start<end; prediv.f += prenum, start++, gcolor[0] += deltac[0], gcolor[1] += deltac[1], gcolor[2] += deltac[2]) {

#ifndef GAMENOCHECKZ
            if (prediv.i <= zdata[start])
	       continue;
#endif

            // calc lighting
            setcolor(rcolor, gcolor);

#ifdef GAMETRANS
            set_trans(idata[start], rcolor);
#elif defined GAMENOZSET
            set_nzbuff(idata[start], rcolor);
#else
            set_zbuff(zdata[start], idata[start], prediv.i, rcolor);
#endif

         }

      }

      // increment counters
      scany++;
      scanxy += winx;

      if (scany >= winy)
         break;

      // update aet for next row
      for (ptr = aet, btr = &aet; ptr;) {

         if (scany >= ptr->endy) {
            *btr = (edgetype *)ptr->next;
            proc->control->push(MM_EDGE, ptr);
            ptr = *btr;
            continue;
         }

         addarray3(ptr->start.fxcolor, ptr->fxdcolor);
         ptr->start.fxpoint[0] += ptr->fxdx;
         ptr->start.point[1]   += dy;
         btr = (edgetype **)&ptr->next;
         ptr = (edgetype *)ptr->next;
      }

   }

   // garbage collection

   while (aet) {
      ptr=aet;
      aet=(edgetype *)aet->next;
      proc->control->push(MM_EDGE, ptr);
   }

   while (head) {
      ptr=head;
      head=(edgetype *)head->next;
      proc->control->push(MM_EDGE, ptr);
   }

