

#include <stdlib.h>
#include <string.h>

#include "gamegine.h"
#include "spb_load.h"
#include "polygame.h"
#include "anineutr.h"
#include "pstring.h"


/* *************************************************************
************************************************************* */
antineutron::antineutron() {

   ob = complex->gfx->gfxAllocRenderObject(OBJECT_POLYGON);

   ob->id = object_counter;
   object_counter++;

   colsphere = NULL;          // deleted by list
   duration = 1.0f;
   flags |= GAMEFLAG_PHYSICAL;
}


/* *************************************************************
************************************************************* */
int antineutron::query_whatwasi(int type) {

   return antineutron::query_whatami() == type ? 1 : gamequark::query_whatwasi(type);
}


/* *************************************************************
************************************************************* */
void antineutron::preprocess(void *data) {

   string_type buffer;
   int i;
   file_loader *loader;

   gamequark::preprocess(data);

   if (!((frame_manager *)global_resource_manager)->query_render())
      return;

   buffer.stringcpy(((polygon *)ob)->filename.string);
   for (i=buffer.stringlen(); i > -1 && buffer.string[i] != '.'; i--);

   if (i) {
      loader = (file_loader *)global_resource_manager->find_resource_object(RESOURCE_POLYGON_LOADER, ((polygon *)ob)->filename.string, NULL);

      if (!loader || !loader->read_data()) {
         sprintf(perror_buffer, "Error: Could not load \"%s\"... Aborting...\n", ((polygon *)ob)->filename.string);
         pprintf(perror_buffer);
         exit(0);
      }

      buffer.string[i+1] = 0;
      buffer.recalc();
      buffer.stringcat("col");
      colsphere = (spheretype *)loader->extract(FILETYPE_SPHERE, buffer.string);
      loader->cleanup();
   }

}


/* *************************************************************
************************************************************* */
int antineutron::parse(FILE *infile, char *token) {

   if (!strcmp(token, TOKEN_DURATION_STR)) {
      get_token(infile, token);
      duration = (float)atof(token);
      return 1;
   }

   return gamequark::parse(infile, token);
}


/* *************************************************************
************************************************************* */
void antineutron::begin(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx) {

   complex->gfx->gfxPolygonIncrementTime((polygon *)ob, complex->timer.speedscale/duration);
   quark::begin(hiearchy_manager, parent, mx);
}


/* *************************************************************
************************************************************* */
void antineutron::whereami(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx) {

   complex->gfx->gfxPolygonIncrementTime((polygon *)ob, complex->timer.speedscale/duration);
   quark::whereami(hiearchy_manager, parent, mx);
}


/* *************************************************************
************************************************************* */
int antineutron::obj_vs_lineseg(float *start, float *end, float *midpt, float radius, float *pos, float *normal, int level) {

   polytype *poly;
   polygon_object_type *pot;
   
   char *face_index;
   vector4f v1, v2;
   vector3f imidpt, ray;
   float imid_radius;
   int i;
   float t;
   sphere_block *sblock;

   if (!colsphere || !ob)
      return 0;

   if (!query_sphere_sphere_intersect(midpt, radius, old_state.bcenter, old_state.bradius))
      return 0;

   poly = ((polygame *)ob)->get_render_object();
   if (!poly)
      return 0;

   pot = (polygon_object_type *)poly->query_data();
   sblock = (sphere_block *)colsphere->query_data();

   if (!sblock || !sblock->countsphere)
      return 0;

   if (!(old_state.state_flags & STATE_FLAG_INVERSE)) {
      inversemx(old_state.xmx, old_state.ixmx);
      old_state.state_flags |= STATE_FLAG_INVERSE;
   }
   
   matvecmulto(old_state.ixmx, start, v1);
   matvecmulto(old_state.ixmx, end, v2);

   subeqarray3(ray, v2, v1);
   imid_radius = (float)(magnitude3(ray) * 0.5);
   imidpt[0] = (v1[0] + v2[0]) * 0.5f;
   imidpt[1] = (v1[1] + v2[1]) * 0.5f;
   imidpt[2] = (v1[2] + v2[2]) * 0.5f;

   i = (poly->countobject + 3) & 0xfffffffc;
   face_index = (char *)proc.control->pop(MM_BUFFER, i);
   memset(face_index, 0, i);

   i = 0;
   if (!sblock->slist[0].lineseg_collision(sblock->slist, pot, face_index, imidpt, imid_radius, ray, v1, v2, pos, normal, &i, &t, level))
      return 0;

   matvecmultv(old_state.xmx, normal);
   normalize3(normal);
   matvecmulto(old_state.xmx, pos);
   return 1;
}


/* *************************************************************
************************************************************* */
int antineutron::obj_vs_line(float *pt, float *ray, float *pos, float *normal, int level) {

   polytype *poly;
   polygon_object_type *pot;
   sphere_block *sblock;
   vector3f vray;
   vector4f vpt;
   char *face_index;
   int i;
   float t;
   
   if (!colsphere || !ob)
      return 0;

   poly = ((polygame *)ob)->get_render_object();
   if (!poly)
      return 0;

   pot = (polygon_object_type *)poly->query_data();
   sblock = (sphere_block *)colsphere->query_data();

   if (!sblock || !sblock->countsphere)
      return 0;

   if (!(old_state.state_flags & STATE_FLAG_INVERSE)) {
      inversemx(old_state.xmx, old_state.ixmx);
      old_state.state_flags |= STATE_FLAG_INVERSE;
   }
   
   matvecmultv(old_state.ixmx, ray, vray);
   normalize3(vray);
   
   matvecmulto(old_state.ixmx, pt, vpt);

   i = (poly->countobject + 3) & 0xfffffffc;
   face_index = (char *)proc.control->pop(MM_BUFFER, i);
   memset(face_index, 0, i);

   i = 0;
   if (!sblock->slist[0].line_collision(sblock->slist, pot, face_index, vpt, vray, pos, normal, &i, &t, level))
      return 0;

   matvecmultv(old_state.xmx, normal);
   normalize3(normal);
   matvecmulto(old_state.xmx, pos);
   return 1;
}


/* *************************************************************
************************************************************* */
antifxneutron::antifxneutron() {

   delete ob;
   
   ob = complex->gfx->gfxAllocRenderObject(OBJECT_FXPOLYGON);

   ob->id = object_counter;
   object_counter++;
}


/* *************************************************************
************************************************************* */
void polygame::preprocess(void *data) {

   string_type buffer;

   buffer.stringcpy(filename.string);
   filename.stringcpy(FILENAME_PRESPG);
   filename.stringcat(&buffer);
   
   buffer.stringcpy(colorname.string);
   colorname.stringcpy(FILENAME_PREILM);
   colorname.stringcat(&buffer);
   
   buffer.stringcpy(texname2.string);
   texname2.stringcpy(FILENAME_PRESPG);
   texname2.stringcat(&buffer);
   
   polygon::preprocess(data);

   last_frame = 0;
}


/* **************************************************
************************************************** */
void polygame::datacopy() {

   polyflag = 0;

   mctype.datacopy();
   mcinfo.datacopy();

   ob->build(dob->countvertex, dob->countobject, dob->countedge);
   ob->maxpolynum = dob->maxpolynum;

   pot = (polygon_object_type *)ob->query_data();

   base_color = &lob->base;
   sblock = (shade_block *)lob->query_data();

   if (mcinfo.info & CITEXTURE)
      uvblock = (texface *)tob->query_data();
}


/* **************************************************
************************************************** */
int polygame::scan(camera *cparm, light *lmain, engine *proc) {

   face_type *flist, *fend, *dlist;
   int i;
   vector4f mx[4];
   vector3f work, cam;
   float *vlist, *dvlist, *vend;
   int *olist;
   polygon_object_type *dot;
   float t1, t2;
   shadetype **slist;

   proc->countvertex += ob->countvertex;

   dot = (polygon_object_type *)dob->query_data();

   // build edge list
   olist = pot->vindex;
   for (i=0; i<ob->countedge; i++)
      olist[i] = dot->vindex[i];

   // build matricies
   matmatmulto(cparm->transform, rotate, world);
   
   // rotate/recalc normal mx
   work[0] = dotproduct3(world[0], world[0]);
   work[1] = dotproduct3(world[1], world[1]);
   work[2] = dotproduct3(world[2], world[2]);
   t1 = work[0] - work[1];
   t2 = work[1] - work[2];

   fend = pot->flist + ob->countobject;

   // if we have a skew/shear matrix, then recalc normals
   if (t1*t1 > CORRECT || t2*t2 > CORRECT) {
      inversemx(world, iworld);

      // calc camera position in object space
      cam[0] = iworld[0][3];
      cam[1] = iworld[1][3];
      cam[2] = iworld[2][3];
      
      for (flist=pot->flist, dlist=dot->flist, slist=sblock->facelist; flist<fend; olist+=dlist->polynum, flist++, dlist++, slist++) {
         subeqarray3(work, dot->vlist[dlist->edgeptr[0]], cam);

         if (dotproduct3(work, dlist->normal) > 0)
            flist->polynum = 0;
         else {
            flist->polynum = dlist->polynum;
            flist->edgeptr = olist;
            flist->iarea    = dlist->iarea;
            lmain->set_ambient((*slist)->ka, flist->ambient, (*slist)->lum);
         }

      }

      // build vertex list
      vend = (float *)&pot->vlist[ob->countvertex];
      for (vlist=(float *)pot->vlist, dvlist=(float *)dot->vlist; vlist<vend; vlist+=4, dvlist+=4)
         matvecmulto(world, dvlist, vlist);

      // recalc vertex normals
      ob->calc_normal();

      // recalc vertex normals
      if (mctype.model == GOURAUD)
         ob->calc_vnormal();
   }

   else {
      inversemxrt(world, iworld);

      // calc camera position in object space
      cam[0] = iworld[0][3];
      cam[1] = iworld[1][3];
      cam[2] = iworld[2][3];

      copymx4x4o(mx, world);
      t1 = (float)(1.0/sqrt(work[0]));
      smultarray3(mx[0], t1);
      smultarray3(mx[1], t1);
      smultarray3(mx[2], t1);

      // rotate vertex normals
      if (mctype.model == GOURAUD) {
         vend = (float *)&pot->nlist[ob->countvertex];
         for (vlist=(float *)pot->nlist, dvlist=(float *)dot->nlist; vlist<vend; vlist+=3, dvlist+=3)
            matvecmultv(mx, dvlist, vlist);
      }

      // build vertex list
      vend = (float *)&pot->vlist[ob->countvertex];
      for (vlist=(float *)pot->vlist, dvlist=(float *)dot->vlist; vlist<vend; vlist+=4, dvlist+=4)
         matvecmulto(world, dvlist, vlist);

      for (flist=pot->flist, dlist=dot->flist, slist=sblock->facelist; flist<fend; olist+=dlist->polynum, flist++, dlist++, slist++) {
         subeqarray3(work, dot->vlist[dlist->edgeptr[0]], cam);
         if (dotproduct3(work, dlist->normal) > 0)
            flist->polynum = 0;
         else {
            matvecmultv(mx, dlist->normal, flist->normal);
            flist->normal[3] = -dotproduct3(flist->normal, pot->vlist[*olist]);

            flist->polynum = dlist->polynum;
            flist->edgeptr = olist;
            flist->iarea    = dlist->iarea;
            lmain->set_ambient((*slist)->ka, flist->ambient, (*slist)->lum);
         }

      }

   }

   return renderflag = bound_box(cparm) && polyclet(cparm, lmain, proc->zbuff.maxx, proc->zbuff.maxy, proc);
}


/* *************************************************************
   gouraud calculated here cause each face has different color
************************************************************* */
pointlisttype *polygame::edgelist(eye *parm, light *lmain, int i, int texture_flag, memman *control) {

   pointlisttype *ptr, *head;
   int j, k;
   face_type *flist = &pot->flist[i];
   int *sindex;
   int index;

   k = flist->polynum;
   head = NULL;

   for (j=0, sindex=flist->edgeptr; j<k; j++) {
      index = sindex[j];

      ptr = (pointlisttype *)control->pop(MM_POINTLIST);

      copyarray3(ptr->pt.point, pot->vlist[index]);

      if (texture_flag)
         tob->query_uvmap(i, j, ptr->pt.uvz);

      if (mctype.model == GOURAUD) {
         copyarray3(ptr->pt.color, flist->ambient);
         if (lmain)
            lmain->intensity(ptr->pt.point, pot->nlist[index], ptr->pt.color, parm, sblock->facelist[i], id);
      }

      ptr->next = head;
      head = ptr;
   }

   return head;
}


/* **************************************************
************************************************** */
void polygame::prepare_edge(engine *proc, int face, pointtype *start, pointtype *end, int starty, int endy, int texture_flag) {

   float    deltay;
   edgetype **btr;
   edgetype *ptr, *qtr;

   deltay = ((gengine *)proc)->ybuff[endy-starty] * 65536.0f;

   proc->countedge++;

   ptr = (edgetype *)proc->control->pop(MM_EDGE);

   ptr->starty = starty;
   ptr->endy = endy;

   ptr->start.fxpoint[0] = ((int)(start->point[0]*65536.0f)) + 0x8000;
   ptr->fxdx = (int)((end->point[0] - start->point[0]) * deltay);

   for (btr=&et[face], qtr=et[face]; qtr && starty > qtr->starty; btr=(edgetype **)&qtr->next, qtr=(edgetype *)qtr->next);

   ptr->next = qtr;
   *btr = ptr;

   if (mctype.model == GOURAUD) {
      ptr->start.fxcolor[0] = FLOAT_TO_FIXED(start->color[0]);
      ptr->start.fxcolor[1] = FLOAT_TO_FIXED(start->color[1]);
      ptr->start.fxcolor[2] = FLOAT_TO_FIXED(start->color[2]);

      ptr->fxdcolor[0] = (int)((end->color[0] - start->color[0]) * deltay);
      ptr->fxdcolor[1] = (int)((end->color[1] - start->color[1]) * deltay);
      ptr->fxdcolor[2] = (int)((end->color[2] - start->color[2]) * deltay);
   }

   if (texture_flag) {
      deltay *= 256.0f;

      ptr->start.fxuvz[0] = FLOAT_TO_NORMALIZED_FIXED(start->uvz[0]);
      ptr->start.fxuvz[1] = FLOAT_TO_NORMALIZED_FIXED(start->uvz[1]);

      ptr->fxduvz[0] = (int)((end->uvz[0] - start->uvz[0]) * deltay);
      ptr->fxduvz[1] = (int)((end->uvz[1] - start->uvz[1]) * deltay);
   }

}


/* **************************************************
************************************************** */
void polygame::render(camera *cparm, light *lmain, light *spot, engine *proc) {

   int tflag = (mcinfo.info & CITEXTURE) == CITEXTURE;
   int i;

   int rendermask = 0;

   if ((mcinfo.info & CIOVERWRITE) == CIOVERWRITE)
      rendermask |= GAME_NOZCHECK;

   if ((mcinfo.info & CIGHOST) == CIGHOST)
      rendermask |= GAME_NOZSET;

   if (mctype.model == GOURAUD)
      rendermask |= GAME_GOURAUD;

   if ((mcinfo.info & CITRANSPARENT) == CITRANSPARENT)
      rendermask |= GAME_TRANSPARENT;

   switch (rendermask) {

      case 0x00:            // constant true color
         for (i=0; i<ob->countobject; i++)
            if (et[i])
               (tflag && tob->query_tflag(i)) ? gametex_0x00(cparm, proc, i) : game_0x00(cparm, proc, i);

         return;

      case 0x01:        // constant true color overwrite
         for (i=0; i<ob->countobject; i++)
            if (et[i])
               (tflag && tob->query_tflag(i)) ? gametex_0x01(cparm, proc, i) : game_0x01(cparm, proc, i);

         return;

      case 0x02:        // constant true color ghost
         for (i=0; i<ob->countobject; i++)
            if (et[i])
               (tflag && tob->query_tflag(i)) ? gametex_0x02(cparm, proc, i) : game_0x02(cparm, proc, i);

         return;

      case 0x03:        // constant true color overwrite ghost
         for (i=0; i<ob->countobject; i++)
            if (et[i])
               (tflag && tob->query_tflag(i)) ? gametex_0x03(cparm, proc, i) : game_0x02(cparm, proc, i);

         return;

      case 0x04:        // constant true color transparent
      case 0x06:        // constant true color ghost transparent
         for (i=0; i<ob->countobject; i++)
            if (et[i])
               (tflag && tob->query_tflag(i)) ? gametex_0x04(cparm, proc, i) : game_0x04(cparm, proc, i);

         return;

      case 0x05:        // constant true color overwrite transparent
      case 0x07:        // constant true color overwrite ghost transparent
         for (i=0; i<ob->countobject; i++)
            if (et[i])
               (tflag && tob->query_tflag(i)) ? gametex_0x05(cparm, proc, i) : game_0x05(cparm, proc, i);

         return;

      case 0x08:            // gouraud true color
         for (i=0; i<ob->countobject; i++)
            if (et[i])
               (tflag && tob->query_tflag(i)) ? gametex_0x08(cparm, proc, i) : game_0x08(cparm, proc, i);

         return;

      case 0x09:        // gouraud true color overwrite
         for (i=0; i<ob->countobject; i++)
            if (et[i])
               (tflag && tob->query_tflag(i)) ? gametex_0x09(cparm, proc, i) : game_0x09(cparm, proc, i);

         return;

      case 0x0a:        // gouraud true color ghost
         for (i=0; i<ob->countobject; i++)
            if (et[i])
               (tflag && tob->query_tflag(i)) ? gametex_0x0a(cparm, proc, i) : game_0x0a(cparm, proc, i);

         return;

      case 0x0b:        // gouraud true color overwrite ghost
         for (i=0; i<ob->countobject; i++)
            if (et[i])
               (tflag && tob->query_tflag(i)) ? gametex_0x0b(cparm, proc, i) : game_0x0b(cparm, proc, i);

         return;

      case 0x0c:        // gouraud true color transparent
      case 0x0e:        // gouraud true color ghost transparent
         for (i=0; i<ob->countobject; i++)
            if (et[i])
               (tflag && tob->query_tflag(i)) ? gametex_0x0c(cparm, proc, i) : game_0x0c(cparm, proc, i);

         return;

//      case 0x0d:        // gouraud true color overwrite transparent
//      case 0x0f:        // gouraud true color overwrite ghost transparent
      default:
         for (i=0; i<ob->countobject; i++)
            if (et[i])
               (tflag && tob->query_tflag(i)) ? gametex_0x0d(cparm, proc, i) : game_0x0d(cparm, proc, i);

         return;
   }

}


/* *************************************************************
   note: bypasses "polygame::query_whatami()" as it doesnt have a type
************************************************************* */
int fxpolygame::query_whatwasi(int type) {

   return fxpolygame::query_whatami() == type ? 1 : polygon::query_whatwasi(type);
}


/* *************************************************************
************************************************************* */
void fxpolygame::preprocess(void *data) {

   // note: bypass polygame/polygon::preprocess() - intentional
   pc::preprocess(data);

   last_frame = 0;
}


/* *************************************************************
************************************************************* */
int fxpolygame::scan(camera *cparm, light *lmain, engine *proc) {

   return (!dob || !lob || ((mcinfo.info & CITEXTURE) && !tob)) ? 0 : polygame::scan(cparm, lmain, proc);
}


/* *************************************************************
************************************************************* */
void fxpolygame::set_ob_data(polytype *fxdob, shadelist *fxlob, texpolygon *fxtob, unsigned int shade, unsigned int flags) {

   dob = fxdob;
   lob = fxlob;
   tob = fxtob;
  
   mcinfo.mask_and(CINULL);
   mcinfo.mask_or(flags);

   mctype.set_master((colortype)shade);
}
