

#if !defined(GAMENOCHECKZ) || (!defined(GAMETRANS) && !defined(GAMENOZSET))
   int      *zdata = (int *)proc->zbuff.zdata;
#endif

   int      winx = proc->zbuff.maxx;
   int      winy = proc->zbuff.maxy;
   unsigned int *idata;

   edgetype *aet = NULL;
   edgetype *ptr, *qtr, *head, **btr;
   int      scany, scanxy, start, end;

   face_type *flist = &pot->flist[face];
   vector3f  gcolor;
   float     prenum;
   union     { int i; float f; } prediv;
   float     dy, predx;

   flt2int_type d0, d1, d2;
   float div;
   vector4uc rcolor;
   
   idata = proc->zbuff.data;

   head = et[face];
   et[face] = NULL;

   scany  = head->starty;
   scanxy = scany*winx;

   addeqarray3(gcolor, flist->color, flist->ambient);

   F2I(d0, gcolor[0]);
   F2I(d1, gcolor[1]);
   F2I(d2, gcolor[2]);

   setsimplecolor(rcolor, d0, d1, d2);

   div = 1.0f/flist->normal[3];
   flist->normal[0] *= div;
   flist->normal[1] *= div;

   prenum = parm->imscale*flist->normal[0];
   dy     = parm->imscale*flist->normal[1];
   predx  = parm->vrc[0]*flist->normal[0] + parm->vrc[2]*flist->normal[1] - flist->normal[2]*div;

   while (scany < winy) {

      // add new edges to aet
      while (head && head->starty == scany) {
         ptr = head;
         head = (edgetype *)head->next;
         ptr->start.point[1] = predx + ptr->starty*dy;
         fixed_sortbucket(&aet, ptr);
      }

      if (!aet)
         break;

      // scan each pair of edges
      for (ptr=aet; ptr; ptr=(edgetype *)qtr->next) {

         qtr = (edgetype *)ptr->next;

         start = FIXED_TO_INT(ptr->start.fxpoint[0]);
         end   = FIXED_TO_INT(qtr->start.fxpoint[0]);

         if (start == end)
            continue;

         prediv.f = ptr->start.point[1] + start*prenum;

         for (start += scanxy, end += scanxy; start<end; prediv.f += prenum, start++) {

#ifndef GAMENOCHECKZ
            if (prediv.i <= zdata[start])
	       continue;
#endif

#ifdef GAMETRANS
            set_trans(idata[start], rcolor);
#elif defined GAMENOZSET
            set_nzbuff(idata[start], rcolor);
#else
            set_zbuff(zdata[start], idata[start], prediv.i, rcolor);
#endif

         }

      }

      // increment counters
      scany++;
      scanxy += winx;

      if (scany >= winy)
         break;

      // update aet for next row
      for (ptr = aet, btr = &aet; ptr;) {

         if (scany >= ptr->endy) {
            *btr = (edgetype *)ptr->next;
            proc->control->push(MM_EDGE, ptr);
            ptr = *btr;
            continue;
         }

         ptr->start.fxpoint[0] += ptr->fxdx;
         ptr->start.point[1]   += dy;
         btr = (edgetype **)&ptr->next;
         ptr = (edgetype *)ptr->next;
      }

   }

   // garbage collection

   while (aet) {
      ptr=aet;
      aet=(edgetype *)aet->next;
      proc->control->push(MM_EDGE, ptr);
   }

   while (head) {
      ptr=head;
      head=(edgetype *)head->next;
      proc->control->push(MM_EDGE, ptr);
   }

