

#include "gamegine.h"
#include "pntgame.h"


/* **************************************************************************
*************************************************************************** */
void pointgame::render(camera *cparm, light *lmain, light *spot, engine *proc) {

   float          *zdata = proc->zbuff.zdata;
   unsigned int   *idata = proc->zbuff.data;

   int index;
   flt2int_type d0, d1, d2;
   vector4uc rcolor;
   float prediv;

   if (!((mcinfo.info & CIGHOST) && (mcinfo.info & CIOVERWRITE)))
      prediv = 1.0f/wwai[2];

   index = iwai[1]*proc->zbuff.maxx + iwai[0];

   if ((mcinfo.info & CIOVERWRITE) || prediv < zdata[index]) {

      // setup gouraud
      F2I(d0, wcolor[0]);
      F2I(d1, wcolor[1]);
      F2I(d2, wcolor[2]);

      setsimplecolor(rcolor, d0, d1, d2);

      if (mcinfo.info & CITRANSPARENT) {
         set_trans(idata[index], rcolor);
      }

      else if (mcinfo.info & CIGHOST) {
         set_nzbuff(idata[index], rcolor);
      }

      else {
         set_zbuff(zdata[index], idata[index], prediv, rcolor);
      }

   }

}
