

#include "pcloud.h"
#include "gamegine.h"


#define MODE_TRANSPARENT 0
#define MODE_GHOST       1
#define MODE_DEFAULT     2


/* *************************************************************
************************************************************* */
int pcloud::query_whatwasi(int type) {

   return (pcloud::query_whatami() == type) ? 1 : pc::query_whatwasi(type);
}


/* *************************************************************
************************************************************* */
void pcloud::preprocess(void *data) {

   pc::preprocess(data);

   smultarray3(rotate[0], size);
   smultarray3(rotate[1], size);
   smultarray3(rotate[2], size);

   rotate[0][3] += center[0];
   rotate[1][3] += center[1];
   rotate[2][3] += center[2];

   if (!((frame_manager *)global_resource_manager)->query_render())
      return;
}


/* *************************************************************
************************************************************* */
void pcloud::bound_sphere() {

   int i, j;
   vector3f min, max;
   float t, temp;
   
   if (!count)
      return;

   if (recalc_bound_flag) {
      min[0] = max[0] = cloud[0].pos[0];
      min[1] = max[1] = cloud[0].pos[1];
      min[2] = max[2] = cloud[0].pos[2];
         
      for (i=1; i<count; i++) {
         for (j=0; j<3; j++)
            if (min[j] > cloud[i].pos[j])
               min[j] = cloud[i].pos[j];
            else if (max[j] < cloud[i].pos[j])
               max[j] = cloud[i].pos[j];
      }
   	          
      local_bcenter[0] = 0.5f *(min[0] + max[0]);    
      local_bcenter[1] = 0.5f *(min[1] + max[1]);    
      local_bcenter[2] = 0.5f *(min[2] + max[2]);    
      local_bcenter[3] = 1.0f;
      
      subarray3(max, min);
      local_bradius2 = 0.25f * dotproduct3(max, max);
   }
   
   t = rotate[0][0]*rotate[0][0] + rotate[1][0]*rotate[1][0] + rotate[2][0]*rotate[2][0];

   temp = rotate[0][1]*rotate[0][1] + rotate[1][1]*rotate[1][1] + rotate[2][1]*rotate[2][1];
   if (temp > t)
      t = temp;

   temp = rotate[0][2]*rotate[0][2] + rotate[1][2]*rotate[1][2] + rotate[2][2]*rotate[2][2];
   if (temp > t)
      t = temp;

   matvecmulto(rotate, local_bcenter, bcenter);
   bradius = (float)sqrt(t*local_bradius2);
   bvalid_flag = 1;
}


/* *************************************************************
************************************************************* */
void pcloud::begin_scan() {

   if (count)
      wcloud = new work_particulate[count];

   renderflag = 0;
}

      
/* *************************************************************
************************************************************* */
void pcloud::end_scan() {

   if (wcloud) {
      delete [] wcloud;
      wcloud = NULL;
   }
   
}
      

/* *************************************************************
************************************************************* */
int pcloud::scan(camera *cparm, light *lmain, engine *proc) {

   int i;
   vector3f v;
   vector2i pt;
   int maxx = proc->zbuff.maxx-1;
   int maxy = proc->zbuff.maxy-1;
   int zdataflag = !((mcinfo.info & CIGHOST) && (mcinfo.info & CIOVERWRITE));
   
   // build matricies
   matmatmulto(cparm->transform, rotate, world);
//   inversemx(world, iworld);
   
   // transform/clip
   for (i=0; i<count; i++) {
      v[2] = dotproduct3(world[2], cloud[i].pos) + world[2][3];

      if (v[2] > front) {
         wcloud[i].flags = FLAG_PARTICULATE_NULL;
	 continue;
      }
      	
      v[0] = dotproduct3(world[0], cloud[i].pos) + world[0][3];
      v[1] = dotproduct3(world[1], cloud[i].pos) + world[1][3];

      cparm->map2screen(v);
      
      pt[0] = (int)(v[0] + 0.5);
      if (pt[0] < 0 || pt[0] > maxx) {
         wcloud[i].flags = FLAG_PARTICULATE_NULL;
	 continue;
      }
         
      pt[1] = (int)(v[1] + 0.5);
      if (pt[1] < 0 || pt[1] > maxy) {
         wcloud[i].flags = FLAG_PARTICULATE_NULL;
	 continue;
      }

      if (zdataflag)       
         wcloud[i].iz = (float)(1.0/v[2]);

      copyarray2(wcloud[i].pt, pt);
      wcloud[i].flags = FLAG_PARTICULATE_VISIBLE;
      renderflag = 1;
   }
   
   return renderflag;
}


/* **************************************************************************
*************************************************************************** */
void pcloud::render(camera *cparm, light *lmain, light *spot, engine *proc) {

   float          *zdata = proc->zbuff.zdata;
   unsigned int   *idata = proc->zbuff.data;

   int index;
   flt2int_type d0, d1, d2;
   vector4uc rcolor;
   float prediv;
   int i;
   int mode;
   
   if (mcinfo.info & CITRANSPARENT)
      mode = MODE_TRANSPARENT;
   else if (mcinfo.info & CIGHOST)
      mode = MODE_GHOST;
   else
      mode = MODE_DEFAULT;
      
   for (i=0; i<count; i++) {
      if (!(wcloud[i].flags & FLAG_PARTICULATE_VISIBLE))
         continue;
	 
      prediv = wcloud[i].iz;
      index = wcloud[i].pt[1]*proc->zbuff.maxx + wcloud[i].pt[0];

      if ((mcinfo.info & CIOVERWRITE) || prediv < zdata[index]) {

         // setup gouraud
         d0.iflt2int[0] = cloud[i].color[0];
         d1.iflt2int[0] = cloud[i].color[1];
         d2.iflt2int[0] = cloud[i].color[2];

         setsimplecolor(rcolor, d0, d1, d2);

         switch (mode) {
            case MODE_TRANSPARENT:
               set_trans(idata[index], rcolor);
               break;

            case MODE_GHOST:
               set_nzbuff(idata[index], rcolor);
               break;

            default:
               set_zbuff(zdata[index], idata[index], prediv, rcolor);
               break;
         }

      }
      
   }

}

