

#include "gamegine.h"

#include <GL/gl.h>

#ifdef WIN32
#include "win_wgl.h"
#endif

#include "flat.h"
#include "polygame.h"
#include "pcloud.h"


/* *************************************************************
************************************************************* */
int glflat::query_whatwasi(int type) {

   return (glflat::query_whatami() == type) ? 1 : glpolygon::query_whatwasi(type);
}


/* *************************************************************
exact same as flat() - argument for multi-inheritance?
************************************************************* */
void glflat::preprocess(void *data) {

   string_type buffer;

   last_frame = 0;

   buffer.stringcpy(&colorname);
   colorname.stringcpy(FILENAME_PREILM);
   colorname.stringcat(&buffer);

   if (mctype.query_master() > CONSTANT)
      mctype.set_master(CONSTANT);

   // note: bypass polygon::preprocess() - intentional
   pc::preprocess(data);

   smultarray3(rotate[0], size);
   smultarray3(rotate[1], size);
   smultarray3(rotate[2], size);

   rotate[0][3] += center[0];
   rotate[1][3] += center[1];
   rotate[2][3] += center[2];

   if (!((frame_manager *)global_resource_manager)->query_render())
      return;

   if (colorname.string[0])
      lob = (shadelist *)((frame_manager *)global_resource_manager)->read_ilm(colorname.string, 1);

   read_tex(texname2.string, texname2.string);
   dob = build_flat_data();
}


/* *************************************************************
exact same as flat() - argument for multi-inheritance?
************************************************************* */
int glflat::read_tex(char *filename, char *dfilename) {

   texbase *tmap;
   vector2f uv[4];
   
   tob = (texpolygon *)global_resource_manager->find_resource_object(RESOURCE_UVCOORD, dfilename, filename);

   if (tob)
      return 1;

   tmap = (texbase *)((frame_manager *)global_resource_manager)->read_tex(filename);

   tob = new texpolygon;
   tob->altname.stringcpy(filename);
   tob->dataname.stringcpy(dfilename);

   global_resource_manager->register_resource_object(RESOURCE_UVCOORD, tob);

   tob->setup(1);

   if (tmap) {
      uv[0][0] = 0;
      uv[0][1] = 0;
      uv[1][0] = 0;
      uv[1][1] = 1.0f;
      uv[2][0] = 1.0f;
      uv[2][1] = 1.0f;
      uv[3][0] = 1.0f;
      uv[3][1] = 0;

      tob->direct2Dmap(0, uv, tmap, 4, 0);
   }

   else {
      sprintf(perror_buffer, "Warning: flat map \"%s\" not found...\n", filename);
      pprintf(perror_buffer);
   }

   return 1;
}


/* **************************************************
************************************************** */
void glflat::datacopy() {

   glpolygon::datacopy();
   
   if (lob)
      base_color = &lob->base;
}


/* **************************************************
************************************************** */
int glflat::scan(camera *cparm, light *lmain, engine *proc) {

   if (!current_tex_id)
      return renderflag = 0;

   proc->countvertex += dob->countvertex;
   proc->countface += dob->countobject;

   // transform objects
   polyflag |= POLYFLAG_BACKFACE_CULL | POLYFLAG_TRANSFORM;

   pot = (polygon_object_type *)dob->query_data();

   if (mcinfo.info & CITEXTURE)
      uvblock = (texface *)tob->query_data();

   return renderflag = 1;
}


/* **************************************************
************************************************** */
void glflat::render(camera *cparm, light *lmain, light *spot, engine *proc) {

   vector4f work;

   glMatrixMode(GL_MODELVIEW);

   if (mcinfo.info & CIBITMAP) {
      init_mx(world);

      world[0][0] = (float)sqrt(rotate[0][0]*rotate[0][0] + rotate[1][0]*rotate[1][0] + rotate[2][0]*rotate[2][0]);
      world[1][1] = (float)sqrt(rotate[0][1]*rotate[0][1] + rotate[1][1]*rotate[1][1] + rotate[2][1]*rotate[2][1]);

      work[0] = rotate[0][3];
      work[1] = rotate[1][3];
      work[2] = rotate[2][3];

      matvecmulto(cparm->transform, work);

      world[0][3] = work[0];
      world[1][3] = work[1];
      world[2][3] = work[2];

      glLoadTransposeMatrixf((GLfloat *)world);
   }

   else {
      glLoadTransposeMatrixf((GLfloat *)cparm->transform);
      glMultTransposeMatrixf((GLfloat *)rotate);
   }

   glColor3ub(base_color->lum[0], base_color->lum[1], base_color->lum[2]);

   glEnableClientState(GL_VERTEX_ARRAY);
   glVertexPointer(3, GL_FLOAT, 16, pot->vlist);

   render_material();

   glDisableClientState(GL_VERTEX_ARRAY);
}


/* **************************************************
************************************************** */
void glflat::render_material() {

   complex->gfx->gfxDisable(GFX_CULL_FACE);
   complex->gfx->gfxEnable(GFX_TEXTURE);

   complex->gfx->gfxSetTexture((basic_texture_block *)((texbase *)current_tex_id)->query_data());

   glEnableClientState(GL_TEXTURE_COORD_ARRAY);
   glTexCoordPointer(2, GL_FLOAT, 0, uvblock[0].uv);
   glDrawElements(GL_POLYGON, pot->flist[0].polynum, GL_UNSIGNED_INT, pot->flist[0].edgeptr);
   glDisableClientState(GL_TEXTURE_COORD_ARRAY);

   complex->gfx->gfxDisable(GFX_TEXTURE);
}


/* *************************************************************
************************************************************* */
unsigned int glflat::update_texture() {

   texbase *tex;

   tob->query_data(0, TEXTURE2D_QUERY_UNIT_TEXTURE, &last_frame, &tex);
   return current_tex_id = (unsigned int)tex;
}


/* *************************************************************
exact same as fxflat() - argument for multi-inheritance?
************************************************************* */
void glfxflat::preprocess(void *data) {

   string_type buffer;

   last_frame = 0;

   buffer.stringcpy(&colorname);
   colorname.stringcpy(FILENAME_PREILM);
   colorname.stringcat(&buffer);

   if (mctype.query_master() > CONSTANT)
      mctype.set_master(CONSTANT);

   // note: bypass glpolygon/glflat::preprocess() - intentional
   pc::preprocess(data);

   smultarray3(rotate[0], size);
   smultarray3(rotate[1], size);
   smultarray3(rotate[2], size);

   rotate[0][3] += center[0];
   rotate[1][3] += center[1];
   rotate[2][3] += center[2];

   if (!((frame_manager *)global_resource_manager)->query_render())
      return;

   if (colorname.string[0])
      lob = (shadelist *)((frame_manager *)global_resource_manager)->read_ilm(colorname.string, 1);

   dob = build_flat_data();

   tob = new texpolygon;
   tob->altname.stringcpy("");
   tob->dataname.stringcpy(DEFAULT_FLAT_NAME);

   global_resource_manager->register_resource_object(RESOURCE_UVCOORD, tob);

   tob->setup(1);
}


/* *************************************************************
exact same as fxflat() - argument for multi-inheritance?
************************************************************* */
void glfxflat::set_ob_data(texbase *tmap) {

   vector2f uv[4];

   if (!tmap)
      pprintf("WARNING: flat assigned NULL texture...\n");

   uv[0][0] = 0;
   uv[0][1] = 0;
   uv[1][0] = 0;
   uv[1][1] = 1.0f;
   uv[2][0] = 1.0f;
   uv[2][1] = 1.0f;
   uv[3][0] = 1.0f;
   uv[3][1] = 0;

   tob->direct2Dmap(0, uv, tmap, 4, 0);
}


/* *************************************************************
  same as polygame::preprocess()
************************************************************* */
void glpolygame::preprocess(void *data) {

   string_type buffer;

   buffer.stringcpy(&filename);
   filename.stringcpy(FILENAME_PRESPG);
   filename.stringcat(&buffer);

   buffer.stringcpy(&colorname);
   colorname.stringcpy(FILENAME_PREILM);
   colorname.stringcat(&buffer);

   buffer.stringcpy(&texname2);
   texname2.stringcpy(FILENAME_PRESPG);
   texname2.stringcat(&buffer);

   polygon::preprocess(data);

   last_frame = 0;
}


/* **************************************************
   This function scans polygonal data and puts it in a zbuffer.
************************************************** */
int glpolygame::scan(camera *cparm, light *lmain, engine *proc) {

   renderflag = 0;

   proc->countvertex += dob->countvertex;
   proc->countface += dob->countobject;

   // transform objects
   polyflag |= POLYFLAG_TRANSFORM;

   return renderflag = 1;
}


/* **************************************************
  Assumed default state:
  GL_LIGHTING - disabled
  GL_CULL_FACE - disabled
  GL_XXX_ARRAY's - disabled
  GL_DEPTH_TEST - enabled
************************************************** */
void glpolygame::render(camera *cparm, light *lmain, light *spot, engine *proc) {

   vector3f work;
   int i;
   float temp;
   int normalize_flag;

   glMatrixMode(GL_MODELVIEW);

   // if bitmap, remove rotation for bitmaps :)
   if (mcinfo.info & CIBITMAP) {
      copymx4x4o(world, rotate);

      work[0] = world[0][3];
      work[1] = world[1][3];
      work[2] = world[2][3];

      matvecmulto(cparm->transform, work);

      world[0][3] = work[0];
      world[1][3] = work[1];
      world[2][3] = work[2];

      glLoadTransposeMatrixf((GLfloat *)world);
   }

   else {
      glLoadTransposeMatrixf((GLfloat *)cparm->transform);
      glMultTransposeMatrixf((GLfloat *)rotate);
   }

   // if we have a skew/shear/scale matrix, then recalc normals
   work[0] = 1.0 - dotproduct3(rotate[0], rotate[0]);
   work[1] = 1.0 - dotproduct3(rotate[1], rotate[1]);
   work[2] = 1.0 - dotproduct3(rotate[2], rotate[2]);

   temp = (float)(1 + CORRECT);

   normalize_flag = work[0] > CORRECT || work[0] < -CORRECT ||
                    work[1] > CORRECT || work[1] < -CORRECT ||
                    work[2] > CORRECT || work[2] < -CORRECT;

   if (normalize_flag)
      glEnable(GL_NORMALIZE);

   glEnableClientState(GL_VERTEX_ARRAY);
   glVertexPointer(3, GL_FLOAT, 16, pot->vlist);

   switch (mctype.model) {

      case GOURAUD:
      case PHONG:
         glEnable(GL_LIGHTING);

         glEnableClientState(GL_NORMAL_ARRAY);
         glNormalPointer(GL_FLOAT, 0, pot->nlist);

         render_material();

         glDisableClientState(GL_NORMAL_ARRAY);
         glDisable(GL_LIGHTING);

         break;

         glDisable(GL_LIGHTING);

         break;

      case CONSTANT:
      case FLAT:
         glEnable(GL_LIGHTING);

         render_material();

         glDisable(GL_LIGHTING);

         break;

      case BW:
      case WFBW:
         glColor3ub(255, 255, 255);

         for (i=0; i<dob->countobject; i++)
            glDrawElements(GL_LINE_LOOP, pot->flist[i].polynum, GL_UNSIGNED_INT, pot->flist[i].edgeptr);

         break;

      default:  // DOT
        break;
   }

   glDisableClientState(GL_VERTEX_ARRAY);

   if (normalize_flag)
      glDisable(GL_NORMALIZE);

}


/* **************************************************
************************************************** */
void glpolygame::render_material() {

   int i, j;
   face_type *flist;
   int tstate = 0;
   shadetype *material = NULL;
   vector2f *uv;
   texbase *tex;

   complex->gfx->gfxEnable(GFX_CULL_FACE);

   switch (mctype.model) {

      case GOURAUD:
         for (i=0, flist = pot->flist; i<dob->countobject; i++, flist++) {

            if (sblock->facelist[i] != material)
               init_material(material = sblock->facelist[i]);

            if ((mcinfo.info & CITEXTURE) && tob->query_tflag(i)) {
               if (!tstate) {
                  tstate = 1;
                  complex->gfx->gfxEnable(GFX_TEXTURE);
               }

               tob->query_data(i, TEXTURE2D_QUERY_UNIT_TEXTURE, &last_frame, &tex);
               complex->gfx->gfxSetTexture((basic_texture_block *)tex->query_data());

               uv = uvblock[i].uv;

               glBegin(GL_POLYGON);
	       
                  for (j=0; j<flist->polynum; j++) {
                     glTexCoord2fv(uv[j]);
                     glArrayElement(flist->edgeptr[j]);
                  }

               glEnd();
            }

            else {
               if (tstate) {
                  tstate = 0;
                  complex->gfx->gfxDisable(GFX_TEXTURE);
               }

               glDrawElements(GL_POLYGON, flist->polynum, GL_UNSIGNED_INT, flist->edgeptr);
            }

         }

         if (tstate) {
            tstate = 0;
            complex->gfx->gfxDisable(GFX_TEXTURE);
         }

         break;

//      case CONSTANT:
      default:

         for (i=0, flist = pot->flist; i<dob->countobject; i++, flist++) {

            if (sblock->facelist[i] != material)
               init_material(material = sblock->facelist[i]);

            glNormal3fv(flist->normal);

            if ((mcinfo.info & CITEXTURE) && tob->query_tflag(i)) {
               if (!tstate) {
                  tstate = 1;
                  complex->gfx->gfxEnable(GFX_TEXTURE);
               }

               tob->query_data(i, TEXTURE2D_QUERY_UNIT_TEXTURE, &last_frame, &tex);
               complex->gfx->gfxSetTexture((basic_texture_block *)tex->query_data());

               uv = uvblock[i].uv;

               glBegin(GL_POLYGON);

                  for (j=0; j<flist->polynum; j++) {
                     glTexCoord2fv(uv[j]);
                     glArrayElement(flist->edgeptr[j]);
                  }

               glEnd();
            }

            else {
               if (tstate) {
                  tstate = 0;
                  complex->gfx->gfxDisable(GFX_TEXTURE);
               }

               glDrawElements(GL_POLYGON, flist->polynum, GL_UNSIGNED_INT, flist->edgeptr);
            }

         }

         if (tstate) {
            tstate = 0;
            complex->gfx->gfxDisable(GFX_TEXTURE);
         }

         break;
   }

}


/* *************************************************************
************************************************************* */
void glfxpolygame::preprocess(void *data) {

   // note: bypass glpolygame/glpolygon::preprocess() - intentional
   pc::preprocess(data);

   last_frame = 0;
}


/* *************************************************************
************************************************************* */
int glfxpolygame::scan(camera *cparm, light *lmain, engine *proc) {

   if (!dob || !lob)
      return 0;
      
   if (!tob)
      mcinfo.info &= ~CITEXTURE;
   
   return glpolygame::scan(cparm, lmain, proc);
}


/* *************************************************************
   same as fxpolygame::set_ob_data
************************************************************* */
void glfxpolygame::set_ob_data(polytype *fxdob, shadelist *fxlob, texpolygon *fxtob, unsigned int shade, unsigned int flags) {

   dob = fxdob;
   lob = fxlob;
   tob = fxtob;
  
   mcinfo.mask_and(CINULL);
   mcinfo.mask_or(flags);

   mctype.set_master((colortype)shade);
}


/* **************************************************
************************************************** */
int glpcloud::scan(camera *cparm, light *lmain, engine *proc) {

   return renderflag = count ? 1 : 0;
}


/* **************************************************
************************************************** */
void glpcloud::render(camera *cparm, light *lmain, light *spot, engine *proc) {

   // build matricies
   glMatrixMode(GL_MODELVIEW);

   glLoadTransposeMatrixf((GLfloat *)cparm->transform);
   glMultTransposeMatrixf((GLfloat *)rotate);

   glEnableClientState(GL_VERTEX_ARRAY);
   glVertexPointer(3, GL_FLOAT, 20, cloud[0].pos);
   glEnableClientState(GL_COLOR_ARRAY);
   glColorPointer(3, GL_UNSIGNED_BYTE, 20, cloud[0].color);

   glDrawArrays(GL_POINTS, 0, count);

   glDisableClientState(GL_VERTEX_ARRAY);
   glDisableClientState(GL_COLOR_ARRAY);
}
