

#ifdef WIN32

#include <windows.h>

#include "win_wgl.h"

#else

#include <GL/gl.h>

#endif

#include <string.h>

#include "WIN_VIRTUAL.h"

#include "gamegine.h"
#include "pcloud.h"
#include "flat.h"
#include "polygame.h"

#include "glline.h"
#include "glparticle.h"
#include "glfont.h"
#include "gltexture.h"


/* *************************************************************
************************************************************* */
class glid_type : public dbl_llist {

   public:
      unsigned int id;
      string_type name;

      virtual ~glid_type() {}
};


#ifndef WIN32

#ifndef GL_VERSION_1_2

#define GL_FUNC_ADD GL_FUNC_ADD_EXT
#define GL_MAX      GL_MAX_EXT
#define glBlendEquation glBlendEquationEXT

#endif

#ifndef GL_COLOR_INDEX8_EXT
#define GL_COLOR_INDEX8_EXT 0x80E5
#define GLX_COLOR_INDEX_FAILURE
#endif

#endif


/* *************************************************************
************************************************************* */
ogl_gfx::ogl_gfx() {

   begin_flag = -1;
   blendflag = 0;
   old_ghost_state = 0;
   old_transdepth_state = 0;
   buffer_state = GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT;
}


/* *************************************************************
************************************************************* */
ogl_gfx::~ogl_gfx() {

   glid_type *ptr;

   while(texid_manager.head) {
      texid_manager.remove(ptr = (glid_type *)texid_manager.head);

      glDeleteTextures(1, &ptr->id);
      delete ptr;
   }

}

 
/* *************************************************************
************************************************************* */
void ogl_gfx::gfxInit() {

   glid_type *ptr;

   if (!global_resource_manager)
      return;

   base_gfx::gfxInit();

   // cleanup texture freelist
   while(texid_manager.head) {
      texid_manager.remove(ptr = (glid_type *)texid_manager.head);
      glDeleteTextures(1, &ptr->id);
      delete ptr;
   }

   // register texture callbacks
   ((frame_manager *)global_resource_manager)->set_color_byte_order(CBYTE_ORDER_RGBA);

#ifdef WIN32

   blendflag = glBlendEquation ? 1 : 0;

   if (!glColorTable)
      ((frame_manager *)global_resource_manager)->set_palette_support(0);

#else

   blendflag = 1;

#ifdef GLX_COLOR_INDEX_FAILURE
   ((frame_manager *)global_resource_manager)->set_palette_support(0);
#endif

#endif

   if (game_fogflag[BACKGROUND] || game_fogflag[MIDGROUND] || game_fogflag[FOREGROUND]) {
      glFogi(GL_FOG_MODE, GL_LINEAR);
      glFogf(GL_FOG_START, game_fog_start);
      glFogf(GL_FOG_END, game_fog_end);
      glFogfv(GL_FOG_COLOR, game_fog_color);
      glClearColor(game_fog_color[0], game_fog_color[1], game_fog_color[2], game_fog_color[3]);
   }

   glHint(GL_FOG_HINT, GL_NICEST);
   glHint(GL_LINE_SMOOTH_HINT, GL_FASTEST);
   glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_FASTEST);
   glHint(GL_POINT_SMOOTH_HINT, GL_FASTEST);
   glHint(GL_POLYGON_SMOOTH_HINT, GL_FASTEST);

   glClearDepth(1);
   glDepthFunc(GL_LESS);
   glDepthRange(0, 1);
   glDepthMask(GL_TRUE);
   glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
   glShadeModel(GL_SMOOTH);

   glDisable(GL_FOG);
   glDisable(GL_BLEND);
   glDisable(GL_DEPTH_TEST);
   glDisable(GL_TEXTURE_2D);
   glDisable(GL_NORMALIZE);
   glDisable(GL_LIGHTING);
   glDisable(GL_CULL_FACE);

   begin_flag = -1;
   old_ghost_state = 0;
   old_transdepth_state = 0;
   buffer_state = GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT;
}


/* *************************************************************
************************************************************* */
font_type *ogl_gfx::gfxAllocFontObject(int type) {

   switch (type) {

      case FONT_VECTOR:
         return new glvectorfont;

      case FONT_RASTER:
         return new glrasterfont;

      default:
         break;
   }

   return NULL;
}


/* *************************************************************
************************************************************* */
pc *ogl_gfx::gfxAllocRenderObject(int type) {

   switch (type) {
      case OBJECT_POLYGON:
         return new glpolygame;

      case OBJECT_LINE:
         return new glline;

      case OBJECT_PARTICLE:
         return new glparticle;

      case OBJECT_FLAT:
      case OBJECT_GLFLAT:
         return new glflat;

      case OBJECT_PARTICLE_CLOUD:
         return new glpcloud;

      case OBJECT_FXPOLYGON:
         return new glfxpolygame;

      case OBJECT_FXFLAT:
         return new glfxflat;

      default:
         break;
   }

   return NULL;
}


/* *************************************************************
************************************************************* */
void ogl_gfx::gfxPointSize(float x) {

   glPointSize(x);
}


/* *************************************************************
************************************************************* */
void ogl_gfx::gfxBegin(unsigned int md, mapul *cvs) {

   switch (md) {
      case GFX_LINES:
         glBegin(GL_LINES);
         break;

      case GFX_LINE_STRIP:
         glBegin(GL_LINE_STRIP);
         break;
	 
      case GFX_POINTS:
         glBegin(GL_POINTS);
         break;

//      case GFX_LINE_LOOP:
      default:
         glBegin(GL_LINE_LOOP);
         break;
   }

   begin_flag = 0;
}


/* *************************************************************
************************************************************* */
void ogl_gfx::gfxEnd() {

   if (begin_flag > -1) {
      glEnd();
      begin_flag = -1;
   }

}


/* *************************************************************
************************************************************* */
void ogl_gfx::gfxColor3ubv(unsigned char *color) {

   glColor3ubv(color);
}


/* *************************************************************
************************************************************* */
void ogl_gfx::gfxVertex2iv(int *v) {

   if (begin_flag > -1)
      glVertex2iv(v);
}


/* *************************************************************
************************************************************* */
void ogl_gfx::gfxEnable(unsigned int cap) {

   if (gfx_state & cap)
      return;

   switch (cap) {
      case GFX_FOG:
         gfx_state |= GFX_FOG;
         glEnable(GL_FOG);
         return;

      case GFX_TRANSPARENT:
         gfx_state |= GFX_TRANSPARENT;
         glGetIntegerv(GL_DEPTH_WRITEMASK, &old_transdepth_state);
         glDepthMask(GL_FALSE);
         glEnable(GL_BLEND);

         if (blendflag) {
            glBlendFunc(GL_SRC_COLOR, GL_DST_COLOR);
            glBlendEquation(GL_MAX);
            return;
         }

         glBlendFunc(GL_ONE, GL_ONE);
         return;

      case GFX_INVISO:
         gfx_state |= GFX_INVISO;
         glEnable(GL_BLEND);
         glBlendFunc(GL_ONE, GL_ONE_MINUS_SRC_ALPHA);
         return;

      case GFX_OVERWRITE:
         gfx_state |= GFX_OVERWRITE;
         glDepthFunc(GL_ALWAYS);
         return;

      case GFX_GHOST:
         gfx_state |= GFX_GHOST;
         glGetIntegerv(GL_DEPTH_WRITEMASK, &old_ghost_state);
         glDepthMask(GL_FALSE);
         return;

      case GFX_DEPTH_TEST:
         gfx_state |= GFX_DEPTH_TEST;
         glEnable(GL_DEPTH_TEST);
         return;

      case GFX_CLEAR_COLOR_BUFFER:
         buffer_state |= GL_COLOR_BUFFER_BIT;
         gfx_state    |= GFX_CLEAR_COLOR_BUFFER;
         return;

      case GFX_CLEAR_DEPTH_BUFFER:
         buffer_state |= GL_DEPTH_BUFFER_BIT;
         gfx_state    |= GFX_CLEAR_DEPTH_BUFFER;
         return;

      case GFX_TEXTURE:
         gfx_state |= GFX_TEXTURE;
         glEnable(GL_TEXTURE_2D);
         return;

      case GFX_NORMALIZE:
         gfx_state |= GFX_NORMALIZE;
         glEnable(GL_NORMALIZE);
         return;

      case GFX_LIGHTING:
         gfx_state |= GFX_LIGHTING;
         glEnable(GL_LIGHTING);
         return;
 
      case GFX_CULL_FACE:
         gfx_state |= GFX_CULL_FACE;
         glEnable(GL_CULL_FACE);
         return;
 
      default:
         return;
   }

}


/* *************************************************************
************************************************************* */
void ogl_gfx::gfxDisable(unsigned int cap) {

   if (!(gfx_state & cap))
      return;

   switch (cap) {
      case GFX_FOG:
         gfx_state &= ~GFX_FOG;
         glDisable(GL_FOG);
         return;
 
      case GFX_TRANSPARENT:
         gfx_state &= ~GFX_TRANSPARENT;
         glDepthMask(old_transdepth_state);

         if (blendflag)
            glBlendEquation(GL_FUNC_ADD);

         glDisable(GL_BLEND);
         return;

      case GFX_INVISO:
         gfx_state &= ~GFX_INVISO;
         glDisable(GL_BLEND);
         return;

      case GFX_OVERWRITE:
         gfx_state &= ~GFX_OVERWRITE;
         glDepthFunc(GL_LESS);
         return;
  
      case GFX_GHOST:
         gfx_state &= ~GFX_GHOST;
         glDepthMask(old_ghost_state);
         return;

      case GFX_DEPTH_TEST:
         gfx_state &= ~GFX_DEPTH_TEST;
         glDisable(GL_DEPTH_TEST);
         return;
   
      case GFX_CLEAR_COLOR_BUFFER:
         buffer_state &= ~GL_COLOR_BUFFER_BIT;
         gfx_state    &= ~GFX_CLEAR_COLOR_BUFFER;
         return;
   
      case GFX_CLEAR_DEPTH_BUFFER:
         buffer_state &= ~GL_DEPTH_BUFFER_BIT;
         gfx_state    &= ~GFX_CLEAR_DEPTH_BUFFER;
         return;
   
      case GFX_TEXTURE:
         gfx_state &= ~GFX_TEXTURE;
         glDisable(GL_TEXTURE_2D);
         return;
    
      case GFX_NORMALIZE:
         gfx_state &= ~GFX_NORMALIZE;
         glDisable(GL_NORMALIZE);
         return;
    
      case GFX_LIGHTING:
         gfx_state &= ~GFX_LIGHTING;
         glDisable(GL_LIGHTING);
         return;
 
      case GFX_CULL_FACE:
         gfx_state &= ~GFX_CULL_FACE;
         glDisable(GL_CULL_FACE);
         return;

      default:
         return;
   }

}


/* *************************************************************
************************************************************* */
void ogl_gfx::gfxRectiv(mapul *mapbuffer, int *ll, int *ur) {

   glRectiv(ll, ur);
}


/* *************************************************************
************************************************************* */
void ogl_gfx::gfxClear(mapul *mapbuffer, mapf *zdata) {

   gfx_current_texid = -1;

   glClear(buffer_state);
}


/* *************************************************************
************************************************************* */
void ogl_gfx::gfxSetColor(unsigned char *src, unsigned char *rgb) {

   copyarray3(rgb, src);
}


/* *************************************************************
************************************************************* */
void ogl_gfx::gfxSnapshot(char *filename, mapul *mapbuffer, image_coder *coder) {

   glReadPixels(0, 0, mapbuffer->maxx, mapbuffer->maxy, GL_RGBA, GL_UNSIGNED_BYTE, mapbuffer->data);
   coder->write_data(filename, mapbuffer, CBYTE_ORDER_RGBA);
}


/* *************************************************************
************************************************************* */
void ogl_gfx::gfx2DMode(int winx, int winy) {

   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();
   glOrtho(0, winx, 0, winy, -1, 1);

   glMatrixMode(GL_MODELVIEW);
   glLoadIdentity();

   gfxDisable(GFX_DEPTH_TEST);
}


/* *************************************************************
************************************************************* */
void ogl_gfx::gfx3DModeBegin(camera *cparm, light *lmain, int winx, int winy) {

   vector4f v;

   if (lmain)
      lmain->xform(cparm);

   glFrontFace(GL_CW);
   gfxEnable(GFX_DEPTH_TEST);
   glViewport(0, 0, winx, winy);

   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();
   glFrustum(cparm->vrc[0], cparm->vrc[1], cparm->vrc[2], cparm->vrc[3], -front, -back);

   glMatrixMode(GL_MODELVIEW);
   glLoadIdentity();

   if (lmain) {
      v[0] = v[1] = v[2] = 0;
      v[3] = 1;
      glLightModelfv(GL_LIGHT_MODEL_AMBIENT, v);

      glLightModeli(GL_LIGHT_MODEL_LOCAL_VIEWER, 1);
      glLightModeli(GL_LIGHT_MODEL_TWO_SIDE, 0);

      copyarray3(v, lmain->Ia);
      glLightfv(GL_LIGHT0, GL_AMBIENT, v);

      copyarray3(v, lmain->Ip);
      v[3] = 1;
      glLightfv(GL_LIGHT0, GL_DIFFUSE, v);
      glLightfv(GL_LIGHT0, GL_SPECULAR, v);

      if (lmain->query_whatami() == OBJECT_FAR) {
         copyarray3(v, lmain->transvec);
         v[3] = 0;
         glLightfv(GL_LIGHT0, GL_POSITION, v);
      }

      else {
         copyarray3(v, lmain->transloc);
         v[3] = 1;
         glLightfv(GL_LIGHT0, GL_POSITION, v);

         glLightf(GL_LIGHT0, GL_CONSTANT_ATTENUATION,  lmain->fatt[0]);
         glLightf(GL_LIGHT0, GL_LINEAR_ATTENUATION,    lmain->fatt[1]);
         glLightf(GL_LIGHT0, GL_QUADRATIC_ATTENUATION, lmain->fatt[2]);
      }

      glEnable(GL_LIGHT0);
   }

   glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
   if (blendflag)
      glBlendEquation(GL_FUNC_ADD);
}


/* *************************************************************
************************************************************* */
void ogl_gfx::gfx3DModeEnd() {

   glDisable(GL_LIGHT0);

   gfxDisable(GFX_CULL_FACE);
   gfxDisable(GFX_TRANSPARENT);
   gfxDisable(GFX_INVISO);
   gfxDisable(GFX_DEPTH_TEST);
}


/* *************************************************************
   shade[0] = r
   shade[1] = g
   shade[2] = b
************************************************************* */
void ogl_gfx::gfxPaste2D(mapul *mapbuffer, texbase *tob, unsigned char *shade, int *ll, int *ur, float *lluv, float *uruv, int transflag) {

   gfxEnable(transflag);
   gfxEnable(GFX_TEXTURE);

   gfxSetTexture((basic_texture_block *)tob->query_data());

   if (shade)
      glColor3ubv(shade);
   else
      glColor3ub(255, 255, 255);

   glBegin(GL_POLYGON);
      glTexCoord2fv(lluv);
      glVertex2iv(ll);
      glTexCoord2f(lluv[0], uruv[1]);
      glVertex2i(ll[0], ur[1]);
      glTexCoord2fv(uruv);
      glVertex2iv(ur);
      glTexCoord2f(uruv[0], lluv[1]);
      glVertex2i(ur[0], ll[1]);
   glEnd();

   gfxDisable(GFX_TEXTURE);
   gfxDisable(transflag);
}


/* *************************************************************
   shade[0] = r
   shade[1] = g
   shade[2] = b
************************************************************* */
void ogl_gfx::gfxPaste2D(mapul *mapbuffer, texbase *tob, unsigned char *shade, int left, int bottom, int right, int top, int transflag) {

   gfxEnable(transflag);
   gfxEnable(GFX_TEXTURE);

   gfxSetTexture((basic_texture_block *)tob->query_data());

   if (shade)
      glColor3ubv(shade);
   else
      glColor3ub(255, 255, 255);

   glBegin(GL_POLYGON);
      glTexCoord2f(0, 0);
      glVertex2i(left, bottom);
      glTexCoord2f(0, 1.0);
      glVertex2i(left, top);
      glTexCoord2f(1.0, 1.0);
      glVertex2i(right, top);
      glTexCoord2f(1.0, 0);
      glVertex2i(right, bottom);
   glEnd();

   gfxDisable(GFX_TEXTURE);
   gfxDisable(transflag);
}


/* *************************************************************
************************************************************* */
void ogl_gfx::gfxPaste2D(mapul *mapbuffer, texbase *tob, unsigned char *shade, int x, int y, int placeflag, int transflag) {

   vector2i ll, ur;

   switch(placeflag) {
      case GFX_PLACEMENT_LOWER_LEFT:
         ll[0] = x;
         ll[1] = y;
         ur[0] = x + tob->maxx;
         ur[1] = y + tob->maxy;
         break;

      case GFX_PLACEMENT_UPPER_LEFT:
         ll[0] = x;
         ll[1] = y - tob->maxy+1;
         ur[0] = x + tob->maxx;
         ur[1] = y + 1;
         break;

      case GFX_PLACEMENT_UPPER_RIGHT:
         ll[0] = x - tob->maxx+1;
         ll[1] = y - tob->maxy+1;
         ur[0] = x + 1;
         ur[1] = y + 1;
         break;

      case GFX_PLACEMENT_LOWER_RIGHT:
         ll[0] = x - tob->maxx+1;
         ll[1] = y;
         ur[0] = x + 1;
         ur[1] = y + tob->maxy;
         break;

      default:	// center
         ll[0] = x - (tob->maxx>>1);
         ll[1] = y - (tob->maxy>>1);
         ur[0] = ll[0] + tob->maxx;
         ur[1] = ll[1] + tob->maxy;
         break;
   }

   gfxEnable(transflag);
   gfxEnable(GFX_TEXTURE);

   gfxSetTexture((basic_texture_block *)tob->query_data());

   if (shade)
      glColor3ubv(shade);
   else
      glColor3ub(255, 255, 255);
 
   glBegin(GL_POLYGON);
      glTexCoord2f(0, 0);
      glVertex2i(ll[0], ll[1]);
      glTexCoord2f(0, 1.0);
      glVertex2i(ll[0], ur[1]);
      glTexCoord2f(1.0, 1.0);
      glVertex2i(ur[0], ur[1]);
      glTexCoord2f(1.0, 0);
      glVertex2i(ur[0], ll[1]);
   glEnd();

   gfxDisable(GFX_TEXTURE);
   gfxDisable(transflag);
}


/* *************************************************************
************************************************************* */
void ogl_gfx::gfxBitblt(BLTwindow *win, mapul *mapbuffer) {

   win->VIRTUALswapbuffers();
}


/* *************************************************************
************************************************************* */
void ogl_gfx::gfxFlatIncrementTime(pc *ob, float inc) {

   ((glflat *)ob)->last_frame += inc;

   if (((glflat *)ob)->last_frame > 256)
      ((glflat *)ob)->last_frame -= 256;

   ((glflat *)ob)->update_texture();
}

/* *************************************************************
************************************************************* */
void ogl_gfx::gfxPolygonIncrementTime(pc *ob, float inc) {

   ((glpolygame *)ob)->last_frame += inc;

   if (((glpolygame *)ob)->last_frame > 256)
      ((glpolygame *)ob)->last_frame -= 256;
}


/* *************************************************************
************************************************************* */
void ogl_gfx::gfxFxflatInit(pc *ob, texbase *tob) {

   ((glfxflat *)ob)->set_ob_data(tob);
   ((glfxflat *)ob)->last_frame = 0;
}


/* *************************************************************
************************************************************* */
void ogl_gfx::gfxPolygonInit(pc *ob) {

   ((glpolygame *)ob)->last_frame = 0;
}


/* *************************************************************
************************************************************* */
void ogl_gfx::gfxSetTexture(basic_texture_block *tex) {

   if (tex && ((texture_block_ogl *)tex)->tex_id != gfx_current_texid)
      glBindTexture(GL_TEXTURE_2D, gfx_current_texid = ((texture_block_ogl *)tex)->tex_id);
}


/* *************************************************************
************************************************************* */
font_type *ogl_gfx::gfxReadFont(char *filename, int type) {

   font_type *ftr;

   ftr = gfxAllocFontObject(type);

   if (ftr->read_data(filename))
      return ftr;

   delete ftr;
   return NULL;
}


/* *************************************************************
************************************************************* */
unsigned int ogl_gfx::ogl_gfxAllocTexID(string_type *filename, int *found) {

   glid_type *ptr;
   unsigned int ret;

   *found = 0;

   for (ptr = (glid_type *)texid_manager.tail; ptr; ptr = (glid_type *)ptr->back)
      if (!ptr->name.stringcmp(filename)) {
         texid_manager.remove(ptr);
         *found = 1;
         ret = ptr->id;
         delete ptr;
         return ret;
      }

   if (texid_manager.head) {
      texid_manager.remove(ptr = (glid_type *)texid_manager.head);
      ret = ptr->id;
      delete ptr;
      return ret;
   }

   glGenTextures(1, &ret);
   return ret;
}


/* *************************************************************
************************************************************* */
void ogl_gfx::ogl_gfxDeallocTexID(unsigned int id, string_type *filename) {

   glid_type *ptr;

   texid_manager.append(ptr = new glid_type, NULL);
   ptr->id = id;
   ptr->name.stringcpy(filename);
}

