

#include <stdlib.h>
#include <string.h>


#include "menu.h"
#include "gamegine.h"
#include "pstring.h"


/* **********************************************************
********************************************************** */
void menu_data_type::read_menu_text(FILE *infile) {

   int i;
   char token[MAXSTRLEN];
   
   // read in key function count      
   get_token(infile, token);
   text_count = atoi(token);
   
   if (text_palette)
      delete [] text_palette;
   
   text_palette = new string_type[text_count];
   
   // read in key function names   
   for (i=0; i<text_count; i++) {
      get_token(infile, token);
      text_palette[i].stringcpy(token);
   }

}


/* **********************************************************
********************************************************** */
int generic_widget::parse(FILE *infile, char *token) {

   if (!strcmp(token, "bound")) {
      if (parent) {
         get_token(infile, token);
         x[0] = atoi(token) + parent->x[0];

         get_token(infile, token);
         y[0] = atoi(token) + parent->y[0];
      }
   
      else {   
         get_token(infile, token);
         x[0] = atoi(token);

         get_token(infile, token);
         y[0] = atoi(token);
      }
   
      get_token(infile, token);
      x[1] = x[0] + atoi(token);
   
      get_token(infile, token);
      y[1] = y[0] + atoi(token);
   
      return 1;
   }

   if (!strcmp(token, "lock")) {
      flags |= WIDGETFLAG_LOCK_OPTION;
      return 1;
   }
      
   if (!strcmp(token, "center")) {
      flags &= ~WIDGETMASK_JUSTIFY;
      flags |= WIDGETFLAG_CENTER;
      return 1;
   }
   
   if (!strcmp(token, "right")) {
      flags &= ~WIDGETMASK_JUSTIFY;
      flags |= WIDGETFLAG_RIGHT_JUSTIFY;
      return 1;
   }
   
   return 0;
}


/* **********************************************************
********************************************************** */
void generic_widget::preprocess(void *data) {

   generic_widget *ptr;

   refresh();
   
   for (ptr = (generic_widget *)children.head; ptr; ptr = (generic_widget *)ptr->next)
      ptr->preprocess(data);
}


/* **********************************************************
********************************************************** */
void generic_widget::render(mapul *mapbuffer) {

   generic_widget *ptr;

   if (!(flags & WIDGETFLAG_SHOW))
      return;

   // back to front
   for (ptr = (generic_widget *)children.tail; ptr; ptr = (generic_widget *)ptr->back)
      ptr->render(mapbuffer);
}


/* **********************************************************
********************************************************** */
generic_widget *generic_widget::select(int pixel_x, int pixel_y) {

   generic_widget *ptr, *qtr;

   if (pixel_x < x[0] || pixel_x > x[1] || pixel_y < y[0] || pixel_y > y[1])
      return NULL;

   for (ptr = (generic_widget *)children.head; ptr; ptr = (generic_widget *)ptr->next) {
      qtr = ptr->select(pixel_x, pixel_y);
      if (!qtr)
         continue;

      children.remove(ptr);
      children.insert(ptr, NULL);
      return qtr;
   }

//   return (flags & WIDGETFLAG_SELECTABLE) ? this : NULL;   
   return this;
}


/* **********************************************************
********************************************************** */
void generic_widget::perform(int task, void *data) {

   generic_widget *ptr;

   for (ptr = (generic_widget *)children.head; ptr; ptr = (generic_widget *)ptr->next)
      ptr->perform(task, data);
}


/* **********************************************************
********************************************************** */
int frame_widget::query_whatwasi(int type) {

   return type == frame_widget::query_whatami() ? 1 : generic_widget::query_whatwasi(type);
}


/* **********************************************************
********************************************************** */
int frame_widget::parse(FILE *infile, char *token) {

   generic_widget *ptr;

   if (!strcmp(token, "border")) {
      flags |= WIDGETFLAG_BORDER;

      get_token(infile, token);
      bordercolor[0] = atoi(token);

      get_token(infile, token);
      bordercolor[1] = atoi(token);

      get_token(infile, token);
      bordercolor[2] = atoi(token);

      bordercolor[3] = 255;
      return 1;
   }
   
   if (!strcmp(token, "background")) {
      flags &= ~WIDGETFLAG_INVISO;

      get_token(infile, token);
      background[0] = atoi(token);

      get_token(infile, token);
      background[1] = atoi(token);

      get_token(infile, token);
      background[2] = atoi(token);

      background[3] = 255;
      return 1;
   }
   
   if (!strcmp(token, "text")) {
      children.insert(ptr = new text_widget, NULL);
      ptr->parent = this;

      get_token(infile, token);  // '{'
      while (get_token(infile, token)) {
         if (token[0] == '}')
            break;
	    
         lower_case(token);
         if (!ptr->parse(infile, token))
	    return 0;
      }
	 
      return 1;
   }
         
   if (!strcmp(token, "button")) {

      children.insert(ptr = new text_button_widget, NULL);
      ptr->parent = this;
      
      get_token(infile, token);  // '{'
      while (get_token(infile, token)) {
         if (token[0] == '}')
            break;

         lower_case(token);
         if (!ptr->parse(infile, token))
	    return 0;
      }
	 
      return 1;
   }
      
   if (!strcmp(token, "frame")) {
      children.insert(ptr = new frame_widget, NULL);
      ptr->parent = this;
      
      get_token(infile, token);  // '{'
      while (get_token(infile, token)) {
         if (token[0] == '}')
            break;
	    
         lower_case(token);
         if (!ptr->parse(infile, token))
	    return 0;
      }
	 
      return 1;
   }

   return generic_widget::parse(infile, token);
}


/* **********************************************************
********************************************************** */
void frame_widget::render(mapul *mapbuffer) {

   vector2i u, v, sx, sy;
   float scale;

   if (!(flags & WIDGETFLAG_SHOW))
      return;

   if (flags & WIDGETFLAG_BORDER) {
      scale = (float)(mapbuffer->maxx/MAX_WIN_WIDTH);
      sx[0] = (int)(scale * x[0]);
      sx[1] = (int)(scale * x[1]);
   
      scale = (float)(mapbuffer->maxy/MAX_WIN_HEIGHT);
      sy[0] = (int)(scale * y[0]);
      sy[1] = (int)(scale * y[1]);

      if (!(flags & WIDGETFLAG_INVISO)) {
         complex->gfx->gfxColor3ubv(background);

         u[0] = sx[0];
         u[1] = sy[0];
         v[0] = sx[1];
         v[1] = sy[1];
   
         complex->gfx->gfxRectiv(mapbuffer, u, v);
      }

      complex->gfx->gfxColor3ubv(bordercolor);

      complex->gfx->gfxBegin(GFX_LINE_LOOP, mapbuffer);
         v[0] = sx[0];
         v[1] = sy[0];
         complex->gfx->gfxVertex2iv(v);
         v[1] = sy[1];
         complex->gfx->gfxVertex2iv(v);
         v[0] = sx[1];
         complex->gfx->gfxVertex2iv(v);
         v[1] = sy[0];
         complex->gfx->gfxVertex2iv(v);
      complex->gfx->gfxEnd();
   }

   else if (!(flags & WIDGETFLAG_INVISO)) {
      scale = (float)(mapbuffer->maxx/MAX_WIN_WIDTH);
      sx[0] = (int)(scale * x[0]);
      sx[1] = (int)(scale * x[1]);
   
      scale = (float)(mapbuffer->maxy/MAX_WIN_HEIGHT);
      sy[0] = (int)(scale * y[0]);
      sy[1] = (int)(scale * y[1]);

      // draw box
      complex->gfx->gfxColor3ubv(background);

      u[0] = sx[0];
      u[1] = sy[0];
      v[0] = sx[1];
      v[1] = sy[1];
   
      complex->gfx->gfxRectiv(mapbuffer, u, v);
   }

   generic_widget::render(mapbuffer);   
}


/* **********************************************************
********************************************************** */
int text_widget::query_whatwasi(int type) {

   return (type == text_widget::query_whatami()) ? 1 : generic_widget::query_whatwasi(type);
}


/* **********************************************************
********************************************************** */
int text_widget::parse(FILE *infile, char *token) {

   if (!strcmp(token, "foreground")) {
      get_token(infile, token);
      foreground_color[0] = atoi(token);
   
      get_token(infile, token);
      foreground_color[1] = atoi(token);

      get_token(infile, token);
      foreground_color[2] = atoi(token);

      foreground_color[3] = 255;
      return 1;
   }
         
   if (!strcmp(token, "background")) {
      get_token(infile, token);
      background_color[0] = atoi(token);
   
      get_token(infile, token);
      background_color[1] = atoi(token);

      get_token(infile, token);
      background_color[2] = atoi(token);

      background_color[3] = 255;
      flags &= ~WIDGETFLAG_INVISO;
      return 1;
   }
         
   if (!strcmp(token, "string_index")) {
      get_token(infile, token);
      string_code = atoi(token);
      return 1;
   }
   
   if (!strcmp(token, "font")) {
      get_token(infile, token);
      text_font.stringcpy(token);
      return 1;
   }
   
   return generic_widget::parse(infile, token);
}


/* **********************************************************
********************************************************** */
void text_widget::preprocess(void *data) {

   text.stringcpy(string_code < ((menu_data_type *)data)->text_count ? ((menu_data_type *)data)->text_palette[string_code].string : (char *)"");
   
   generic_widget::preprocess(data);
}


/* **********************************************************
********************************************************** */
void text_widget::render(mapul *mapbuffer) {

   float scalex, scaley;
   int sx, sy;
   vector2i u, v;
   font_type *font;
   
   if (!(flags & WIDGETFLAG_SHOW))
      return;

   scalex = (float)(mapbuffer->maxx/MAX_WIN_WIDTH);
   scaley = (float)(mapbuffer->maxy/MAX_WIN_HEIGHT);

   if (!(flags & WIDGETFLAG_INVISO)) {

      u[0] = (int)(scalex * x[0]);
      v[0] = (int)(scalex * x[1]);
   
      u[1] = (int)(scaley * y[0]);
      v[1] = (int)(scaley * y[1]);

      complex->gfx->gfxColor3ubv(background_color);
      complex->gfx->gfxRectiv(mapbuffer, u, v);
   }

   font = complex->font;
   
   // change font
   if (text_font.string[0])
      complex->set_font(text_font.string, FONT_RASTER);

   sy = (int)(scaley * (y[0] + 0.32*(y[1]-y[0])));

   complex->font->set_scale(scaley*0.36f*(y[1]-y[0]));

   if (flags & WIDGETFLAG_CENTER)
      sx = (int)(0.5 *(scalex *(x[0] + x[1]) - complex->font->pixel_length((unsigned char *)text.string)));
   else if (flags & WIDGETFLAG_RIGHT_JUSTIFY)
      sx = (int)(scalex * x[1] - complex->font->pixel_length((unsigned char *)text.string));
   else
      sx = (int)(scalex * x[0]);
      
   complex->font->set_color(foreground_color[0], foreground_color[1], foreground_color[2]);
   complex->font->print(sx, sy, (unsigned char *)text.string, mapbuffer);

   // set back
   complex->font = font;

   generic_widget::render(mapbuffer);
}


/* **********************************************************
********************************************************** */
int button_widget::query_whatwasi(int type) {

   return (type == button_widget::query_whatami()) ? 1 : generic_widget::query_whatwasi(type);
}


/* **********************************************************
********************************************************** */
int button_widget::parse(FILE *infile, char *token) {

   if (!strcmp(token, "action_code")) {
      get_token(infile, token);
      action_code = atoi(token);
      return 1;
   }

   if (!strcmp(token, "background")) {
      flags &= ~WIDGETFLAG_INVISO;
      get_token(infile, token);
      background_color[0] = atoi(token);
   
      get_token(infile, token);
      background_color[1] = atoi(token);
   
      get_token(infile, token);
      background_color[2] = atoi(token);

      background_color[3] = 255;
      return 1;
   }
   
   if (!strcmp(token, "noborder")) {
      flags &= ~WIDGETFLAG_BORDER;
      return 1;
   }

   if (!strcmp(token, "select")) {
      get_token(infile, token);
      select_color[0] = atoi(token);
   
      get_token(infile, token);
      select_color[1] = atoi(token);
   
      get_token(infile, token);
      select_color[2] = atoi(token);

      select_color[3] = 255;
      return 1;
   }
   
   if (!strcmp(token, "unselect")) {
      get_token(infile, token);
      unselect_color[0] = atoi(token);
   
      get_token(infile, token);
      unselect_color[1] = atoi(token);
   
      get_token(infile, token);
      unselect_color[2] = atoi(token);

      unselect_color[3] = 255;
      return 1;
   }
   
   if (!strcmp(token, "highlight")) {
      get_token(infile, token);
      highlight_color[0] = atoi(token);
   
      get_token(infile, token);
      highlight_color[1] = atoi(token);
   
      get_token(infile, token);
      highlight_color[2] = atoi(token);

      highlight_color[3] = 255;
      return 1;
   }
   
   return generic_widget::parse(infile, token);
}


/* **********************************************************
********************************************************** */
void button_widget::preprocess(void *data) {

   generic_widget::preprocess(data);
}


/* **********************************************************
   put double border around box
********************************************************** */
void button_widget::render(mapul *mapbuffer) {

   vector2i u, v, sx, sy;
   float scale;
      
   if (!(flags & WIDGETFLAG_SHOW))
      return;

   scale = (float)(mapbuffer->maxx/MAX_WIN_WIDTH);
   sx[0] = (int)(scale * x[0]);
   sx[1] = (int)(scale * x[1]);
   
   scale = (float)(mapbuffer->maxy/MAX_WIN_HEIGHT);
   sy[0] = (int)(scale * y[0]);
   sy[1] = (int)(scale * y[1]);

   // draw box w/ background color
   if (!(flags & WIDGETFLAG_INVISO)) {
      complex->gfx->gfxColor3ubv(background_color);

      u[0] = sx[0];
      u[1] = sy[0];
      v[0] = sx[1];
      v[1] = sy[1];
   
      complex->gfx->gfxRectiv(mapbuffer, u, v);
   }
      
   // draw border stripes
   if (flags & WIDGETFLAG_BORDER) {
      sx[0]++;
      sy[0]++;

      sx[1]--;
      sy[1]--;

      complex->gfx->gfxColor3ubv(current_color);

      complex->gfx->gfxBegin(GFX_LINE_LOOP, mapbuffer);
         v[0] = sx[0];
         v[1] = sy[0];
         complex->gfx->gfxVertex2iv(v);
         v[1] = sy[1];
         complex->gfx->gfxVertex2iv(v);
         v[0] = sx[1];
         complex->gfx->gfxVertex2iv(v);
         v[1] = sy[0];
         complex->gfx->gfxVertex2iv(v);
      complex->gfx->gfxEnd();

      sx[0] += 2;
      sy[0] += 2;
   
      sx[1] -= 2;
      sy[1] -= 2;
   
      complex->gfx->gfxBegin(GFX_LINE_LOOP, mapbuffer);
         v[0] = sx[0];
         v[1] = sy[0];
         complex->gfx->gfxVertex2iv(v);
         v[1] = sy[1];
         complex->gfx->gfxVertex2iv(v);
         v[0] = sx[1];
         complex->gfx->gfxVertex2iv(v);
         v[1] = sy[0];
         complex->gfx->gfxVertex2iv(v);
      complex->gfx->gfxEnd();
   }

   generic_widget::render(mapbuffer);
}


/* **********************************************************
********************************************************** */
void button_widget::refresh() {

   if (flags & WIDGETFLAG_SELECTED) {
      copyarray4(current_color, select_color);
   }
   
   else if (flags & WIDGETFLAG_HIGHLIGHT) {
      copyarray4(current_color, highlight_color);
   }
   
   else
      copyarray4(current_color, unselect_color);

   generic_widget::refresh();   
}


/* **********************************************************
********************************************************** */
int text_button_widget::query_whatwasi(int type) {

   return (type == text_button_widget::query_whatami()) ? 1 : button_widget::query_whatwasi(type);
}


/* **********************************************************
********************************************************** */
int text_button_widget::parse(FILE *infile, char *token) {

   if (!strcmp(token, "string_index")) {
      get_token(infile, token);
      string_code = atoi(token);
      return 1;
   }
   
   if (!strcmp(token, "noblink_select")) {
      flags |= WIDGETFLAG_NOBLINK_SELECT;
      return 1;
   }
   
   return button_widget::parse(infile, token);
}


/* **********************************************************
********************************************************** */
void text_button_widget::preprocess(void *data) {

   text_widget *ptr;
   
   children.insert(ptr = new text_widget, NULL);
   ptr->parent = this;
   
   ptr->x[0] = x[0] + 4;
   ptr->x[1] = x[1];
   ptr->string_code = -1;
   
   copyarray2(ptr->y, y);

   if (flags & WIDGETFLAG_CENTER) {
      ptr->flags &= ~WIDGETMASK_JUSTIFY;
      ptr->flags |= WIDGETFLAG_CENTER;
   }
   
   if (string_code < ((menu_data_type *)data)->text_count)
      ((text_widget *)children.head)->string_code = string_code;
   
   button_widget::preprocess(data);
}   


/* **********************************************************
********************************************************** */
void text_button_widget::render(mapul *mapbuffer) {

   float t;
   
   if ((flags & (WIDGETFLAG_SELECTED)) && !(flags & WIDGETFLAG_NOBLINK_SELECT)) {
      cycle_timer += complex->timer.speedscale;
   
      if (cycle_timer > 2)
         cycle_timer -= 2;
      
      t = ((cycle_timer >= 1) ? 2 - cycle_timer : cycle_timer)*0.75f + 0.25f;

      current_color[0] = (int)(t*backup_color[0]);      
      current_color[1] = (int)(t*backup_color[1]);      
      current_color[2] = (int)(t*backup_color[2]);      
      current_color[3] = backup_color[3];
      copyarray4(((text_widget *)children.head)->foreground_color, current_color);
   }
   
   button_widget::render(mapbuffer);
}


/* **********************************************************
********************************************************** */
void text_button_widget::refresh() {

   button_widget::refresh();
   copyarray4(backup_color, current_color);
   copyarray4(((text_widget *)children.head)->foreground_color, backup_color);
   cycle_timer = 0;
}


/* **********************************************************
********************************************************** */
hslider_widget::hslider_widget() {

   children.insert(button = new frame_widget, NULL);
   button->parent = this;
   
   value = 0;
}


/* **********************************************************
********************************************************** */
int hslider_widget::query_whatwasi(int type) {

   return (type == hslider_widget::query_whatami()) ? 1 : generic_widget::query_whatwasi(type);
}


/* **********************************************************
********************************************************** */
int hslider_widget::parse(FILE *infile, char *token) {

   if (!strcmp(token, "background")) {
      get_token(infile, token);
      background_color[0] = atoi(token);
   
      get_token(infile, token);
      background_color[1] = atoi(token);
   
      get_token(infile, token);
      background_color[2] = atoi(token);

      background_color[3] = 255;
      return 1;
   }
   
   if (!strcmp(token, "foreground")) {
      get_token(infile, token);
      foreground_color[0] = atoi(token);
   
      get_token(infile, token);
      foreground_color[1] = atoi(token);
   
      get_token(infile, token);
      foreground_color[2] = atoi(token);

      foreground_color[3] = 255;
      return 1;
   }
   
   if (!strcmp(token, "highlight")) {
      get_token(infile, token);
      highlight_color[0] = atoi(token);
   
      get_token(infile, token);
      highlight_color[1] = atoi(token);
   
      get_token(infile, token);
      highlight_color[2] = atoi(token);

      highlight_color[3] = 255;
      return 1;
   }
         
   if (!strcmp(token, "id")) {
      get_token(infile, token);
      id = atoi(token);
      return 1;
   }
   
   return generic_widget::parse(infile, token);
}


/* **********************************************************
********************************************************** */
void hslider_widget::preprocess(void *data) {

   int width, height;
   
   copyarray4(current_color, foreground_color);
   copyarray4(button->bordercolor, foreground_color);

   width = x[1] - x[0];
   height = y[1] - y[0];

   button->y[0] = y[0] + (height>>2);
   button->x[0] = x[0] + ((width-height)>>3) + ((int)(width*0.75*value));
      
   button->x[1] = button->x[0] + (height>>2);
   button->y[1] = button->y[0] + (height>>1);
   copyarray4(button->background, background_color);
   button->flags &= ~WIDGETFLAG_INVISO;
   button->flags |= WIDGETFLAG_BORDER;

   generic_widget::preprocess(data);

   flags |= WIDGETFLAG_SELECTABLE;
   button->flags &= ~WIDGETFLAG_SELECTABLE;
}


/* **********************************************************
********************************************************** */
void hslider_widget::refresh() {

   if (flags & WIDGETFLAG_HIGHLIGHT) {
      copyarray4(current_color, highlight_color);
   }
   
   else
      copyarray4(current_color, foreground_color);

   copyarray4(button->bordercolor, current_color);
   button->refresh();

   generic_widget::refresh();
}


/* **********************************************************
********************************************************** */
void hslider_widget::render(mapul *mapbuffer) {

   vector2i u, v, sx, sy;
   float scale;
   int width, height;
   
   if (!(flags & WIDGETFLAG_SHOW))
      return;

   scale = (float)(mapbuffer->maxx/MAX_WIN_WIDTH);
   sx[0] = (int)(scale * x[0]);
   sx[1] = (int)(scale * x[1]);
   
   scale = (float)(mapbuffer->maxy/MAX_WIN_HEIGHT);
   sy[0] = (int)(scale * y[0]);
   sy[1] = (int)(scale * y[1]);

   // draw box w/ background color
   if (!(flags & WIDGETFLAG_INVISO)) {
      complex->gfx->gfxColor3ubv(background_color);

      u[0] = sx[0];
      u[1] = sy[0];
      v[0] = sx[1];
      v[1] = sy[1];
   
      complex->gfx->gfxRectiv(mapbuffer, u, v);
   }
      
   // draw border stripes

   complex->gfx->gfxColor3ubv(current_color);

   complex->gfx->gfxBegin(GFX_LINE_LOOP, mapbuffer);
      v[0] = sx[0];
      v[1] = sy[0];
      complex->gfx->gfxVertex2iv(v);
      v[1] = sy[1];
      complex->gfx->gfxVertex2iv(v);
      v[0] = sx[1];
      complex->gfx->gfxVertex2iv(v);
      v[1] = sy[0];
      complex->gfx->gfxVertex2iv(v);
   complex->gfx->gfxEnd();

   complex->gfx->gfxBegin(GFX_LINE_LOOP, mapbuffer);
      v[0] = sx[0]+2;
      v[1] = sy[0]+2;
      complex->gfx->gfxVertex2iv(v);
      v[1] = sy[1]-2;
      complex->gfx->gfxVertex2iv(v);
      v[0] = sx[1]-2;
      complex->gfx->gfxVertex2iv(v);
      v[1] = sy[0]+2;
      complex->gfx->gfxVertex2iv(v);
   complex->gfx->gfxEnd();

   // draw line in middle, start, middle, end ticks

   width  = sx[1] - sx[0];
   height = sy[1] - sy[0];

   complex->gfx->gfxBegin(GFX_LINES, mapbuffer);
   
      // line in middle
      v[1] = sy[0] + (height>>1);
      v[0] = sx[0] + (width>>3);
      complex->gfx->gfxVertex2iv(v);
      v[0] = sx[1] - (width>>3);
      complex->gfx->gfxVertex2iv(v);

      sy[0] = v[1] - (height>>3);
      sy[1] = v[1] + (height>>3);
      
      // first tick
      v[0] = sx[0] + (width>>3);
      v[1] = sy[0];
      complex->gfx->gfxVertex2iv(v);
      v[1] = sy[1];
      complex->gfx->gfxVertex2iv(v);
      
      // middle tick
      v[0] = sx[0] + (width>>1);
      v[1] = sy[0];
      complex->gfx->gfxVertex2iv(v);
      v[1] = sy[1];
      complex->gfx->gfxVertex2iv(v);
      
      // end tick
      v[0] = sx[1] - (width>>3);
      v[1] = sy[0];
      complex->gfx->gfxVertex2iv(v);
      v[1] = sy[1];
      complex->gfx->gfxVertex2iv(v);
      
   complex->gfx->gfxEnd();
   
   generic_widget::render(mapbuffer);
}


/* **********************************************************
  *value set in parent widget
********************************************************** */
void hslider_widget::set_value(float v) {

   value = v;
}


