

#include "gamegine.h"
#include "linegame.h"


/* **************************************************
************************************************** */
void linegame::render(camera *cparm, light *lmain, light *spot, engine *proc) {

   int          *zdata = (int *)proc->zbuff.zdata;
   unsigned int *idata = proc->zbuff.data;

   int i, j;
   edgetype edge;
   int scanxy;
   int start, end;
   float div, dz, z;
   union { int i; float f; } tz;
   vector4uc rcolor;

   rcolor[REDINDEX]   = (int)wcolor[0][0];
   rcolor[GREENINDEX] = (int)wcolor[0][1];
   rcolor[BLUEINDEX]  = (int)wcolor[0][2];

   j = (wwai[0][1] <= wwai[1][1]);
   i = (!j);                            // i is the smaller y

   edge.starty = (int)wwai[i][1];
   edge.endy   = (int)wwai[j][1];

   if (edge.starty == edge.endy)
      edge.endy++;
      
   edge.start.fxpoint[0] = ((int)(wwai[i][0]*65536.0f)) + 0x8000;
   edge.start.point[2] = wwai[i][2];

   if (edge.endy == edge.starty) {
      edge.fxdx = 0;
      edge.dz = 0;
   }
   
   else {
      div = ((gengine *)proc)->ybuff[edge.endy-edge.starty] * 65536.0f;
      edge.fxdx = (int)((wwai[j][0] - wwai[i][0]) * div);
      edge.dz = (wwai[j][2] - wwai[i][2]) * div;
   }
   
   scanxy = edge.starty*proc->zbuff.maxx;
   
   while (edge.starty < edge.endy) {

      if (edge.fxdx >= 0) {
         start = scanxy + FIXED_TO_INT(edge.start.fxpoint[0]);
         end   = scanxy + FIXED_TO_INT(edge.start.fxpoint[0] + edge.fxdx);

         div = ((gengine *)proc)->xbuff[end-start];

         if (!((mcinfo.info & CIGHOST) && (mcinfo.info & CIOVERWRITE))) {
            z = edge.start.point[2];
            dz = edge.dz*div;
         }

      }

      else {
         start = scanxy + FIXED_TO_INT(edge.start.fxpoint[0] + edge.fxdx);
         end   = scanxy + FIXED_TO_INT(edge.start.fxpoint[0]);

         div = ((gengine *)proc)->xbuff[end-start];

         if (!((mcinfo.info & CIGHOST) && (mcinfo.info & CIOVERWRITE))) {
            z = edge.start.point[2] + edge.dz;
            dz = -edge.dz*div;
         }

      }
      
      if (start == end)
         end++;
	 
      for (tz.f = 1.0f/z; start < end; start++) {

         if ((mcinfo.info & CIOVERWRITE) || tz.i > zdata[start]) {

            if (mcinfo.info & CITRANSPARENT) {
               set_trans(idata[start], rcolor);
            }

            else if (mcinfo.info & CIGHOST) {
               set_nzbuff(idata[start], rcolor);
            }

            else {
               set_zbuff(zdata[start], idata[start], tz.i, rcolor);
            }

         }

         if (!((mcinfo.info & CIGHOST) && (mcinfo.info & CIOVERWRITE)))
            tz.f = 1.0f/(z += dz);
      }
      
      edge.starty++;
      scanxy += proc->zbuff.maxx;
      edge.start.fxpoint[0] += edge.fxdx;
      edge.start.point[2] += edge.dz;
   }

}
