

#ifdef WIN32
#include <windows.h>
#endif

#include <GL/gl.h>

#include "glfont.h"
#include "gamegine.h"


/* ***********************************************************************
*********************************************************************** */
void glvectorilist::print(int x, int y, unsigned int rgb, mapul *mapbuffer) {

   int i;

   glBegin(GL_LINE_STRIP);
      for (i=0; i<count; i++)
         glVertex2i(pt[i][0]+x, pt[i][1]+y);
   glEnd();
}


/* ***********************************************************************
*********************************************************************** */
void glvectorchar::init(int i) {

   count = i;

   if (master)
      delete [] master;

   if (v)
      delete [] v;

   master = new vectorflist[count];
   v = new glvectorilist[count];
}


/* ***********************************************************************
*********************************************************************** */
int glvectorchar::print(int *x, int y, unsigned int rgb, mapul *mapbuffer) {

   int i;

   if (*x+isizex < 0 || y+isizey < 0) {
      *x += isizex;
      return 1;
   }

   if (*x >= (int)mapbuffer->maxx)
      return 0;

   for (i=0; i<count; i++)
      ((glvectorilist *)v)[i].print(*x, y, rgb, mapbuffer);

   *x += isizex;
   return 1;
}


/* ***********************************************************************
*********************************************************************** */
void glvectorfont::print(int x, int y, unsigned char *str, mapul *mapbuffer)  {

   if (y >= (int)mapbuffer->maxy || x >= (int)mapbuffer->maxx)
      return;

   glColor3ubv((unsigned char *)&rgb);

   for (; *str; str++)
      if (!((glvectorchar *)vfont)[*str].print(&x, y, rgb, mapbuffer))
         return;
}


/* ***********************************************************************
*********************************************************************** */
void glvectorfont::set_color(char r, char g, char b) {

   if (r == ccolor[0] && g == ccolor[1] && b == ccolor[2])
      return;

   ccolor[0] = r;
   ccolor[1] = g;
   ccolor[2] = b;
   
   copyarray3(((unsigned char *)&rgb), ccolor);
}


/* ***********************************************************************
*********************************************************************** */
void glvectorfont::init() {

   if (vfont)
      delete [] vfont;

   vfont = new glvectorchar[256];
}


/* ***********************************************************************
*********************************************************************** */
void glrasterfont::print(int x, int y, unsigned char *str, mapul *mapbuffer)  {

   fixed_pt ur;
   vector2i ill, iur;
   rasterchar *v;
   
   iur[1] = (int)(y + font_scale);

   if (y >= (int)mapbuffer->maxy || iur[1] < 0 || x >= (int)mapbuffer->maxx || x + pixel_length(str) < 0)
      return;

   // prevents from being called for each letter
   glEnable(GL_BLEND);
   glBlendFunc(GL_ONE, GL_ONE_MINUS_SRC_ALPHA);
   
   ill[1] = y;
   
   for (ur = INT_TO_FIXED(x); *str && ur < 0; str++, ur += vfont[*str].fssize);
      
   for (iur[0] = FIXED_TO_INT(ur); *str && iur[0] < (int)mapbuffer->maxx; str++) {
      v = &vfont[*str];
      
      if (v->tmap) {
         ur += v->fssize;

         ill[0] = iur[0];
         iur[0] = FIXED_TO_INT(ur);
      
         complex->gfx->gfxPaste2D(NULL, v->tmap, ccolor, ill, iur, v->ll, v->ur, GFX_NULL);
      }

   }
   
   // prevents from being called for each letter
   glDisable(GL_BLEND);
}


/* ***********************************************************************
*********************************************************************** */
void glfrasterfont::printf(float x, float y, unsigned char *str, mapul *mapbuffer)  {

   vector2f ll, ur;
   rasterchar *v;

   ur[1] = y + font_scale;
   ll[1] = y;

   glEnable(GL_BLEND);
   glBlendFunc(GL_ONE, GL_ONE_MINUS_SRC_ALPHA);
   glEnable(GL_TEXTURE_2D);
      
   glColor3ubv(ccolor);
 
   for (ur[0] = x; *str; str++) {
      v = &vfont[*str];
      
      if (v->tmap) {
         ll[0] = ur[0];
         ur[0] += (float)FIXED_TO_FLOAT(v->fssize);

         complex->gfx->gfxSetTexture((basic_texture_block *)v->tmap->query_data());

         glBegin(GL_POLYGON);
            glTexCoord2fv(v->ll);
            glVertex2fv(ll);
            glTexCoord2f(v->ll[0], v->ur[1]);
            glVertex2f(ll[0], ur[1]);
            glTexCoord2fv(v->ur);
            glVertex2fv(ur);
            glTexCoord2f(v->ur[0], v->ll[1]);
            glVertex2f(ur[0], ll[1]);
         glEnd();
      }

   }
   
   glDisable(GL_TEXTURE_2D);
   glDisable(GL_BLEND);
}

