

#include "gltexture.h"
#include "gamegine.h"
#include "image.h"
#include "imgman.h"

#ifdef WIN32
#include "win_wgl.h"
#else
#include <GL/gl.h>
#endif


/* *****************************************************************************************
***************************************************************************************** */
void gl_texture::cleanup() {

   int type;

   if (!tblock || tblock->query_whatami() != TEXTURE_BLOCK_TYPE_OGL)
      return;

   type = ((texture_block_ogl *)tblock)->tex_id;
   ((texture_block_ogl *)tblock)->tex_id = -1;

   if (type)
      ((ogl_gfx *)complex->gfx)->ogl_gfxDeallocTexID(type, &dataname);
}


/* *****************************************************************************************
***************************************************************************************** */
void gl_texture::update(float current_time) {

   if (!tblock || !(statusflag & STATUSFLAG_LOADABLE))
      return;

   if (!(statusflag & STATUSFLAG_TIME_UPDATE)) {
      cleanup();

      delete tblock;
      tblock = NULL;

      statusflag &= ~STATUSFLAG_LOADED;
      return;
   }

   global_statistic_texture_count++;
   access_time = current_time;
   statusflag &= ~STATUSFLAG_TIME_UPDATE;
}


/* *****************************************************************************************
***************************************************************************************** */
void *gl_texture::query_data() {

   unsigned int flip;
   sfile sinfile;

   if (tblock) {
      statusflag |= STATUSFLAG_TIME_UPDATE;
      return tblock;
   }

   if (!(statusflag & STATUSFLAG_LOADABLE))
      return NULL;

   if (!sinfile.scan_data(dataname.string, TEXTURE_PATH.string, PLATFORM_SLASH))
      return NULL;

   current_loader = (image_coder *)((dbl_llist_manager *)global_resource_manager->get_resource_object(RESOURCE_IMAGE_LOADER))->head;

   if (!current_loader)
      return NULL;

   current_loader = (image_coder *)current_loader->find_loader(&sinfile);

   if (!current_loader)
      return NULL;

   flip = ((frame_manager *)global_resource_manager)->query_color_byte_order();
   tblock = new texture_block;
      
   if (!current_loader->scan_data(&((texture_block *)tblock)->tob, flip)) {
      current_loader->cleanup();
      current_loader = NULL;
      delete tblock;
      return tblock = NULL;
   }

   maxx = ((texture_block *)tblock)->tob.maxx;
   maxy = ((texture_block *)tblock)->tob.maxy;
   statusflag |= STATUSFLAG_LOADED | STATUSFLAG_TIME_UPDATE;

   ((frame_manager *)global_resource_manager)->postprocessCBtexture(this);

   current_loader->cleanup();
   current_loader = NULL;

   return tblock;
}


/* *****************************************************************
***************************************************************** */
void gl_texture::replace_data(void *subresource) {

   if (tblock) {
      cleanup();
      delete tblock;
   }

   tblock = (basic_texture_block *)subresource;
}


/* *****************************************************************************************
***************************************************************************************** */
int gl_texture::pre_process_texture() {

   texture_block_ogl *tblock_ogl;
   int found;
   int i;

   texture::pre_process_texture();

   if (!tblock || tblock->query_whatami() == TEXTURE_BLOCK_TYPE_OGL)
      return 0;

   tblock_ogl = new texture_block_ogl;
   tblock_ogl->tex_id = ((ogl_gfx *)complex->gfx)->ogl_gfxAllocTexID(&dataname, &found);

   if (!found) {
      glBindTexture(GL_TEXTURE_2D, complex->gfx->gfx_current_texid = tblock_ogl->tex_id);
      glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
      glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
      glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

      build_mipmaps((dbl_llist_manager *)global_resource_manager->get_resource_object(RESOURCE_IMAGE_LOADER), ((frame_manager *)global_resource_manager)->query_color_byte_order());

      if (((texture_block *)tblock)->mipmap) {
         glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);
         for (i=0; i<((texture_block *)tblock)->mipmapcount; i++)
            glTexImage2D(GL_TEXTURE_2D, i, GL_RGBA, ((texture_block *)tblock)->mipmap[i].tob->maxx, ((texture_block *)tblock)->mipmap[i].tob->maxy, 0, GL_RGBA, GL_UNSIGNED_BYTE, ((texture_block *)tblock)->mipmap[i].tob->data);
      }

      else { 
         glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
         glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, maxx, maxy, 0, GL_RGBA, GL_UNSIGNED_BYTE, ((texture_block *)tblock)->tob.data);
      }

   }

   delete tblock;
   tblock = tblock_ogl;
   return 1;
}


/* *****************************************************************************************
***************************************************************************************** */
void gl_texture::build_mipmaps(dbl_llist_manager *image_handler, int flip) {

   int i, j;
   dbl_llist_manager manager;
   mipmap_list_type *ptr;

   if (!tblock || tblock->query_whatami() == TEXTURE_BLOCK_TYPE_OGL)
      return;

   if (((texture_block *)tblock)->mipmap) {
      ((texture_block *)tblock)->mipmap[0].init();
      delete [] ((texture_block *)tblock)->mipmap;
      ((texture_block *)tblock)->mipmap = NULL;
   }

   // look for pre-built in mipmaps in image
   if (current_loader) {
      ((texture_block *)tblock)->mipmapcount = current_loader->extract(IMAGE_GET_MIPMAP32, &manager, flip);

      if (manager.head) {
         ((texture_block *)tblock)->mipmap = new mipmaptype[((texture_block *)tblock)->mipmapcount];
         ((texture_block *)tblock)->mipmap[0].tob = &((texture_block *)tblock)->tob;
         for (i=1, ptr = (mipmap_list_type *)manager.head; ptr; i++, ptr = (mipmap_list_type *)ptr->next)
            ((texture_block *)tblock)->mipmap[i].tob = (mapul *)ptr->tob;
         return;
      }

   }

   i = (((texture_block *)tblock)->tob.maxx > ((texture_block *)tblock)->tob.maxy) ? ((texture_block *)tblock)->tob.maxx : ((texture_block *)tblock)->tob.maxy;

   for (((texture_block *)tblock)->mipmapcount=1, j=1; j<i; j+=j, ((texture_block *)tblock)->mipmapcount++);

   if (((texture_block *)tblock)->mipmapcount == 1)
      return;

   ((texture_block *)tblock)->mipmap = new mipmaptype[((texture_block *)tblock)->mipmapcount];

   ((texture_block *)tblock)->mipmap[0].tob = &((texture_block *)tblock)->tob;

   for (i=1; i<((texture_block *)tblock)->mipmapcount; i++) {
      ((texture_block *)tblock)->mipmap[i].tob = new mapul;
      imgman_build_mipmap(((texture_block *)tblock)->mipmap[i-1].tob, ((texture_block *)tblock)->mipmap[i].tob, IMGMAN_TEXTURE_REPEAT, ((frame_manager *)global_resource_manager)->query_color_byte_order());
   }

}


/* *****************************************************************************************
***************************************************************************************** */
int gl_texture::read_texture(sfile *sinfile, dbl_llist_manager *image_handler, image_coder *loader, int flag256, int flip) {

   if (tblock) {
      delete tblock;
      tblock = NULL;
   }

   dataname.stringcpy(&sinfile->filename);
   statusflag = STATUSFLAG_VOID;

   tblock = new texture_block;

   current_loader = loader;

   if (!current_loader->scan_data(&((texture_block *)tblock)->tob, flip)) {
      current_loader = NULL;
      delete tblock;
      tblock = NULL;
      return 0;
   }

   global_resource_manager->register_resource_object(RESOURCE_TEXTURE, this);

   oldx = maxx = ((texture_block *)tblock)->tob.maxx;
   oldy = maxy = ((texture_block *)tblock)->tob.maxy;
   statusflag |= STATUSFLAG_LOADED | STATUSFLAG_LOADABLE;

   ((frame_manager *)global_resource_manager)->postprocessCBtexture(this);
   current_loader = NULL;

   return 1;
}


/* *****************************************************************************************
***************************************************************************************** */
unsigned int gl_texture::query_texel(float x, float y, float *color, int frame, float d) {

// asdf tbd
return 0;
}

