



/* *************************************************************
   This function scans poligonal objects into a zbuffer
************************************************************* */

#ifdef WIN32
#include <windows.h>
#endif

#include <GL/gl.h>

#include "glpolygon.h"
#include "gamegine.h"


/* **************************************************
************************************************** */
void glpolygon::init_material(shadetype *material) {

   vector4f v;

   v[3] = 1.0f;

   copyarray3(v, material->fka);
   glMaterialfv(GL_FRONT, GL_AMBIENT, v);

   copyarray3(v, material->fkp);
   glMaterialfv(GL_FRONT, GL_DIFFUSE, v);

   copyarray3(v, material->fks);
   glMaterialfv(GL_FRONT, GL_SPECULAR, v);

   copyarray3(v, material->flum);
   glMaterialfv(GL_FRONT, GL_EMISSION, v);

   glMaterialf(GL_FRONT, GL_SHININESS, material->specn);
}


/* **************************************************
************************************************** */
void glpolygon::render_material() {

   int i, j;
   face_type *flist;
   shadetype *material = NULL;
   int tstate = 0;
   texbase *tex;

   vector3f work, cam;
   
   // calc camera position in object space
   cam[0] = iworld[0][3];
   cam[1] = iworld[1][3];
   cam[2] = iworld[2][3];

   switch (mctype.model) {

      case GOURAUD:
      case PHONG:

         for (i=0, flist = pot->flist; i<dob->countobject; i++, flist++) {

            subeqarray3(work, pot->vlist[flist->edgeptr[0]], cam);

            if (dotproduct3(work, flist->normal) > 0)
               continue;

            if (sblock->facelist[i] != material)
               init_material(material = sblock->facelist[i]);
	    	       
            if ((mcinfo.info & CITEXTURE) && tob->query_tflag(i)) {
               if (!tstate) {
                  tstate = 1;
                  glEnable(GL_TEXTURE_2D);
               }

               tob->query_data(i, TEXTURE2D_QUERY_TEXTURE, &frame, &tex);
               complex->gfx->gfxSetTexture((basic_texture_block *)tex->query_data());

               glBegin(GL_POLYGON);
                  for (j=0; j<flist->polynum; j++) {
                     glTexCoord2fv(uvblock[i].uv[j]);
                     glArrayElement(flist->edgeptr[j]);
                  }

               glEnd();
            }

            else {
               if (tstate) {
                  tstate = 0;
                  glDisable(GL_TEXTURE_2D);
               }

               glDrawElements(GL_POLYGON, flist->polynum, GL_UNSIGNED_INT, flist->edgeptr);
            }

         }

         if (tstate) {
            tstate = 0;
            glDisable(GL_TEXTURE_2D);
         }

         break;

      case CONSTANT:
      case FLAT:

         for (i=0, flist = pot->flist; i<dob->countobject; i++, flist++) {

            subeqarray3(work, pot->vlist[flist->edgeptr[0]], cam);

            if (dotproduct3(work, flist->normal) > 0)
               continue;

            if (sblock->facelist[i] != material)
               init_material(material = sblock->facelist[i]);
	    	       
            glNormal3fv(flist->normal);

            if ((mcinfo.info & CITEXTURE) && tob->query_tflag(i)) {
               if (!tstate) {
                  tstate = 1;
                  glEnable(GL_TEXTURE_2D);
               }

               tob->query_data(i, TEXTURE2D_QUERY_TEXTURE, &frame, &tex);
               complex->gfx->gfxSetTexture((basic_texture_block *)tex->query_data());

               glBegin(GL_POLYGON);
                  for (j=0; j<flist->polynum; j++) {
                     glTexCoord2fv(uvblock[i].uv[j]);
                     glArrayElement(flist->edgeptr[j]);
                  }

               glEnd();
            }

            else {
               if (tstate) {
                  tstate = 0;
                  glDisable(GL_TEXTURE_2D);
               }

               glDrawElements(GL_POLYGON, flist->polynum, GL_UNSIGNED_INT, flist->edgeptr);
            }

         }

         if (tstate) {
            tstate = 0;
            glDisable(GL_TEXTURE_2D);
         }

         break;

      default:	// BW/WFBW/DOT
         break;
   }

}


/* **************************************************
  Assumed default state:
  GL_LIGHTING - disabled
  GL_CULL_FACE - disabled
  GL_XXX_ARRAY's - disabled
  GL_DEPTH_TEST - enabled
************************************************** */
void glpolygon::render(camera *cparm, light *lmain, light *spot, engine *proc) {

   vector4f mx[4];
   int normalize_flag;
   int i;
   float temp;
    
   glMatrixMode(GL_MODELVIEW);
   transpose(mx, world);
   glLoadMatrixf((GLfloat *)mx);

   proc->countface += dob->countobject;

   glEnableClientState(GL_VERTEX_ARRAY);
   glVertexPointer(3, GL_FLOAT, 16, pot->vlist);

   // if we have a skew/shear/scale matrix, then recalc normals
   temp = (float)(1 + CORRECT);
   normalize_flag = dotproduct3(mx[0], mx[0]) > temp || dotproduct3(mx[1], mx[1]) > temp || dotproduct3(mx[2], mx[2]) > temp;

   if (normalize_flag)
      glEnable(GL_NORMALIZE);
      
   switch (mctype.model) {

      case GOURAUD:
      case PHONG:
         glEnable(GL_LIGHTING);

         glEnableClientState(GL_NORMAL_ARRAY);
         glNormalPointer(GL_FLOAT, 0, pot->nlist);

         render_material();

         glDisableClientState(GL_NORMAL_ARRAY);
         glDisable(GL_LIGHTING);

         break;

      case CONSTANT:
      case FLAT:
         glEnable(GL_LIGHTING);

         render_material();

         glDisable(GL_LIGHTING);

         break;

      case BW:
      case WFBW:
         glColor3ub(255, 255, 255);

         for (i=0; i<dob->countobject; i++)
            glDrawElements(GL_LINE_LOOP, pot->flist[i].polynum, GL_UNSIGNED_INT, pot->flist[i].edgeptr);

         break;

      default:	// DOT
        break;
   }

   if (normalize_flag)
      glDisable(GL_NORMALIZE);
      
   glDisableClientState(GL_VERTEX_ARRAY);
}


/* **************************************************
   This function scans polygonal data and puts it in a zbuffer.
************************************************** */
void glpolygon::prender(engine *proc) {

   render(NULL, NULL, NULL, proc);
}

