

#include "glpolygon.h"


/* *************************************************************
   This procedure takes the basic object data, and creates a composite
   structure to be worked on.
************************************************************* */
void glpolygon::datacopy() {

   mctype.datacopy();
   mcinfo.datacopy();

   pot = (polygon_object_type *)dob->query_data();

   if (mctype.model > BW)
      sblock = (shade_block *)lob->query_data();
	 
   if (mcinfo.info & CITEXTURE)
      uvblock = (texface *)tob->query_data();

   base_color = mctype.model > BW ? &lob->base : NULL;

   polyflag = 0;
}


/* **************************************************
   This function scans polygonal data and puts it in a zbuffer.
************************************************** */
int glpolygon::scan(camera *cparm, light *lmain, engine *proc) {

   renderflag = 0;

   proc->countvertex += dob->countvertex;

   if (!(polyflag & POLYFLAG_TRANSFORM))
      transform(cparm);                  // transform objects

   bound_box(cparm);

   renderflag = 1;
   return 1;
}

