
#ifdef WIN32
#include <windows.h>
#endif

#include <GL/gl.h>

#include "glline.h"


/* **************************************************
************************************************** */
int glline::scan(camera *cparm, light *lmain, engine *proc) {

   renderflag = 1;
   return 1;
}


/* **************************************************
************************************************** */
void glline::render(camera *cparm, light *lmain, light *spot, engine *proc) {

   vector4f mx[4];
   vector3f v;
   
   glMatrixMode(GL_MODELVIEW);
   transpose(mx, cparm->transform);
   glLoadMatrixf((GLfloat *)mx);

   subeqarray3(v, wwai[0], wwai[1]);
   
   if (dotproduct3(v,v) < 2) {
   
      if (mctype.model == GOURAUD)
         glColor3ub((int)wcolor[0][0], (int)wcolor[0][1], (int)wcolor[0][2]);
      else
         glColor3ub(255, 255, 255);

      glBegin(GL_POINTS);
         glVertex3fv(wwai[0]);
      glEnd();

      return;
   }
   
   glBegin(GL_LINES);

      if (mctype.model == GOURAUD) {
         glColor3ub((int)wcolor[0][0], (int)wcolor[0][1], (int)wcolor[0][2]);
         glVertex3fv(wwai[0]);
         glColor3ub((int)wcolor[1][0], (int)wcolor[1][1], (int)wcolor[1][2]);
         glVertex3fv(wwai[1]);
      }

      else {
         glColor3ub(255, 255, 255);
         glVertex3fv(wwai[0]);
         glVertex3fv(wwai[1]);
      }
      
   glEnd();
}


/* **************************************************
************************************************** */
void glline::prender(engine *proc) {

   render(NULL, NULL, NULL, proc);
}

