

#ifdef WIN32
#include <windows.h>
#else
#include <X11/Xlib.h>
#endif

#include "gfx.h"


/* *************************************************************
************************************************************* */
base_gfx::base_gfx() {

   gfx_state = GFX_CLEAR_COLOR_BUFFER | GFX_CLEAR_DEPTH_BUFFER;
   gfx_current_texid = -1;
}


/* *************************************************************
************************************************************* */
base_gfx::~base_gfx() { gfxDest(); }


/* *************************************************************
************************************************************* */
void base_gfx::gfxInit() {

   gfxDest();

   gfx_state = GFX_CLEAR_COLOR_BUFFER | GFX_CLEAR_DEPTH_BUFFER;
   gfx_current_texid = -1;
}


/* *************************************************************
************************************************************* */
void base_gfx::gfxDest() {

}


/* *************************************************************
************************************************************* */
void base_gfx::gfxSetTexture(basic_texture_block *tex) {

}


/* *************************************************************
************************************************************* */
void gfx_get_screen_dim(int *winx, int *winy) {

#ifdef WIN32
   RECT rect;

   if (GetWindowRect(GetDesktopWindow(), &rect)) {
      *winx = rect.right - rect.left;
      *winy = rect.bottom - rect.top;
      return;
   }

#else
   Display *mdisplay;
   XWindowAttributes wa;

   if ((mdisplay = XOpenDisplay(NULL))) {
      XGetWindowAttributes(mdisplay, XRootWindow (mdisplay, XDefaultScreen(mdisplay)), &wa);
      XCloseDisplay(mdisplay);
      *winx = wa.width;
      *winy = wa.height;
      return;
   }

#endif

   *winx = 640;
   *winy = 480;
}


