

#include "gamegine.h"
#include "flat.h"


/* *************************************************************
   No culling - assumed to have been done by render_object()
************************************************************* */
void gengine::cullnsort(eye *parm, pc *list, pc **start_list, pc **final_list, int direction) {

   pc *ptr, *head, *last, *boundless;
   frameclass **qtr;
   vector4f frustum[6];
   
   head = list;
   last = list = boundless = NULL;

   parm->query_frustum(frustum);

   while (head) {
      ptr = head;
      head = (pc *)head->next;

      if (!ptr->bvalid_flag) {
         ptr->next = boundless;
         boundless = ptr;
         continue;
      }

      ptr->bwork = dotproduct3(frustum[FRUSTUM_FRONT], ptr->bcenter) + frustum[FRUSTUM_FRONT][3] + front + ptr->bradius;

      if (!last) {
         list = last = ptr;
         ptr->next = NULL;
         continue;
      }

      // sort based on farthest distance
      if (ptr->groundflag == MIDGROUND) {

         if (direction == SORT_ASCENDING) {
            for (qtr=(frameclass **)&list; *qtr; qtr=&(*qtr)->next)
               if (ptr->bwork <= ((pc *)*qtr)->bwork) {
                  ptr->next = *qtr;
                  *qtr = ptr;
                  break;
               }

         }

         else { // SORT_DECENDING
            for (qtr=(frameclass **)&list; *qtr; qtr=&(*qtr)->next)
               if (ptr->bwork >= ((pc *)*qtr)->bwork) {
                  ptr->next = *qtr;
                  *qtr = ptr;
                  break;
               }

         }

      }

      else {
         for (qtr=(frameclass **)&list; *qtr; qtr=&(*qtr)->next)
            if (ptr->renderpriority <= ((pc *)*qtr)->renderpriority) {
               ptr->next = *qtr;
               *qtr = ptr;
               break;
            }

      }

      if (*qtr)
         continue;

      ptr->next = NULL;
      last->next = ptr;
      last = ptr;
   }

   if (boundless)
      if (!list)
         list = boundless;
      else
         last->next = boundless;

   *start_list = list;
   *final_list = NULL;
}


/* *************************************************************
   No culling - assumed to have been done by render_object()
************************************************************* */
void gengine::cull(eye *parm, pc *list, pc **start_list, pc **final_list) {

   pc *ptr, *head, *last, *boundless;

   head = list;
   list = last = boundless = NULL;

   while (head) {
      ptr = head;
      head = (pc *)head->next;

      if (!ptr->bvalid_flag) {
         ptr->next = boundless;
         boundless = ptr;
         continue;
      }

      if (!last)
         last = list;
 
      ptr->next = list;
      list = ptr;
   }

   if (boundless)
      if (!list)
         list = boundless;
      else
         last->next = boundless;

   *start_list = list;
   *final_list = NULL;
}


/* *************************************************************
************************************************************* */
gengine::gengine() {

   control = new memman(MAXLISTS, MAXBUFFERS);
   snapcount = 0; winx = winy = 0;
   xdata = ydata = xbuff = ybuff = NULL;
   flatdtr[FOREGROUND] = flatdtr[MIDGROUND] = flatdtr[BACKGROUND] = NULL;
   iflatdtr[FOREGROUND] = iflatdtr[MIDGROUND] = iflatdtr[BACKGROUND] = NULL;
   tflatdtr[FOREGROUND] = tflatdtr[MIDGROUND] = tflatdtr[BACKGROUND] = NULL;
}


/* *************************************************************
************************************************************* */
gengine::~gengine() {

   if (xdata)
      delete [] xdata;
      
   if (ydata)
      delete [] ydata;
}


/* *************************************************************
************************************************************* */
void gengine::render_list(pc *ptr, int frame_id, int transflag) {

   int oldflag = GFX_NULL;
   int newflag;

   for (; ptr; ptr=(pc *)ptr->next) {

      if (ptr->mcinfo.info & CIOVERWRITE)
         newflag = (ptr->mcinfo.info & CIGHOST) ? GFX_DEPTH_TEST : GFX_OVERWRITE;
      else
         newflag = (!transflag && (ptr->mcinfo.info & CIGHOST)) ? GFX_GHOST : GFX_NULL;

      if (newflag != oldflag) {
         switch (oldflag) {
            case GFX_DEPTH_TEST:
               complex->gfx->gfxEnable(GFX_DEPTH_TEST);
               break;

            case GFX_OVERWRITE:
            case GFX_GHOST:
               complex->gfx->gfxDisable(oldflag);
               break;

            default:
               break;
         }
         
         switch (newflag) {
            case GFX_DEPTH_TEST:
               complex->gfx->gfxDisable(GFX_DEPTH_TEST);
               break;

            case GFX_OVERWRITE:
            case GFX_GHOST:
               complex->gfx->gfxEnable(newflag);
               break;

            default:
               break;
         }

         oldflag = newflag;
      }

      ptr->frame = frame_id;
      ptr->begin_scan();
      ptr->datacopy();

      if (ptr->scan(frame.camdtr, frame.lightdtr, this))
         ptr->render(frame.camdtr, frame.lightdtr, frame.beamdtr, this);

      ptr->end_scan();
   }

   switch (oldflag) {
      case GFX_DEPTH_TEST:
         complex->gfx->gfxEnable(GFX_DEPTH_TEST);
         break;

      case GFX_OVERWRITE:
      case GFX_GHOST:
         complex->gfx->gfxDisable(oldflag);
         break;

      default:
         break;
   }
         
}


/* *************************************************************
   inits z/depth buffer only (not ambient or diffuse)
************************************************************* */
void gengine::initbuff(unsigned int *d, puint *pd, float *zd, unsigned int x, unsigned int y, float backplane) {

   int i;
   union { float fback; unsigned int uint; };

   i = x*y;
   fback = backplane;

   zbuff.data  = d;
   zbuff.pdata = pd;
   zbuff.zdata = zd;

   zbuff.maxx = x;
   zbuff.maxy = y;

   if (complex->gfx->gfx_state & GFX_CLEAR_COLOR_BUFFER)
      while (i) {
         i -= x;
         init_buff((unsigned int *)&zd[i], uint, x);
         init_buff(&d[i], 0, x);
      }
                                                                                
   else
      while (i) {
         i -= x;
         init_buff((unsigned int *)&zd[i], uint, x);
      }
                                                                                
   if (x > (unsigned int)winx) {
      winx = x;
      if (xdata)
         delete [] xdata;

      xdata = new float[(11+winx) & 0xfffffffc];
      xbuff = xdata + 4;

      xdata[0] = xdata[1] = xdata[2] = xdata[3] = 1;

      xbuff[0] = 1;
      for (i=1; i<winx+4; i++)
         xbuff[i] = 1.0f/i;
   }

   if (y > (unsigned int)winy) {
      winy = y;
      if (ydata)
         delete [] ydata;

      ydata = new float[(11+winy) & 0xfffffffc];
      ybuff = ydata + 4;

      ydata[0] = ydata[1] = ydata[2] = ydata[3] = 1;

      ybuff[0] = 1;
      for (i=1; i<winy+4; i++)
         ybuff[i] = 1.0f/i;
   }

}


/* *************************************************************
    render for game engine
************************************************************* */
void gengine::spawn(int frame_id, mapul *mapbuffer) {

   pc *ptr;
   int i;

   complex->gfx->gfxClear(mapbuffer, &zdata);

   if (!frame.camdtr || !frame.lightdtr) {
      zbuff.pdata = NULL;
      zbuff.data  = NULL;
      zbuff.zdata = NULL;
      return;
   }

   complex->gfx->gfx3DModeBegin(frame.camdtr, frame.lightdtr, mapbuffer->maxx, mapbuffer->maxy);

   frame.camdtr->calc_clip_plane();

   for (i=0; i<MAXGROUND; i++) {
   
      if (game_fogflag[i])
         complex->gfx->gfxEnable(GFX_FOG);

      // render objects
      cullnsort(frame.camdtr, frame.solidtr[i], &ptr, &frame.solidtr[i]);
      render_list(ptr, frame_id, 0);

      // render flats
      cull(frame.camdtr, flatdtr[i], &ptr, &flatdtr[i]);
      render_list(ptr, frame_id, 0);
      
      // render invisos
      complex->gfx->gfxEnable(GFX_INVISO);

      // render inviso objects
      cullnsort(frame.camdtr, frame.invisotr[i], &ptr, &frame.invisotr[i]);
      render_list(ptr, frame_id, 0);

      // render inviso flats
      cull(frame.camdtr, iflatdtr[i], &ptr, &iflatdtr[i]);
      render_list(ptr, frame_id, 0);

      complex->gfx->gfxDisable(GFX_INVISO);

      // render transparents
      complex->gfx->gfxEnable(GFX_TRANSPARENT);

      // render transparent objects
      cull(frame.camdtr, frame.transtr[i], &ptr, &frame.transtr[i]);
      render_list(ptr, frame_id, 1);

      // render transparent flats
      cull(frame.camdtr, tflatdtr[i], &ptr, &tflatdtr[i]);
      render_list(ptr, frame_id, 1);

      complex->gfx->gfxDisable(GFX_TRANSPARENT);
      
      if (game_fogflag[i])
         complex->gfx->gfxDisable(GFX_FOG);      
   }

   zbuff.pdata = NULL;
   zbuff.data  = NULL;
   zbuff.zdata = NULL;
   complex->gfx->gfx3DModeEnd();
}


/* *************************************************************
************************************************************* */
void gengine::engine_init() {

   engine::engine_init();
   flatdtr[FOREGROUND] = flatdtr[MIDGROUND] = flatdtr[BACKGROUND] = NULL;
   iflatdtr[FOREGROUND] = iflatdtr[MIDGROUND] = iflatdtr[BACKGROUND] = NULL;
   tflatdtr[FOREGROUND] = tflatdtr[MIDGROUND] = tflatdtr[BACKGROUND] = NULL;
}


/* *************************************************************
************************************************************* */
void gengine::engine_submit(frameclass *ob) {

   pc **obj;
   unsigned int texid;

   if (ob->query_whatami() == OBJECT_GLFLAT) {

      texid = ((glflat *)ob)->current_tex_id;

      if (((pc *)ob)->mcinfo.query_master() & CITRANSPARENT)
         obj = &tflatdtr[((pc *)ob)->groundflag];
      else if (((pc *)ob)->mcinfo.query_master() & CIINVISO)
         obj = &iflatdtr[((pc *)ob)->groundflag];
      else
         obj = &flatdtr[((pc *)ob)->groundflag];

      while (*obj && texid < ((glflat *)*obj)->current_tex_id)
         obj = (pc **)&(*obj)->next;

      ob->next = *obj;
      *obj = (pc *)ob;
      return;
   }

   if (ob->query_whatami() == OBJECT_FLAT) {

      texid = ((flat *)ob)->current_tex_id;

      if (((pc *)ob)->mcinfo.query_master() & CITRANSPARENT)
         obj = &tflatdtr[((pc *)ob)->groundflag];
      else if (((pc *)ob)->mcinfo.query_master() & CIINVISO)
         obj = &iflatdtr[((pc *)ob)->groundflag];
      else
         obj = &flatdtr[((pc *)ob)->groundflag];

      while (*obj && texid < ((flat *)*obj)->current_tex_id)
         obj = (pc **)&(*obj)->next;

      ob->next = *obj;
      *obj = (pc *)ob;
      return;
   }

   // override engine...
   if (ob->query_category() == CLASS_OBJECT) {
      if (((pc *)ob)->mcinfo.query_master() & CITRANSPARENT)
         obj = &frame.transtr[((pc *)ob)->groundflag];
      else if (((pc *)ob)->mcinfo.query_master() & CIINVISO)
         obj = &frame.invisotr[((pc *)ob)->groundflag];
      else
         obj = &frame.solidtr[((pc *)ob)->groundflag];

      ob->next = *obj;
      *obj = (pc *)ob;
      return;
   }
   
   engine::engine_submit(ob);
}

