

#include <stdlib.h>
#include <string.h>

#include "gamegine.h"
#include "pstring.h"


/* *************************************************************
************************************************************* */
int gamequark::query_whatwasi(int type) {

   return (gamequark::query_whatami() == type) ? 1 : quark::query_whatwasi(type);
}


/* *************************************************************
************************************************************* */
void gamequark::preprocess(void *data) {

    quark::preprocess(data);

    hp = total_hp = init_hp;
    atomparent = ((geneological_type *)data)->tree;

    if (atomparent)
       flags |= atomparent->htree->flags & GAMEFLAG_ALLIANCE_MASK;

   if (!ob)
      return;

   ((pc *)ob)->bound_sphere();

   if (((pc *)ob)->bvalid_flag) {
      old_state.state_flags &= ~(STATE_MASK_BOUND | STATE_FLAG_AUTO_UPDATE);
      old_state.state_flags |= STATE_FLAG_BSPHERE;
      
      state.state_flags &= ~(STATE_MASK_BOUND | STATE_FLAG_AUTO_UPDATE);
      state.state_flags |= STATE_FLAG_BSPHERE;

      old_state.bradius = state.bradius = ((pc *)ob)->bradius;
      copyarray3(state.bcenter, ((pc *)ob)->bcenter);
      copyarray3(old_state.bcenter, ((pc *)ob)->bcenter);
   }

}


/* *************************************************************
************************************************************* */
void gamequark::setup() {

   if (!ob)
      return;

   ((pc *)ob)->rotate = state.xmx;
   ((pc *)ob)->bound_sphere();

   if (((pc *)ob)->bvalid_flag) {
      state.state_flags &= ~(STATE_MASK_BOUND | STATE_FLAG_AUTO_UPDATE);
      state.state_flags |= STATE_FLAG_BSPHERE;
      state.bradius = ((pc *)ob)->bradius;
      copyarray3(state.bcenter, ((pc *)ob)->bcenter);
   }

}


/* *************************************************************
************************************************************* */
void gamequark::render_object(engine *proc, quark *parent, vector4f *frustum, unsigned int frustum_flag) {

   linktype *ptr;
   unsigned int j;
   union { vector4uc tuc; unsigned int tui; };

   // cull node w/ view frustum
   if ((old_state.state_flags & STATE_MASK_TREE) == STATE_FLAG_TNONE)
      frustum_flag = 0;

   if (frustum_flag) {
      if ((old_state.state_flags & STATE_MASK_TREE) == STATE_FLAG_TSPHERE &&
          query_frustum_clip(old_state.tree_radius, old_state.tree_center, frustum, &frustum_flag, frustum_fail_data))
         return;

      j = frustum_flag;
      tui = frustum_fail_flag;

      if (ob && (flags & QUARK_FLAG_ACTIVE) && (!frustum_flag || !((pc *)ob)->bvalid_flag ||
          !query_frustum_clip(((pc *)ob)->bradius, ((pc *)ob)->bcenter, frustum, &j, tuc)))
         proc->engine_submit(ob);
   }

   else if (ob && (flags & QUARK_FLAG_ACTIVE))
      proc->engine_submit(ob);

   for (ptr=(linktype *)edge.head; ptr; ptr=(linktype *)ptr->next)
      if (ptr->link != parent)
         ptr->link->render_object(proc, this, frustum, frustum_flag);
}


/* *************************************************************
	1) origin   (translate)
	2) quat     (rotate around origin)
    3) init_mx  (translate/rotate offset from parent)
    4) scale    (scale all)
    5) spline   (translate - movement)
    6) xmx      (attach to parent)
************************************************************* */
void gamequark::calc_initmx(vector4f *in, vector4f *out) {

   vector4f r[4], s[4];
   vector4f v;

   if (!(flags & QUARK_FLAG_RECALC)) {
      matmatmulto(in, previous_local_motion, out);
      return;
   }

   // move to origin/pivot point
   motion.calc_localquat(s, complex->timer.speedscale, 1);

   v[0] = -origin[0];
   v[1] = -origin[1];
   v[2] = -origin[2];
   v[3] = 1.0f;

   matvecmulto(s, v);
   s[0][3] = v[0];
   s[1][3] = v[1];
   s[2][3] = v[2];

   // move back...
   out[0][3] += origin[0];
   out[1][3] += origin[1];
   out[2][3] += origin[2];

   // combine w/ global xform
   matmatmulto(initxform, s, r);

   // scale global
   smultarray4(r[0], iscale);
   smultarray4(r[1], iscale);
   smultarray4(r[2], iscale);

    // calc spline
   motion.calc_localspline(v, complex->timer.speedscale, 1);

   r[0][3] += v[0];
   r[1][3] += v[1];
   r[2][3] += v[2];

   copymx4x4o(previous_local_motion, r);

   if (!motion.query_motion())
      flags &= ~QUARK_FLAG_RECALC;

   // concatinate to parent
   matmatmulto(in, r, out);
}


/* *************************************************************
************************************************************* */
int gamequark::parse(FILE *infile, char *token) {

   if (!strcmp(token, TOKEN_HP_STR)) {
      get_token(infile, token);
      init_hp = atoi(token);
      flags |= GAMEFLAG_DEATHCHECK;
      return 1;
   }

   if (!strcmp(token, TOKEN_TARGET_STR)) {
      flags |= GAMEFLAG_TARGETABLE;
      return 1;
   }

   return quark::parse(infile, token);
}


/* *************************************************************
************************************************************* */
void gamequark::update(dbl_llist_manager *hiearchy_manager, quark *parent) {

   subeqarray3(perceived_vel, state.center, old_state.center);
   perceived_vel[3] = complex->timer.speedscale;
   
   quark::update(hiearchy_manager, parent);

   sum_hp(this, parent);

   if (flags & GAMEFLAG_DEATHCHECK)
      deathcheck(parent);
}


/* *************************************************************
************************************************************* */
int gamequark::query_specific_data(unsigned int type, void *data) {

   switch (type) {
      case DATAFLAG_PERCEIVED_VELOCITY:
         *(float **)data = perceived_vel;
         return 1;

      default:
         return quark::query_specific_data(type, data);
   }

}


/* *************************************************************
************************************************************* */
void gamequark::sum_hp(quark *target, quark *parent) {

   linktype *ptr;

   total_hp = hp;

   for (ptr=(linktype *)target->edge.head; ptr; ptr=(linktype *)ptr->next)
      if (ptr->link != parent)
         if (ptr->link->query_category() == CLASS_GAME)
            total_hp += ((gamequark *)ptr->link)->total_hp;
         else
            sum_hp(ptr->link, target);
}


/* *************************************************************
************************************************************* */
int gamequark::apply_damage(unsigned int properties, int *damage, float *pos, vector4f *mx) {

   int ret;
   
   if (*damage <= 0) {
      *damage = 0;
      return 0;
   }

   if (hp <= *damage) {
      ret = hp;
      
      *damage -= hp;
      hp = 0;
      return ret;
   }

   ret = *damage;
   hp -= *damage;
   *damage = 0;
   return ret;
}


/* *************************************************************
************************************************************* */
void gamequark::deathcheck(quark *parent) {

   // remove death check and die!
   if (total_hp <= 0 && (flags & QUARK_FLAG_ACTIVE))
      flags &= ~(GAMEFLAG_DEATHCHECK | QUARK_FLAG_ACTIVE);
}
