

#include <string.h>

#include "gamegine.h"
#include "gltexture.h"


/* *************************************************************
************************************************************* */
game_manager::game_manager() {

}


/* *************************************************************
************************************************************* */
void game_manager::reset() {

   frame_manager::reset();

   sphere_list.dest();
}


/* *************************************************************
************************************************************* */
void game_manager::register_resource_object(int type, void *data) {

   switch (type) {
   
      case RESOURCE_SPHERE:
         sphere_list.insert((resource_type *)data, NULL);
         return;

      case RESOURCE_EQUIP_LOADER:
         equip_loader_list.insert((resource_type *)data, NULL);
         return;

      case RESOURCE_ATOM_LOADER:
         atom_loader_list.insert((resource_type *)data, NULL);
         return;

      default:
         frame_manager::register_resource_object(type, data);
         return;
   }
   
}


/* *************************************************************
************************************************************* */
void *game_manager::find_resource_object(int type, char *id, char *alias) {

   resource_type *data;
   
   switch (type) {

      case RESOURCE_SPHERE:
         for (data=(resource_type *)sphere_list.head; data; data=(resource_type *)data->next)
            if (!strcmp(alias, data->altname.string))
               return data;

         return NULL;

      // shouldnt be used this way...
      case RESOURCE_EQUIP_LOADER:
      case RESOURCE_ATOM_LOADER:
         return NULL;
	 
      default:
         return frame_manager::find_resource_object(type, id, alias);
   }
   
}


/* *******************************************************************
******************************************************************* */
void *game_manager::get_resource_object(int type) {

   switch(type) {
      case RESOURCE_SPHERE:
         return &sphere_list;
	 
      case RESOURCE_EQUIP_LOADER:
         return &equip_loader_list;
	 
      case RESOURCE_ATOM_LOADER:
         return &atom_loader_list;
	 
      default:
         return frame_manager::get_resource_object(type);
   }
   
}


/* *************************************************************
************************************************************* */
void game_manager::update(float current_time) {

   resource_type *dtr;

   frame_manager::update(current_time);

   if (!DYNAMIC_LOADER)
      return;

   global_statistic_sphere_count = 0;

   for (dtr=(resource_type *)sphere_list.head; dtr; dtr=(resource_type *)dtr->next)
      dtr->update(current_time);
}


/* *************************************************************
************************************************************* */
texbase *game_manager::alloc_texture(sfile *sinfile, dbl_llist_manager *handler, image_coder **loader, int flag256) {

   image_coder *ptr;

   if (!handler->head) {
      *loader = NULL;
      return NULL;
   }

   if (query_video(sinfile)) {
      *loader = NULL;
      return new texvid;
   }

   ptr = (image_coder *)((basic_loader *)handler->head)->find_loader(sinfile);

   if (!ptr) {
      *loader = NULL;
      return NULL;
   }

   *loader = ptr;

   if (RENDER_MODE == RENDERER_OPENGL) {
      if (flag256 && ptr->query_256())
         return new gl_texture256;

      return new gl_texture;
   }

   return frame_manager::alloc_texture(sinfile, handler, loader, flag256);
}

