

#include <stdlib.h>

#include "gamegine.h"


/* **************************************************
************************************************** */
gamegod_type::gamegod_type(engine *proc) : teacher(proc) {

   soundmanager = NULL;
   userinput    = NULL;
   gfx          = NULL;
   boss         = NULL;
   win          = NULL;

   teacher.state.state_flags &= ~STATE_MASK_TREE;
   teacher.state.state_flags |= STATE_FLAG_TALL;
}


/* **************************************************
************************************************** */
void gamegod_type::init() {

   if (userinput && !userinput->read_commands(FILENAME_CURRENT_COMMANDS) && !userinput->read_commands(FILENAME_DEFAULT_COMMANDS)) {
      pprintf("Error: Cannot access keyboard configuration... Aborting...\n");
      exit(0);
   }

}


/* **************************************************
************************************************** */
void gamegod_type::reset() {

   timer.init();

   if (soundmanager)
      soundmanager->reset();

   if (userinput) {
      userinput->flush_event_queue();
      userinput->flag_off(~FLAG_IO_MOUSE_RECENTER);
   }

   // setup font manager;
   font_manager.dest();

   if (FILENAME_FONT.string[0])
      set_font(FILENAME_FONT.string, FONTTYPE);

   animation_manager.dest();
}


/* **************************************************
************************************************** */
void gamegod_type::dest() {

   if (soundmanager) {
      soundmanager->dest();
      delete soundmanager;
      soundmanager = NULL;
   }

   if (userinput) {
      delete userinput;
      userinput = NULL;
   }

   if (gfx) {
      gfx->gfxDest();
      delete gfx;
      gfx = NULL;
   }

   font_manager.dest();
   font = NULL;

   animation_manager.dest();
}


/* **************************************************
************************************************** */
int gamegod_type::set_sound_manager(soundman *sm) {

   if (soundmanager)
      return 0;

   soundmanager = sm;
   return 1;
}


/* **************************************************
************************************************** */
int gamegod_type::set_io_manager(user_io *iom) {

   if (userinput)
      return 0;

   userinput = iom;
   return 1;
}


/* **************************************************
************************************************** */
int gamegod_type::set_gfx_manager(base_gfx *gm) {

   if (gfx)
      return 0;

   gfx = gm;
   return 1;
}


/* **************************************************
************************************************** */
int gamegod_type::set_game_manager(game_manager *gm) {

   if (boss)
      return 0;

   boss = gm;
   return 1;
}


/* **************************************************
************************************************** */
int gamegod_type::set_win(VIRTUALwindow *w) {

   if (win)
      return 0;

   win = w;
   return 1;
}


/* **************************************************
************************************************** */
font_type *gamegod_type::set_font(char *filename, int type) {

   font_type *ftr;
   
   for (ftr = (font_type *)font_manager.head; ftr; ftr = (font_type *)ftr->next)
      if (!ftr->fontname.stringcmp(filename)) {
         font = ftr;
         return ftr;
      }

   ftr = gfx->gfxReadFont(filename, type);

   if (ftr) {
      font_manager.append(font = ftr, NULL);
      return ftr;
   }
      
   sprintf(perror_buffer, "Warning: Cannot access font \"%s\"...\n", filename);
   pprintf(perror_buffer);
   return NULL;      
}


/* **************************************************
************************************************** */
void gamegod_type::register_resource_loader(int type, void *ob) {

   loader_list_type *ptr;

   resource_loader_manager.append(ptr = new loader_list_type, NULL);
   ptr->ob = ob;
   ptr->type = type;
}

