

#include <stdlib.h>
#include <string.h>

#include "gamegine.h"
#include "pstring.h"


/* *************************************************************
************************************************************* */
int gameatom::query_whatwasi(int type) {

   return (gameatom::query_whatami() == type) ? 1 : atom::query_whatwasi(type);
}


/* *************************************************************
    1) origin   (translate)
    2) quat     (rotate around origin)
    3) init_mx  (translate/rotate offset from parent)
    4) scale    (scale all)
    5) spline   (translate - movement)
    6) xmx      (attach to parent)
************************************************************* */
void gameatom::calc_initmx(vector4f *in, vector4f *out) {

   vector4f r[4], s[4];
   vector4f v;

   if (!(flags & QUARK_FLAG_RECALC)) {
      matmatmulto(in, previous_local_motion, out);
      return;
   }
      
   // move to origin/pivot point
   motion.calc_localquat(s, complex->timer.speedscale, 1);

   v[0] = -origin[0];
   v[1] = -origin[1];
   v[2] = -origin[2];
   v[3] = 1.0f;
   
   matvecmulto(s, v);
   s[0][3] = v[0];
   s[1][3] = v[1];
   s[2][3] = v[2];

   // move back...
   out[0][3] += origin[0];
   out[1][3] += origin[1];
   out[2][3] += origin[2];

   // combine w/ global xform
   matmatmulto(initxform, s, r);

   // scale global
   smultarray4(r[0], iscale);
   smultarray4(r[1], iscale);
   smultarray4(r[2], iscale);
   
   // calc spline
   motion.calc_localspline(v, complex->timer.speedscale, 1);

   r[0][3] += v[0];
   r[1][3] += v[1];
   r[2][3] += v[2];

   copymx4x4o(previous_local_motion, r);
   
   if (!motion.query_motion())
      flags &= ~QUARK_FLAG_RECALC;
      
   // concatinate to parent
   matmatmulto(in, r, out);
}


/* *************************************************************
************************************************************* */
int gameatom::parse(FILE *infile, char *token) {

   FILE *infile2;
   
   if (!strcmp(token, TOKEN_FULL_NAME_STR)) {
      get_token(infile, token);
      full_name.stringcpy(token);
      return 1;
   }

   if (!strcmp(token, TOKEN_FILE_STR)) {
      get_token(infile, token);
      filename.stringcpy(token);
      name.stringcpy(token);
      return 1;
   }

   if (!strcmp(token, TOKEN_SIDE_STR)) {
      get_token(infile, token);

      if (!strcmp(token, TOKEN_BLUE_STR)) {
         flags = (flags & ~GAMEFLAG_ALLIANCE_MASK) | GAMEFLAG_BLUE;
         return 1;
      }

      if (!strcmp(token, TOKEN_GREEN_STR)) {
         flags = (flags & ~GAMEFLAG_ALLIANCE_MASK) | GAMEFLAG_GREEN;
         return 1;
      }

      // red
      flags = (flags & ~GAMEFLAG_ALLIANCE_MASK) | GAMEFLAG_RED;
      return 1;
   }

   if (!strcmp(token, TOKEN_TARGET_STR)) {
      flags |= GAMEFLAG_TARGETABLE;
      return 1;
   }

   if (!strcmp(token, TOKEN_TEMPLATE_STR)) {
      get_token(infile, token);
   
      if (!find_file(token, "r", NULL, PLATFORM_SLASH, NULL, &infile2)) {
         sprintf(perror_buffer, "Warning: \"%s\" - invalid atom template - Ignored...\n", token);
         pprintf(perror_buffer);
	 return 1;
      }
      
      while (get_token(infile2, token)) {
         lower_case(token);

         if (!parse(infile2, token)) {
            fclose(infile2);
            return 0;
         }

      }

      fclose(infile2);
      return 1;
   }
   
   return atom::parse(infile, token);
}


/* *************************************************************
************************************************************* */
void gameatom::whereami(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx) {

   if (flags & QUARK_FLAG_ACTIVE)
      quark::whereami(hiearchy_manager, parent, mx);
}


/* *************************************************************
************************************************************* */
void gameatom::update(dbl_llist_manager *hiearchy_manager, quark *parent) {

   if (!(flags & QUARK_FLAG_ACTIVE))
      return;
      
   subeqarray3(perceived_vel, state.center, old_state.center);
   perceived_vel[3] = complex->timer.speedscale;

   quark::update(hiearchy_manager, parent);

   sum_hp(this, parent);
}


/* *************************************************************
************************************************************* */
int gameatom::query_specific_data(unsigned int type, void *data) {

   switch (type) {
      case DATAFLAG_PERCEIVED_VELOCITY:
         *(float **)data = perceived_vel;
         return 1;

      default:
         return quark::query_specific_data(type, data);
   }

}


/* *************************************************************
************************************************************* */
void gameatom::sum_hp(quark *target, quark *parent) {

   linktype *ptr;

   total_hp = 0;

   for (ptr=(linktype *)target->edge.head; ptr; ptr=(linktype *)ptr->next)
      if (ptr->link != parent)
         if (ptr->link->query_category() == CLASS_GAME)
            total_hp += ((gamequark *)ptr->link)->total_hp;
         else
            sum_hp(ptr->link, target);
}


/* *************************************************************
************************************************************* */
int gameatom::apply_damage(gamequark *child, unsigned int properties, int *damage, float *pos, vector4f *mx) {

   return ((gamequark *)child)->apply_damage(properties, damage, pos, mx);
}


/* *************************************************************
************************************************************* */
basic_event *gameatom::read_event(FILE *infile, char *token, int frame_offset) {

   eventtype *ptr;
   basic_event *qtr;

   ptr = new eventtype;

   get_token(infile, token);
   ptr->timer = (float)(atof(token) + frame_offset);

   get_token(infile, token);
   get_token(infile, token);
   ptr->timefactor = (float)atof(token);

   get_token(infile, token);
   get_token(infile, token);
   ptr->efilename.stringcpy(token);

   for (qtr = (basic_event *)event_manager.head; qtr && qtr->event < ptr->event; qtr = (basic_event *)qtr->next);
   
   if (qtr)
      event_manager.insert(ptr, qtr);
   else
      event_manager.append(ptr, NULL);
   
   return ptr;
}


/* *************************************************************
************************************************************* */
void gameatom::new_action(int frameno, dbl_llist_manager *hiearchy_manager) {

   basic_event *ptr;                            // event pointer
   
   for (ptr=(basic_event *)event_manager.head; ptr; ptr = (basic_event *)ptr->next)
      ptr->timer -= complex->timer.speedscale;
      
   for (ptr=(basic_event *)event_manager.head; ptr && ptr->timer <= 0; ptr = (basic_event *)event_manager.head) {
      ptr->evaluate(frameno, this, hiearchy_manager);
      event_manager.remove(ptr);
      delete ptr;
   }

}
