

#include <string.h>

#include "gamegine.h"


/* *************************************************************
************************************************************* */
void fx_type::preprocess(void *data) {

   gamequark::preprocess(data);
}


/* *************************************************************
************************************************************* */
fx_launcher::~fx_launcher() {

   linktype *ptr;

   for (ptr = (linktype *)armoury.head; ptr; ptr = (linktype *)ptr->next)
      delete ptr->link;
}


/* *************************************************************
************************************************************* */
void fx_launcher::preprocess(void *data) {

   reuse(issue((gameatom *)data));
}


/* *************************************************************
************************************************************* */
linktype *fx_launcher::issue(gameatom *parent) {

   linktype *fx;
   geneological_type ani_param;

   if (armoury.head) {
      armoury.remove(fx = (linktype *)armoury.head);
      return fx;
   }

   fx = new linktype;
   fx->link = launch();
   ani_param.tree = NULL; // "parent" == fxmanager -> no "atom_list_type"
   ani_param.parent = NULL;
   fx->link->preprocess(&ani_param);
   return fx;
}


/* *************************************************************
************************************************************* */
void fx_launcher::reuse(linktype *item) {

   ((fx_type *)item->link)->dest();
   armoury.insert(item, NULL);
}


/* *************************************************************
************************************************************* */
int fx_type::query_whatwasi(int type) {

   return (fx_type::query_whatami() == type) ? 1 : gamequark::query_whatwasi(type);
}


/* *************************************************************
************************************************************* */
int fxmanager::query_whatwasi(int type) {

   return (fxmanager::query_whatami() == type) ? 1 : gameatom::query_whatwasi(type);
}


/* *************************************************************
************************************************************* */
fx_type *fxmanager::issue(int isbn) {

   fx_launcher *ptr;
   linktype *fx;

   for (ptr=(fx_launcher *)launcher.head; ptr; ptr=(fx_launcher *)ptr->next)
      if (ptr->query_whatami() == isbn) {
         fx = ptr->issue(this);

         if (fx) {
            launch(fx);
            return (fx_type *)fx->link;
         }

         return NULL;
      }

   return NULL;
}


/* *************************************************************
************************************************************* */
unsigned int fxmanager::identify(char *name) {

   fx_launcher *ptr;
   
   for (ptr=(fx_launcher *)launcher.head; ptr; ptr=(fx_launcher *)ptr->next)
      if (!strcmp(ptr->query_name(), name))
         return ptr->query_whatami();

   return 0;
}


/* *************************************************************
************************************************************* */
void fxmanager::reuse(linktype *item) {

   fx_launcher *ptr;
   int qwhatami;

   qwhatami = ((fx_type *)item->link)->query_whatami();

   for (ptr=(fx_launcher *)launcher.head; ptr; ptr=(fx_launcher *)ptr->next)
      if (ptr->query_whatami() == qwhatami) {
         ptr->reuse(item);
         return;
      }

}


/* *************************************************************
************************************************************* */
void fxmanager::update(dbl_llist_manager *hiearchy_manager, quark *parent) {

   linktype *ptr, *qtr;

   gameatom::update(hiearchy_manager, parent);

   for (ptr=(linktype *)edge.head; ptr; ptr = qtr) {
      qtr = (linktype *)ptr->next;

      if (!(ptr->link->flags & QUARK_FLAG_ACTIVE)) {
         edge.remove(ptr);
         reuse(ptr);
      }

   }

}


/* *************************************************************
************************************************************* */
void fxmanager::launch(linktype *fx) {

   edge.append(fx, NULL);
   ((fx_type *)fx->link)->init();
}


/* *************************************************************
************************************************************* */
void fxmanager::register_launcher(fx_launcher *node) {

   launcher.insert(node, NULL);
}


/* *************************************************************
************************************************************* */
void fxmanager::dest() {

   fx_launcher *ltr;
   linktype *ptr;

   for (ptr = (linktype *)edge.head; ptr; ptr = (linktype *)ptr->next)
      delete ptr->link;

   edge.dest();

   for (ltr=(fx_launcher *)launcher.head; ltr; ltr=(fx_launcher *)ltr->next) {
      for (ptr = (linktype *)ltr->armoury.head; ptr; ptr = (linktype *)ptr->next)
         delete ptr->link;

      ltr->armoury.dest();
   }

}


/* *************************************************************
************************************************************* */
void fxmanager::reset() {

   fx_launcher *ptr;

   dest();

   for (ptr=(fx_launcher *)launcher.head; ptr; ptr=(fx_launcher *)ptr->next)
      ptr->preprocess(this);
}

