

#include <string.h>

#include "follow.h"
#include "pstring.h"


/* *************************************************************
************************************************************* */
int follow::query_whatwasi(int type) {

   return (follow::query_whatami() == type) ? 1 : gameatom::query_whatwasi(type);
}


/* ********************************************************
   update data with new event
******************************************************** */
int follow::parse(FILE *infile, char *token) {

   if (!strcmp(token, TOKEN_FOLLOW_STR)) {       // change parent of a child
      get_token(infile, token);
      actor_name.stringcpy(token);
      get_token(infile, token);
      target_name.stringcpy(token);

      lower_case(token);

      if (!strcmp(token, TOKEN_NULL_STR))
         target_name.stringcpy((char *)NULL);

      target = NULL;

      return 1;
   }

   if (!strcmp(token, TOKEN_NOFOLLOW_STR)) {       // change parent of a child
      target = NULL;
      actor_name.stringcpy((char *)NULL);
      target_name.stringcpy((char *)NULL);
      return 1;
   }

   return gameatom::parse(infile, token);
}


/* *************************************************************
************************************************************* */
void follow::whereami(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx) {

   linktype *ptr;
   atom_list_type *atr;

   if (flags & QUARK_FLAG_ACTIVE) {
      if (!target && actor_name.string[0]) {

         for (atr = (atom_list_type *)hiearchy_manager->head; atr && atr->htree->name.stringcmp(&actor_name); atr = (atom_list_type *)atr->next);

         if (atr)
            if (!target_name.string[0])
               target = atr->htree;
            else
               target = atr->htree->find(NULL, target_name.string);
      }

      if (target) {
         copymx4x4o(state.node, mx);
         state.node[0][3] = target->old_state.node[0][3];
         state.node[1][3] = target->old_state.node[1][3];
         state.node[2][3] = target->old_state.node[2][3];
         init_mx(initxform)
         initxform[0][3] = mx[0][3] - state.node[0][3];
         initxform[1][3] = mx[1][3] - state.node[1][3];
         initxform[2][3] = mx[2][3] - state.node[2][3];
      }

      else
         matmatmulto(mx, initxform, state.node);
   }

   else
      matmatmulto(mx, initxform, state.node);

   for (ptr=(linktype *)edge.head; ptr; ptr=(linktype *)ptr->next)  
      if (ptr->link != parent)                          
         ptr->link->whereami(hiearchy_manager, this, state.node);

   matmatmulto(state.node, localmx, state.xmx);
   
   state.center[0] = state.xmx[0][3];
   state.center[1] = state.xmx[1][3];
   state.center[2] = state.xmx[2][3];
}


/* *************************************************************
************************************************************* */
int subfollow::query_whatwasi(int type) {

   if (subfollow::query_whatami() == type)
      return 1;

   return gamequark::query_whatwasi(type);
}


/* ********************************************************
   update data with new event
******************************************************** */
int subfollow::parse(FILE *infile, char *token) {

   if (!strcmp(token, TOKEN_FOLLOW_STR)) {       // change parent of a child
      get_token(infile, token);
      actor_name.stringcpy(token);
      get_token(infile, token);
      target_name.stringcpy(token);

      lower_case(token);

      if (!strcmp(token, TOKEN_NULL_STR))
         target_name.stringcpy((char *)NULL);

      target = NULL;

      return 1;
   }

   if (!strcmp(token, TOKEN_NOFOLLOW_STR)) {       // change parent of a child
      target = NULL;
      actor_name.stringcpy((char *)NULL);
      target_name.stringcpy((char *)NULL);
      return 1;
   }

   return gamequark::parse(infile, token);
}


/* *************************************************************
************************************************************* */
void subfollow::whereami(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx) {

   linktype *ptr;
   atom_list_type *atr;

   if (flags & QUARK_FLAG_ACTIVE) {
      if (!target && actor_name.string[0]) {

         for (atr = (atom_list_type *)hiearchy_manager->head; atr && atr->htree->name.stringcmp(&actor_name); atr = (atom_list_type *)atr->next);

         if (atr)
            if (!target_name.string[0])
               target = atr->htree;
            else
               target = atr->htree->find(NULL, target_name.string);
      }

      if (target) {
         copymx4x4o(state.node, mx);
         state.node[0][3] = target->old_state.node[0][3];
         state.node[1][3] = target->old_state.node[1][3];
         state.node[2][3] = target->old_state.node[2][3];
         init_mx(initxform)
         initxform[0][3] = mx[0][3] - state.node[0][3];
         initxform[1][3] = mx[1][3] - state.node[1][3];
         initxform[2][3] = mx[2][3] - state.node[2][3];
      }

      else
         matmatmulto(mx, initxform, state.node);
   }

   else
      matmatmulto(mx, initxform, state.node);

   for (ptr=(linktype *)edge.head; ptr; ptr=(linktype *)ptr->next)
      if (ptr->link != parent)                        
         ptr->link->whereami(hiearchy_manager, this, state.node);

   matmatmulto(state.node, localmx, state.xmx);

   state.center[0] = state.xmx[0][3];
   state.center[1] = state.xmx[1][3];
   state.center[2] = state.xmx[2][3];
}

