

#include <stdlib.h>
#include <string.h>

#include "anineutr.h"
#include "flat.h"
#include "gamegine.h"
#include "pstring.h"


/* *************************************************************
************************************************************* */
antiflat::antiflat() {

   ob = complex->gfx->gfxAllocRenderObject(OBJECT_FLAT);

   ob->id = object_counter;
   object_counter++;

   duration = 1.0f;
}


/* *************************************************************
************************************************************* */
int antiflat::query_whatwasi(int type) {

   return (antiflat::query_whatami() == type) ? 1 : gamequark::query_whatwasi(type);
}


/* *************************************************************
************************************************************* */
int antiflat::parse(FILE *infile, char *token) {

   if (!strcmp(token, TOKEN_DURATION_STR)) {
      get_token(infile, token);
      duration = (float)atof(token);
      return 1;
   }

   return gamequark::parse(infile, token);
}


/* *************************************************************
************************************************************* */
void antiflat::begin(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx) {

   complex->gfx->gfxFlatIncrementTime((polygon *)ob, complex->timer.speedscale/duration);
   quark::begin(hiearchy_manager, parent, mx);
}


/* *************************************************************
************************************************************* */
void antiflat::whereami(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx) {

   complex->gfx->gfxFlatIncrementTime((polygon *)ob, complex->timer.speedscale/duration);
   quark::whereami(hiearchy_manager, parent, mx);
}


/* *************************************************************
************************************************************* */
antifxflat::antifxflat() {

   delete ob;
   
   ob = complex->gfx->gfxAllocRenderObject(OBJECT_FXFLAT);

   ob->id = object_counter;
   object_counter++;
}


/* *************************************************************
************************************************************* */
int flat::query_whatwasi(int type) {

   return (flat::query_whatami() == type) ? 1 : polygon::query_whatwasi(type);
}


/* *************************************************************
************************************************************* */
void flat::preprocess(void *data) {

   string_type buffer;

   last_frame = 0;

   buffer.stringcpy(&colorname);
   colorname.stringcpy(FILENAME_PREILM);
   colorname.stringcat(&buffer);

   if (mctype.query_master() > CONSTANT)
      mctype.set_master(CONSTANT);

   // note: bypass polygon::preprocess() - intentional
   pc::preprocess(data);

   smultarray3(rotate[0], size);
   smultarray3(rotate[1], size);
   smultarray3(rotate[2], size);

   rotate[0][3] += center[0];
   rotate[1][3] += center[1];
   rotate[2][3] += center[2];

   if (!((frame_manager *)global_resource_manager)->query_render())
      return;

   if (colorname.string[0])
      lob = (shadelist *)((frame_manager *)global_resource_manager)->read_ilm(colorname.string, 1);

   dob = build_flat_data();

   read_tex(texname2.string);
}


/* *************************************************************
************************************************************* */
int flat::read_tex(char *filename) {

   texbase *tmap;
   vector2f uv[4];
   
   tob = (texpolygon *)global_resource_manager->find_resource_object(RESOURCE_UVCOORD, filename, filename);
   if (tob)
      return 1;
      
   tmap = (texbase *)((frame_manager *)global_resource_manager)->read_tex(filename);

   tob = new texpolygon;
   tob->altname.stringcpy(filename);
   tob->dataname.stringcpy(DEFAULT_FLAT_NAME);

   global_resource_manager->register_resource_object(RESOURCE_UVCOORD, tob);

   tob->setup(1);

   if (tmap) {
      uv[0][0] = 0;
      uv[0][1] = 0;
      uv[1][0] = 0;
      uv[1][1] = 1.0f;
      uv[2][0] = 1.0f;
      uv[2][1] = 1.0f;
      uv[3][0] = 1.0f;
      uv[3][1] = 0;

      tob->direct2Dmap(0, uv, tmap, 4, 0);
   }

   else {
      sprintf(perror_buffer, "Warning: flat map \"%s\" not found...\n", filename);
      pprintf(perror_buffer);
   }

   return 1;
}


/* *************************************************************
************************************************************* */
void flat::transform(eye *parm) {

   vector4f work;
   float scalex, scaley;
   int i;
   float *v;

   if (mcinfo.info & CIBITMAP) {
      init_mx(world);

      scalex = (float)sqrt(rotate[0][0]*rotate[0][0] + rotate[1][0]*rotate[1][0] + rotate[2][0]*rotate[2][0]);
      scaley = (float)sqrt(rotate[0][1]*rotate[0][1] + rotate[1][1]*rotate[1][1] + rotate[2][1]*rotate[2][1]);

      work[0] = rotate[0][3];
      work[1] = rotate[1][3];
      work[2] = rotate[2][3];

      matvecmulto(parm->transform, work);

      world[0][3] = work[0];
      world[1][3] = work[1];
      world[2][3] = work[2];

      // special case inverse
//      init_mx(iworld);
//      iworld[0][3] = -work[0];
//      iworld[1][3] = -work[1];
//      iworld[2][3] = -work[2];

      // xform the verticies
      for (i=0, v=(float *)pot->vlist; i<ob->countvertex; i++, v+=4) {
         v[0] = v[0]*scalex + work[0];
         v[1] = v[1]*scaley + work[1];
         v[2] += work[2];
      }

      ob->calc_normal();
      polyflag |= POLYFLAG_BACKFACE_CULL | POLYFLAG_TRANSFORM;
      return;
   }
   
   matmatmulto(parm->transform, rotate, world);

//   inversemx(world, iworld);

   // xform the verticies
   for (i=0, v=(float *)pot->vlist; i<ob->countvertex; i++, v+=4)
      matvecmulto(world, v);
	 
   ob->calc_normal();
   polyflag |= POLYFLAG_BACKFACE_CULL | POLYFLAG_TRANSFORM;
}


/* **************************************************
************************************************** */
void flat::prepare_edge(engine *proc, int face, pointtype *start, pointtype *end, int starty, int endy, int texture_flag) {

   float    deltay, deltaz;
   edgetype **btr;
   edgetype *ptr, *qtr;

   deltay = ((gengine *)proc)->ybuff[endy-starty] * 65536.0f;

   proc->countedge++;

   ptr = (edgetype *)proc->control->pop(MM_EDGE);

   ptr->starty = starty;
   ptr->endy = endy;

   ptr->start.fxpoint[0] = ((int)(start->point[0]*65536.0f)) + 0x8000;
   ptr->fxdx = (int)((end->point[0] - start->point[0]) * deltay);

   for (btr=&et[face], qtr=et[face]; qtr && starty > qtr->starty; btr=(edgetype **)&qtr->next, qtr=(edgetype *)qtr->next);

   ptr->next = qtr;
   *btr = ptr;

   deltaz = start->point[2] * 16777216.0f;
   deltay *= start->point[2] * 256.0f;

   ptr->start.fxuvz[0] = (int)(start->uvz[0]*deltaz);
   ptr->start.fxuvz[1] = (int)(start->uvz[1]*deltaz);
   ptr->start.uvz[2] = start->uvz[2];

   ptr->fxduvz[0] = (int)((end->uvz[0] - start->uvz[0]) * deltay);
   ptr->fxduvz[1] = (int)((end->uvz[1] - start->uvz[1]) * deltay);
}


/* **************************************************
   This function scans polygonal data and puts it in a zbuffer.
************************************************** */
int flat::scan(camera *cparm, light *lmain, engine *proc) {

   if (!current_tex_id)
      return renderflag = 0;
      
   proc->countvertex += ob->countvertex;

   // transform objects
   transform(cparm);

   return renderflag = bound_box(cparm) && polyclet(cparm, lmain, proc->zbuff.maxx, proc->zbuff.maxy, proc);
}


/* **************************************************
************************************************** */
void flat::render(camera *cparm, light *lmain, light *spot, engine *proc) {

   int rendermask = 0;

   if (!(et[0] && (mcinfo.info & CITEXTURE) && current_tex_id))
      return;

   if ((mcinfo.info & CIOVERWRITE) == CIOVERWRITE)
      rendermask |= GAME_NOZCHECK;

   if ((mcinfo.info & CIGHOST) == CIGHOST)
      rendermask |= GAME_NOZSET;

   if ((mcinfo.info & CITRANSPARENT) == CITRANSPARENT)
      rendermask |= GAME_TRANSPARENT;

   if ((mcinfo.info & CIBITMAP) == CIBITMAP)
      rendermask |= GAME_BITMAP;

   switch (rendermask) {

      case 0x00:            // truecolor
         flatr_0x00(cparm, proc);
         return;

      case 0x01:        // truecolor overwrite
         flatr_0x01(cparm, proc);
         return;

      case 0x02:        // truecolor ghost
         flatr_0x02(cparm, proc);
         return;

      case 0x03:        // truecolor overwrite ghost
         flatr_0x03(cparm, proc);
         return;

      case 0x04:        // truecolor transparent
      case 0x06:        // truecolor ghost transparent
         flatr_0x04(cparm, proc);
         return;

      case 0x05:        // truecolor overwrite transparent
      case 0x07:        // truecolor overwrite ghost transparent
         flatr_0x05(cparm, proc);
         return;

      case 0x10:            // truecolor bitmap
         flatbp_0x10(cparm, proc);
         return;

      case 0x11:        // truecolor overwrite bitmap
         flatbp_0x11(cparm, proc);
         return;

      case 0x12:        // truecolor ghost bitmap
         flatbp_0x12(cparm, proc);
         return;

      case 0x13:        // truecolor overwrite ghost bitmap
         flatbp_0x13(cparm, proc);
         return;

      case 0x14:        // truecolor transparent bitmap
      case 0x16:        // truecolor ghost transparent bitmap
         flatbp_0x14(cparm, proc);
         return;

//      case 0x15:        // truecolor overwrite transparent bitmap
//      case 0x17:        // truecolor overwrite ghost transparent bitmap
      default:
         flatbp_0x15(cparm, proc);
         return;
   }
   
}


/* *************************************************************
************************************************************* */
unsigned int flat::update_texture() {

   texbase *tex;

   tob->query_data(0, TEXTURE2D_QUERY_UNIT_TEXTURE, &last_frame, &tex);
   return current_tex_id = (unsigned int)tex;
}


/* *************************************************************
************************************************************* */
int fxflat::query_whatwasi(int type) {

   return (fxflat::query_whatami() == type) ? 1 : flat::query_whatwasi(type);
}


/* *************************************************************
************************************************************* */
void fxflat::preprocess(void *data) {

   string_type buffer;

   last_frame = 0;

   buffer.stringcpy(&colorname);
   colorname.stringcpy(FILENAME_PREILM);
   colorname.stringcat(&buffer);

   if (mctype.query_master() > CONSTANT)
      mctype.set_master(CONSTANT);

   // note: bypass polygon/flat::preprocess() - intentional
   pc::preprocess(data);

   smultarray3(rotate[0], size);
   smultarray3(rotate[1], size);
   smultarray3(rotate[2], size);

   rotate[0][3] += center[0];
   rotate[1][3] += center[1];
   rotate[2][3] += center[2];

   if (!((frame_manager *)global_resource_manager)->query_render())
      return;

   if (colorname.string[0])
      lob = (shadelist *)((frame_manager *)global_resource_manager)->read_ilm(colorname.string, 1);

   dob = build_flat_data();

   tob = new texpolygon;
   tob->altname.stringcpy("");
   tob->dataname.stringcpy(DEFAULT_FLAT_NAME);

   global_resource_manager->register_resource_object(RESOURCE_UVCOORD, tob);

   tob->setup(1);
}


/* *************************************************************
************************************************************* */
void fxflat::set_ob_data(texbase *tmap) {

   vector2f uv[4];

   if (!tmap) {
      pprintf("Warning: fxflat assigned NULL texture...\n");
      return;
   }
   
   uv[0][0] = 0;
   uv[0][1] = 0;
   uv[1][0] = 0;
   uv[1][1] = 1.0f;
   uv[2][0] = 1.0f;
   uv[2][1] = 1.0f;
   uv[3][0] = 1.0f;
   uv[3][1] = 0;

   tob->direct2Dmap(0, uv, tmap, 4, 0);
}


/* *************************************************************
************************************************************* */
polytype *build_flat_data() {

   float *v;
   polytype *dob;
   polygon_object_type *dot;
   
   dob = (polytype *)global_resource_manager->find_resource_object(RESOURCE_OBJECT, DEFAULT_FLAT_NAME, NULL);

   if (dob)
      return dob;

   dob = new polytype;

   dob->dataname.stringcpy(DEFAULT_FLAT_NAME);
   dob->countvertex = 4;
   dob->countobject = 1;
   dob->countedge = 4;

   dob->build(4, 1, 4);

   dot = (polygon_object_type *)dob->query_data();

   v = (float *)dot->vlist;
   v[0] = -0.5f;
   v[1] = -0.5f;
   v[2] = 0.0f;
   v[3] = 1.0f;

   v += 4;
   v[0] = -0.5f;
   v[1] = 0.5f;
   v[2] = 0.0f;
   v[3] = 1.0f;

   v += 4;
   v[0] = 0.5f;
   v[1] = 0.5f;
   v[2] = 0.0f;
   v[3] = 1.0f;

   v += 4;
   v[0] = 0.5f;
   v[1] = -0.5f;
   v[2] = 0.0f;
   v[3] = 1.0f;

   dob->bs_radius = (float)sqrt(0.5);
   dob->bs_center[0] = dob->bs_center[1] = dob->bs_center[2] = 0;
 
   dob->maxpolynum = 4;
   dob->countedge = 4;

   dot->flist[0].polynum = 4;

   dot->flist[0].edgeptr = dot->vindex;

   dot->flist[0].edgeptr[0] = 0;
   dot->flist[0].edgeptr[1] = 1;
   dot->flist[0].edgeptr[2] = 2;
   dot->flist[0].edgeptr[3] = 3;

   dob->calc_normal();
   dob->calc_area();
   dob->calc_vnormal();

   global_resource_manager->register_resource_object(RESOURCE_OBJECT, dob);

   return dob;
}

