

#include <stdlib.h>
#include <string.h>

#include "gamegine.h"
#include "pstring.h"


/* *************************************************************
************************************************************* */
int equipment::query_whatwasi(int type) {

   return equipment::query_whatami() == type;
}


/* *******************************************************************
******************************************************************* */
equipment *equipment_loader::parse(FILE *infile, char *token) {

   equipment *ptr;
   
   if (strcmp(token, query_name()))
      return (next ? ((equipment_loader *)next)->parse(infile, token) : (equipment *)NULL);

   ptr = make_object();
   ptr->name.stringcpy(token);
   ptr->full_name.stringcpy(token);

   get_token(infile, token);

   do {
      if (!get_token(infile, token) || token[0] == '}')
         break;

      lower_case(token);

      if (!ptr->parse(infile, token)) {
         sprintf(perror_buffer, "Error: Invalid data format... Last read token %s... Aborting...\n", token);
         pprintf(perror_buffer);
         fclose(infile);
         exit(0);
      }

   } while (1);

   return ptr;
}


/* *************************************************************
************************************************************* */
int equipment::parse(FILE *infile, char *token) {

   if (!strcmp(token, TOKEN_MAXHP_STR)) {
      get_token(infile, token);
      maxhp  = hp = atoi(token);
      imaxhp = (hp > 1) ? 1.0f/maxhp : 1.0f;

      return 1;
   }

   if (!strcmp(token, TOKEN_NAME_STR)) {
      get_token(infile, token);
      name.stringcpy(token);
      full_name.stringcpy(token);
      return 1;
   }

   if (!strcmp(token, TOKEN_FULL_NAME_STR)) {
      get_token(infile, token);
      full_name.stringcpy(token);
      return 1;
   }

   return 0;
}


/* *************************************************************
************************************************************* */
equipment *equipment::copy(equipment *item) {

   item->name.stringcpy(&name);
   item->full_name.stringcpy(&full_name);
   item->hp = hp;
   item->maxhp = maxhp;
   item->imaxhp = imaxhp;
   return item;
}


/* *************************************************************
   update equipment before movement
************************************************************* */
void equipment::update(dbl_llist_manager *hiearchy_manager) {

}


/* *************************************************************
   update equipment after movement
************************************************************* */
void equipment::update_fx(vector4f *mx) {

}


/* *************************************************************
************************************************************* */
void equipment::display_hud(dbl_llist_manager *hiearchy_manager, gameatom *source, engine *proc, mapul *mapbuffer) {

}


/* *************************************************************
************************************************************* */
void equipment::reset(gameatom *source, object_desc *ob) {

   hp = maxhp;
   ob->maxhp += maxhp;
   gear = ob;
}


/* *************************************************************
************************************************************* */
void equipment::apply_damage(int *damage) {

   if (hp <= *damage) {
      gear->hp -= hp;
      *damage -= hp;
      hp = 0;
      return;
   }

   gear->hp -= *damage;
   hp -= *damage;
   *damage = 0;
}


/* *************************************************************
************************************************************* */
void object_desc::init() {

   hp = maxhp = 0;
   inventory.dest();
   non_functional.dest();
}


/* *************************************************************
   update equipment before movement
************************************************************* */
void object_desc::update(dbl_llist_manager *hiearchy_manager) {

   equipment *ptr;

   // update equipment
   for (ptr=(equipment *)inventory.head; ptr; ptr=(equipment *)ptr->next)
      ptr->update(hiearchy_manager);
}


/* *************************************************************
   update equipment after movement
************************************************************* */
void object_desc::update_fx(vector4f *mx) {

   equipment *ptr;

   for (ptr=(equipment *)inventory.head; ptr; ptr=(equipment *)ptr->next)
      ptr->update_fx(mx);
}


/* *************************************************************
************************************************************* */
void object_desc::display_hud(dbl_llist_manager *hiearchy_manager, gameatom *source, engine *proc, mapul *mapbuffer) {

   equipment *ptr;

   for (ptr=(equipment *)inventory.head; ptr; ptr=(equipment *)ptr->next)
      ptr->display_hud(hiearchy_manager, source, proc, mapbuffer);
}


/* *************************************************************
************************************************************* */
equipment *object_desc::find_specific(int id) {

   equipment *ptr;

   for (ptr=(equipment *)inventory.head; ptr; ptr=(equipment *)ptr->next)
      if (ptr->query_whatami() == id)
         return ptr;

   return NULL;
}


/* *************************************************************
************************************************************* */
equipment *object_desc::find_category(int id) {

   equipment *ptr;

   for (ptr=(equipment *)inventory.head; ptr; ptr=(equipment *)ptr->next)
      if (ptr->query_category() == id)
         return ptr;

   return NULL;
}


/* *************************************************************
************************************************************* */
void object_desc::remove(equipment *item) {

   inventory.remove(item);
   non_functional.append(item, NULL);
}

