

#include "sphrtype.h"
#include "global.h"


/* *************************************************************
************************************************************* */
class point_node_type : public dbl_llist {

   public:
      vector3f pt;
      
      virtual ~point_node_type() {}
};


/* *************************************************************
************************************************************* */
class buildsphere : public basesphere {

   protected:
      point_node_type *split_edge(float *start, float *end, int i, float plane);
      void clip_greater(dbl_llist_manager *point_manager, int i, float plane);
      void clip_lesser(dbl_llist_manager *point_manager, int i, float plane);
      int clip_face(polygon_object_type *pot, face_type *flist, vector3f *clipbox);

   public:
      dbl_llist_manager sman;
      union {
         float length;
         int   index;
      };
      
      virtual ~buildsphere() { }

      void build_subsphere(dbl_llist_manager *subsphere);
      int build_facelist(polygon_object_type *pot, int countobject);
      void cull_subsphere();
};


/* *************************************************************
************************************************************* */
class buildsphere_node : public dbl_llist {

   public:
      buildsphere *node;
      int index;

      buildsphere_node() { node = NULL; }
      virtual ~buildsphere_node() {}
};


/* *************************************************************
   can precalc length of edge...
************************************************************* */
point_node_type *buildsphere::split_edge(float *start, float *end, int i, float plane) {

   point_node_type *ptr;
   vector3f d;
   float factor;

   subeqarray3(d, end, start);

   ptr = new point_node_type;

   factor = (plane-start[i])/d[i];

   ptr->pt[0] = start[0] + factor*d[0];
   ptr->pt[1] = start[1] + factor*d[1];
   ptr->pt[2] = start[2] + factor*d[2];

   return ptr;
}


/* *************************************************************
   based on quakes line clipper
************************************************************* */
void buildsphere::clip_greater(dbl_llist_manager *point_manager, int i, float plane) {

   point_node_type start;
   int flag1, flag2;
   point_node_type *ptr, *qtr;

   ptr = (point_node_type *)point_manager->head;

   copyarray3(start.pt, ptr->pt);

   qtr = (point_node_type *)ptr->next;
   flag1 = ptr->pt[i] > plane;

   while (qtr) {

      flag2 = qtr->pt[i] > plane;

      if (flag1 + flag2 == 1)
         point_manager->append(split_edge(ptr->pt, qtr->pt, i, plane), ptr);

      if (flag1) {
         point_manager->remove(ptr);
         delete ptr;
      }

      ptr = qtr;
      flag1 = flag2;
      qtr = (point_node_type *)qtr->next;
   }

   flag2 = start.pt[i] > plane;

   if (flag1 + flag2 == 1)
      point_manager->append(split_edge(ptr->pt, start.pt, i, plane), ptr);

   if (flag1) {
      point_manager->remove(ptr);
      delete ptr;
   }

}


/* *************************************************************
   based on quakes line clipper
************************************************************* */
void buildsphere::clip_lesser(dbl_llist_manager *point_manager, int i, float plane) {

   point_node_type start;
   int flag1, flag2;
   point_node_type *ptr, *qtr;

   ptr = (point_node_type *)point_manager->head;

   copyarray3(start.pt, ptr->pt);

   qtr = (point_node_type *)ptr->next;
   flag1 = ptr->pt[i] < plane;

   while (qtr) {

      flag2 = qtr->pt[i] < plane;

      if (flag1 + flag2 == 1)
         point_manager->append(split_edge(ptr->pt, qtr->pt, i, plane), ptr);

      if (flag1) {
         point_manager->remove(ptr);
         delete ptr;
      }

      ptr = qtr;
      flag1 = flag2;
      qtr = (point_node_type *)qtr->next;
   }

   flag2 = start.pt[i] < plane;

   if (flag1 + flag2 == 1)
      point_manager->append(split_edge(ptr->pt, start.pt, i, plane), ptr);

   if (flag1) {
      point_manager->remove(ptr);
      delete ptr;
   }

}


/* *************************************************************
************************************************************* */
int buildsphere::clip_face(polygon_object_type *pot, face_type *flist, vector3f *clipbox) {

   int i;
   vector3f extreme[2];
   int *sindex, *eindex;
   point_node_type *ptr;
   dbl_llist_manager point_manager;
   
   sindex=flist->edgeptr;
   eindex=flist->edgeptr+flist->polynum;
      
   // bound polygon box
   copyarray3(extreme[0], pot->vlist[*sindex]);
   copyarray3(extreme[1], extreme[0]);

   for (sindex++; sindex<eindex; sindex++)
      for (i=0; i<3; i++)
         if (extreme[0][i] > pot->vlist[*sindex][i])
            extreme[0][i] = pot->vlist[*sindex][i];
         else if (extreme[1][i] < pot->vlist[*sindex][i])
            extreme[1][i] = pot->vlist[*sindex][i];

   // check if face is completely outside
   if (extreme[0][0] > clipbox[1][0] || extreme[1][0] < clipbox[0][0] ||
       extreme[0][1] > clipbox[1][1] || extreme[1][1] < clipbox[0][1] ||
       extreme[0][2] > clipbox[1][2] || extreme[1][2] < clipbox[0][2])
      return 1;

   // check if face is completely inclosed
   if (extreme[0][0] >= clipbox[0][0] && extreme[1][0] <= clipbox[1][0] &&
       extreme[0][1] >= clipbox[0][1] && extreme[1][1] <= clipbox[1][1] &&
       extreme[0][2] >= clipbox[0][2] && extreme[1][2] <= clipbox[1][2])
      return 0;

   // create list of edges
   sindex=flist->edgeptr;
   eindex=flist->edgeptr+flist->polynum;
      
   for (; sindex<eindex; sindex++) {
      point_manager.append(ptr = new point_node_type, NULL);      
      copyarray3(ptr->pt, pot->vlist[*sindex]);
   }

   for (i=0; i<3; i++) {
      if (extreme[0][i] < clipbox[0][i]) {
         clip_lesser(&point_manager, i, clipbox[0][i]);
         if (point_manager.count < 3)
            return 1;
      }
   
      if (extreme[1][i] > clipbox[1][i]) {
         clip_greater(&point_manager, i, clipbox[1][i]);
         if (point_manager.count < 3)
            return 1;
      }

   }

   return 0;
}


/* *****************************************************************************
***************************************************************************** */
void buildsphere::build_subsphere(dbl_llist_manager *subsphere) {

   float radius2;
   int level2 = level - 1;
   vector3f center2;
   float length2;
   int i, j, k;
   buildsphere *ptr;
   buildsphere_node *str;
   
   sman.dest();

   if (!level)
      return;

   radius2 = radius*0.5f;
   length2 = length*0.5f;
   
   for (i=0, center2[0] = center[0]-length2; i < 2; i++, center2[0] = center[0] + length2)
      for (j=0, center2[1] = center[1]-length2; j < 2; j++, center2[1] = center[1] + length2)
         for (k=0, center2[2] = center[2]-length2; k < 2; k++, center2[2] = center[2] + length2) {

            subsphere[level2].append(ptr = new buildsphere, NULL);

            ptr->radius = radius2;
            ptr->level = level2;
            ptr->length = length2;
	    copyarray3(ptr->center, center2);

            ptr->build_subsphere(subsphere);
	    
	    sman.append(str = new buildsphere_node, NULL);
	    str->node = ptr;
         }
	 
}

      
/* *****************************************************************************
***************************************************************************** */
int buildsphere::build_facelist(polygon_object_type *pot, int countobject) {

   int i;
   vector3f clipbox[2];
   buildsphere_node *ptr;
  
   sman.dest();

   for (i=0; i<3; i++) {
      clipbox[0][i] = (float)(center[i] - length - CORRECT);
      clipbox[1][i] = (float)(center[i] + length + CORRECT);
   }
   
   for (i=0; i < countobject; i++)
      if (pot->flist[i].polynum > 2 && !clip_face(pot, &pot->flist[i], clipbox)) {
         sman.insert(ptr = new buildsphere_node, NULL);
         ptr->index = i;
      }

   return sman.count;
}


/* *****************************************************************************
  // assumes children are spheres not face indicies
***************************************************************************** */
void buildsphere::cull_subsphere() {

   buildsphere_node *ptr, *qtr;
   
   ptr = (buildsphere_node *)sman.head;
   while (ptr) {
      qtr = ptr;
      ptr = (buildsphere_node *)ptr->next;

      if (qtr->node && !qtr->node->sman.head) {
         sman.remove(qtr);
         delete qtr;
      }

   }

}


/* *****************************************************************************
***************************************************************************** */
spheretype *build_quadspheres(polytype *ob, int level) {

   polygon_object_type *pot;
   vector3f min, max;
   int i, j;
   float radius, boxsize;
   dbl_llist_manager *sphere_head;
   buildsphere *ptr, *qtr;
   colsphere *str;
   buildsphere_node *slist;
   spheretype *sob;
   sphere_block *sblock;
   
   if (!level)
      return NULL;

   pot = (polygon_object_type *)ob->query_data();

   // calc mins, maxs, and bounding sphere radius
   // note: initial sphere must encompass a CUBE
   //       actually more spheres/faces if using RECTANGLES
   copyarray3(min, pot->vlist[0]);
   copyarray3(max, pot->vlist[0]);

   for (i=1; i<ob->countvertex; i++)
      for (j=0; j<3; j++)
         if (min[j] > pot->vlist[i][j])
            min[j] = pot->vlist[i][j];
         else if (max[j] < pot->vlist[i][j])
            max[j] = pot->vlist[i][j];

   boxsize = max[0] - min[0];
   for (i=1; i<3; i++) {
      radius = (max[i] - min[i]);
      if (radius > boxsize)
         boxsize = radius;
   }

    // diameter/2 * sqrt(3)
   radius = (float)sqrt(boxsize*boxsize*0.75);

   sphere_head = new dbl_llist_manager[level+1];

   // overall sphere
   sphere_head[level].append(ptr = new buildsphere, NULL);
   
   ptr->radius = radius;
   ptr->level = level;
   ptr->length = boxsize*0.5f;
   ptr->center[0] = (min[0] + max[0]) * 0.5f;
   ptr->center[1] = (min[1] + max[1]) * 0.5f;
   ptr->center[2] = (min[2] + max[2]) * 0.5f;

   // build quad-sphere list
   ptr->build_subsphere(sphere_head);

   // build sphere/face list
   for (ptr = (buildsphere *)sphere_head[0].head; ptr; ptr = (buildsphere *)ptr->next)
      ptr->build_facelist(pot, ob->countobject);

   // remove links to garbage sphere nodes
   for (i=0; i<level+1; i++)
      for (ptr = (buildsphere *)sphere_head[i].head; ptr; ptr = (buildsphere *)ptr->next)
         ptr->cull_subsphere();

   // remove garbage sphere nodes, assign indexes
   for (i=0, j=1; i<level; i++) {
   
      ptr = (buildsphere *)sphere_head[i].head;
      while (ptr) {
         qtr = ptr;
         ptr = (buildsphere *)ptr->next;
         if (qtr->sman.head)
            qtr->index = j++;
         else {
            sphere_head[i].remove(qtr);
            delete qtr;
         }

      }

   }

   // process head node separately   
   qtr = (buildsphere *)sphere_head[level].head;
   if (qtr->sman.head)
      qtr->index = 0;
   else {
      sphere_head[level].remove(qtr);
      delete qtr;
   }

   // output
   sprintf(perror_buffer, "spheres %d | ", j);
   pprintf(perror_buffer);
   
   sob = new spheretype(j);

   for (j=0, ptr = (buildsphere *)sphere_head[0].head; ptr; ptr=(buildsphere *)ptr->next)
      j += ptr->sman.count;

   sprintf(perror_buffer, "faces %d | real faces %d\n", j, ob->countobject);
   pprintf(perror_buffer);

   sblock = (sphere_block *)sob->query_data();
   str = &sblock->slist[0];

   // store outer sphere
   for (ptr=(buildsphere *)sphere_head[level].head; ptr; ptr=(buildsphere *)ptr->next, str++) {
      str->radius = ptr->radius;
      str->level  = ptr->level;
      str->count  = ptr->sman.count;
      copyarray3(str->center, ptr->center);
      str->index  = new int[ptr->sman.count];

      for (j=0, slist = (buildsphere_node *)ptr->sman.head; slist; slist = (buildsphere_node *)slist->next, j++)
         str->index[j] = ((buildsphere *)slist->node)->index;
   }

   // store subspheres
   for (i=0; i<level; i++)
      for (ptr=(buildsphere *)sphere_head[i].head; ptr; ptr=(buildsphere *)ptr->next, str++) {
         str->radius = ptr->radius;
         str->level  = ptr->level;
         str->count  = ptr->sman.count;
         copyarray3(str->center, ptr->center);
         str->index  = new int[ptr->sman.count];

         if (i)
            for (j=0, slist = (buildsphere_node *)ptr->sman.head; slist; slist = (buildsphere_node *)slist->next, j++)
               str->index[j] = ((buildsphere *)slist->node)->index;
         else
            for (j=0, slist = (buildsphere_node *)ptr->sman.head; slist; slist = (buildsphere_node *)slist->next, j++)
               str->index[j] = slist->index;
      }

   delete [] sphere_head;
   return sob;
}















// want to keep this for posterity
#ifdef OLD_SPHERE_BUILD_CODE

/* *****************************************************************************
***************************************************************************** */
int buildsphere::build_facelist(polytype *ob) {

   int i, j;
   int status;
   float dist;
   float radius2 = radius*radius;
   vector3f intersect;
   spherelist *ptr;
   polygon_object_type *pot;

   pot = (polygon_object_type *)ob->query_data();

   sman.dest();

   for (i=0; i < ob->countobject; i++) {

      // plane intersect sphere ???
      dist = dotproduct3(pot->flist[i].normal, center) + pot->flist[i].normal[3];
      if (dist*dist > radius2)
         continue;

      status = 0;

      // check verticies
      for (j=0; j < pot->flist[i].polynum-1; j++) {
         if (query_point_sphere_intersect(pot->vlist[pot->flist[i].edgeptr[j]], center, radius)) {
            status = 1;
            break;
         }

      }

      // check edges
      if (!status)
         for (j=0; j < pot->flist[i].polynum-1; j++)
            if (query_lineseg_sphere_intersect2(radius, center, pot->vlist[pot->flist[i].edgeptr[j]], pot->vlist[pot->flist[i].edgeptr[j+1]])) {
               status = 1;
               break;
            }

      if (!status && query_lineseg_sphere_intersect2(radius, center, pot->vlist[pot->flist[i].edgeptr[j]], pot->vlist[pot->flist[i].edgeptr[0]]))
         status = 1;

      // check to see if polygon surrounds sphere
      if (!status) {
//         t = -planedotcenter / dotproduct3(ftr->normal, ftr->normal);    // note - normal is normalized

         intersect[0] = center[0] - dist * pot->flist[i].normal[0];
         intersect[1] = center[1] - dist * pot->flist[i].normal[1];
         intersect[2] = center[2] - dist * pot->flist[i].normal[2];

         status = query_point_in_cpoly(intersect, pot->flist[i].normal, pot->flist[i].polynum, pot->vlist, pot->flist[i].edgeptr);
      }

      if (status) {
         sman.insert(ptr = new spherelist, NULL);
         ptr->index = i;
      }

   }

   return sman.count;
}


/* *****************************************************************************
***************************************************************************** */
int buildsphere::query_face_intersect(polytype *ob) {

   int i, j;
   float dist;
   float radius2 = radius*radius;
   vector3f intersect;
   polygon_object_type *pot;

   pot = (polygon_object_type *)ob->query_data();

   for (i=0; i < ob->countobject; i++) {

      // plane intersect sphere ???
      dist = dotproduct3(pot->flist[i].normal, center) + pot->flist[i].normal[3];
      if (dist*dist > radius2)
         continue;

      // check verticies
      for (j=0; j < pot->flist[i].polynum-1; j++)
         if (query_point_sphere_intersect(pot->vlist[pot->flist[i].edgeptr[j]], center, radius))
            return 1;

      // check edges
      for (j=0; j < pot->flist[i].polynum-1; j++)
         if (query_lineseg_sphere_intersect2(radius, center, pot->vlist[pot->flist[i].edgeptr[j]], pot->vlist[pot->flist[i].edgeptr[j+1]]))
            return 1;

      if (query_lineseg_sphere_intersect2(radius, center, pot->vlist[pot->flist[i].edgeptr[j]], pot->vlist[pot->flist[i].edgeptr[0]]))
         return 1;

      // check to see if polygon surrounds sphere
      intersect[0] = center[0] - dist * pot->flist[i].normal[0];
      intersect[1] = center[1] - dist * pot->flist[i].normal[1];
      intersect[2] = center[2] - dist * pot->flist[i].normal[2];

      if (query_point_in_cpoly(intersect, pot->flist[i].normal, pot->flist[i].polynum, pot->vlist, pot->flist[i].edgeptr))
         return 1;
   }

   return 0;
}


/* *****************************************************************************
***************************************************************************** */
int buildsphere::build_spherelist(dbl_llist_manager *subsphere) {

   buildsphere *ptr;
   spherelist *qtr;
   float temp;
   vector3f v;

   sman.dest();

   for (ptr=(buildsphere *)subsphere->head; ptr; ptr=(buildsphere *)ptr->next) {
      subeqarray3(v, ptr->center, center);

/*
      temp = radius + ptr->radius;
      temp *= temp;
      multarray3(v,v);
      if (v[0]+v[1]+v[2] > temp)
         continue;
*/
      temp = radius + ptr->radius;
      temp = (temp*temp)/3.0f;
      multarray3(v,v);

      if (v[0] >= temp || v[1] >= temp || v[2] >= temp)
         continue;

      sman.insert(qtr = new spherelist, NULL);
      qtr->node = ptr;
   }

   return sman.count;
}


/* *****************************************************************************
***************************************************************************** */
int buildsphere::mark_children() {

   spherelist *ptr;

   if (!level) {
      marker = 1;
      return 1;
   }

   if (marker)
      return 1;

   for (ptr=(spherelist *)sman.head; ptr; ptr=(spherelist *)ptr->next)
      marker |= ((buildsphere *)ptr->node)->mark_children();

   return marker;
}


/* *****************************************************************************
***************************************************************************** */
spheretype *build_quadspheres(polytype *ob, int level) {

   vector3f min, max;
   vector3f workmin, workmax;
   int i, j;
   float radius, radius2, boxsize;
   float div;
   dbl_llist_manager *sphere_head = NULL;
   buildsphere *ptr, *btr;
   buildsphere head;
   spheretype *sob;
   colsphere *str;
   spherelist *slist;
   polygon_object_type *pot;
   sphere_block *sblock;
   
   if (!level)
      return NULL;

   pot = (polygon_object_type *)ob->query_data();

   // calc mins, maxs, and bounding sphere radius

   copyarray3(min, pot->vlist[0]);
   copyarray3(max, pot->vlist[0]);

   for (i=1; i<ob->countvertex; i++)
      for (j=0; j<3; j++)
         if (min[j] > pot->vlist[i][j])
            min[j] = pot->vlist[i][j];
         else if (max[j] < pot->vlist[i][j])
            max[j] = pot->vlist[i][j];

   boxsize = 0;
   for (i=0; i<3; i++) {
      radius2 = (max[i] - min[i]);
      if (radius2 > boxsize)
         boxsize = radius2;
   }

   radius = (float)sqrt(boxsize*boxsize*0.75); // diameter/2 * sqrt(3)

   // calc radius of spheres at polygon level
   for (i=0, div = 1; i<level; i++, div *= 0.5);

   sphere_head = new dbl_llist_manager[level];

   // build quad-spheres
   for (i=0; i<level; i++, div += div) {
      radius2 = radius * div;

      boxsize = (float)((radius2 + radius2)/sqrt(3.0));

      workmin[0] = (float)(min[0] + boxsize*(0.5-CORRECT));
      workmax[0] = (float)(max[0] + boxsize*(0.5+CORRECT));

      // calculate spheres at polygon level
      for (; workmin[0] < workmax[0]; workmin[0] += boxsize) {

         workmin[1] = (float)(min[1] + boxsize*(0.5-CORRECT));
         workmax[1] = (float)(max[1] + boxsize*(0.5+CORRECT));

         for (; workmin[1] < workmax[1]; workmin[1] += boxsize) {

            workmin[2] = (float)(min[2] + boxsize*(0.5-CORRECT));
            workmax[2] = (float)(max[2] + boxsize*(0.5+CORRECT));

            for (; workmin[2] < workmax[2]; workmin[2] += boxsize) {

               ptr = new buildsphere;
               copyarray3(ptr->center, workmin);
               ptr->radius = (float)(radius2 + CORRECT);
               ptr->level = i;

               if (i)
                  if (ptr->query_face_intersect(ob))
                     j = ptr->build_spherelist(&sphere_head[i-1]);
                  else 
                     j = 0;
               else
                  j = ptr->build_facelist(ob);

               if (j)
                  sphere_head[i].insert(ptr, NULL);
               else
                  delete ptr;
            }

         }

      }

   }

   // build quadtree
   head.radius = radius;
   head.level = level;
   head.center[0] = (min[0] + max[0]) * 0.5f;
   head.center[1] = (min[1] + max[1]) * 0.5f;
   head.center[2] = (min[2] + max[2]) * 0.5f;

   head.build_spherelist(&sphere_head[level-1]);
   head.mark_children();

   for (i=0; i<level; i++) {
      btr = (buildsphere *)sphere_head[i].head;

      while (btr) {
         ptr = btr;
	 btr = (buildsphere *)btr->next;
	 
         if (ptr->marker) {
            j++;
	    continue;
	 }

         sphere_head[i].remove(ptr);
	 delete ptr;
      }

   }

   for (j=1, i=0; i<level; i++)
      for (ptr = (buildsphere *)sphere_head[i].head; ptr; j++, ptr=(buildsphere *)ptr->next)
         ptr->marker = j;

   // output
   sprintf(perror_buffer, "spheres %d | ", j);
   pprintf(perror_buffer);
   
   sob = new spheretype(j);

   for (j=0, ptr = (buildsphere *)sphere_head[0].head; ptr; ptr=(buildsphere *)ptr->next)
      j += ptr->sman.count;

   sprintf(perror_buffer, "faces %d | real faces %d\n", j, ob->countobject);
   pprintf(perror_buffer);

   sblock = (sphere_block *)sob->query_data();

   str = &sblock->slist[0];
   str->radius = head.radius;
   str->level  = head.level;
   str->count  = head.sman.count;
   copyarray3(str->center, head.center);
   str->index  = new int[head.sman.count];

   for (j=0, slist = (spherelist *)head.sman.head; slist; slist = (spherelist *)slist->next, j++)
      str->index[j] = ((buildsphere *)slist->node)->marker;

   str++;

   for (i=0; i<level; i++)
      for (ptr=(buildsphere *)sphere_head[i].head; ptr; ptr=(buildsphere *)ptr->next, str++) {
         str->radius = ptr->radius;
         str->level  = ptr->level;
         str->count  = ptr->sman.count;
         copyarray3(str->center, ptr->center);
         str->index  = new int[ptr->sman.count];

         if (i)
            for (j=0, slist = (spherelist *)ptr->sman.head; slist; slist = (spherelist *)slist->next, j++)
               str->index[j] = ((buildsphere *)slist->node)->marker;
         else
            for (j=0, slist = (spherelist *)ptr->sman.head; slist; slist = (spherelist *)slist->next, j++)
               str->index[j] = slist->index;
      }

   delete [] sphere_head;
   return sob;
}

#endif
