

#include "brain.h"
#include "anineutr.h"
#include "gamegine.h"
#include "boid.h"


#define QUERY_VALID_TARGET(xxx) ((xxx)->htree != source_atom && GATOM_STATUS(xxx) && (((xxx)->htree->old_state.state_flags & STATE_MASK_TREE) == STATE_FLAG_TSPHERE) && ((andmask && ((xxx)->htree->flags & andmask) == andmask) || ((xxx)->htree->flags & ormask))) 

#define QUERY_SOLID_OBJECT(xxx) (((xxx)->flags & QUARK_FLAG_ACTIVE) && (xxx)->query_whatwasi(OBJECT_ANTINEUTRON) && ((antineutron *)(xxx))->colsphere)


/* *****************************************************************************
***************************************************************************** */
void basic_targeting_pathway::init() {

   last.specific = NULL;
   last.specific_parent = NULL;
   last.object   = NULL;
   source_atom   = NULL;
   ormask        = GAMEFLAG_ALLIANCE_MASK;
   andmask       = 0;
   range2        = -1;
}


/* *****************************************************************************
   find "next" target quark within an atom
   note : this doesn't take into account the size/radius of the target...
***************************************************************************** */
int basic_targeting_pathway::find_next(atom_list_type *subtree, quark *target, quark *parent, quark *stop) {

   linktype *ptr;

   if (last.specific == target) {
      last.specific = NULL;
      last.specific_parent = NULL;
      last.object = NULL;
   }

   else if (!last.specific && GQUARK_STATUS(target, (gameatom *)subtree->htree)) {
      last.specific = target;
      last.specific_parent = parent;
      last.object = subtree;
      return 1;
   }

   if (target == stop)
      return 0;

   for (ptr=(linktype *)target->edge.head; ptr; ptr=(linktype *)ptr->next)
      if (ptr->link != parent && find_next(subtree, ptr->link, target, stop))
         return 1;

   return 0;
}


/* *****************************************************************************
   get "next" quark w/ respect to last pick
***************************************************************************** */
void basic_targeting_pathway::get_next_target(dbl_llist_manager *hiearchy_manager, target_type *target) {

   atom_list_type *atr, *etr;
   vector3f v;
   linktype *rtr;
   
   if (!(ormask | andmask)) {
      target->object = last.object = NULL;
      target->specific_parent = last.specific_parent = NULL;
      target->specific = last.specific = NULL;
      return;
   }

   target->object = last.object;
   target->specific_parent = last.specific_parent;
   target->specific = last.specific;

   for (atr=target->object; atr; atr=(atom_list_type *)atr->next)
      if (QUERY_VALID_TARGET(atr))
         if (range2 < 0) {
	    for (rtr = (linktype *)atr->htree->edge.head; rtr; rtr = (linktype *)rtr->next) 
               if (find_next(atr, rtr->link, NULL, NULL)) {
                  target->object = last.object;
                  target->specific_parent = last.specific_parent;
                  target->specific = last.specific;
                  return;
               }

         }

         else {
            subeqarray3(v, source_atom->old_state.center, atr->htree->old_state.center);
            if (dotproduct3(v, v) <= range2)
               for (rtr = (linktype *)atr->htree->edge.head; rtr; rtr = (linktype *)rtr->next) 
                  if (find_next(atr, rtr->link, NULL, NULL)) {
                     target->object = last.object;
                     target->specific_parent = last.specific_parent;
                     target->specific = last.specific;
                     return;
                  }

         }

   etr = (target->object) ? (atom_list_type *)target->object->next : (atom_list_type *)NULL;
   
   for (atr = (atom_list_type *)hiearchy_manager->head; atr!=etr; atr=(atom_list_type *)atr->next)

      if (QUERY_VALID_TARGET(atr))
         if (range2 < 0) {
            for (rtr = (linktype *)atr->htree->edge.head; rtr; rtr = (linktype *)rtr->next) 
               if (find_next(atr, rtr->link, NULL, NULL)) {
                  target->object = last.object;
                  target->specific_parent = last.specific_parent;
                  target->specific = last.specific;
                  return;
               }

         }

         else {
            subeqarray3(v, source_atom->old_state.center, atr->htree->old_state.center);
            if (dotproduct3(v, v) <= range2)
               for (rtr = (linktype *)atr->htree->edge.head; rtr; rtr = (linktype *)rtr->next) 
                  if (find_next(atr, rtr->link, NULL, NULL)) {
                     target->object = last.object;
                     target->specific_parent = last.specific_parent;
                     target->specific = last.specific;
                     return;
                  }

         }

   if (GQUARK_STATUS(target->specific, (gameatom *)target->object->htree)) {
      if (range2 < 0) {
         last.object = target->object;
         last.specific_parent = target->specific_parent;
         last.specific = target->specific;
         return;
      }

      subeqarray3(v, source_atom->old_state.center, target->object->htree->old_state.center);
      if (dotproduct3(v, v) <= range2) {
         last.object = target->object;
         last.specific_parent = target->specific_parent;
         last.specific = target->specific;
         return;
      }

   }

   target->object = last.object = NULL;
   target->specific_parent = last.specific_parent = NULL;
   target->specific = last.specific = NULL;
}


/* *****************************************************************************
   get next atom w/ respect to last pick
***************************************************************************** */
void master_targeting_pathway::get_next_target(dbl_llist_manager *hiearchy_manager, target_type *target) {

   atom_list_type *atr, *etr;
   vector3f v;

   if (!(ormask | andmask)) {
      target->object = last.object = NULL;
      target->specific_parent = last.specific_parent = NULL;
      target->specific = last.specific = NULL;
      return;
   }

   if (last.object) {
      for (atr=(atom_list_type *)last.object->next; atr; atr=(atom_list_type *)atr->next)
         if (QUERY_VALID_TARGET(atr)) {
            if (range2 < 0) {
               target->object = last.object = atr;
               target->specific_parent = last.specific_parent = NULL;
               target->specific = last.specific = NULL;
               return;
            }

            subeqarray3(v, source_atom->old_state.center, atr->htree->old_state.center);
            if (dotproduct3(v, v) <= range2) {
               target->object = last.object = atr;
               target->specific_parent = last.specific_parent = NULL;
               target->specific = last.specific = NULL;
               return;
            }

         }

      etr = (atom_list_type *)last.object->next;
   }

   else 
      etr = NULL;

   for (atr=(atom_list_type *)hiearchy_manager->head; atr!=etr; atr=(atom_list_type *)atr->next)
      if (QUERY_VALID_TARGET(atr)) {
         if (range2 < 0) {
            target->object = last.object = atr;
            target->specific_parent = last.specific_parent = NULL;
            target->specific = last.specific = NULL;
            return;
         }

         subeqarray3(v, source_atom->old_state.center, atr->htree->old_state.center);
         if (dotproduct3(v, v) <= range2) {
            target->object = last.object = atr;
            target->specific_parent = last.specific_parent = NULL;
            target->specific = last.specific = NULL;
            return;
         }

      }

   target->object = last.object = NULL;
   target->specific_parent = last.specific_parent = NULL;
   target->specific = last.specific = NULL;
}


/* *****************************************************************************
   get closest atom
   note : this doesn't take into account the size/radius of the target...
***************************************************************************** */
void master_targeting_pathway::get_nearest_target(dbl_llist_manager *hiearchy_manager, target_type *target) {

   atom_list_type *atr;
   float dist2, temp;
   vector3f v;
   
   if (!(ormask | andmask)) {
      target->object = last.object = NULL;
      target->specific_parent = last.specific_parent = NULL;
      target->specific = last.specific = NULL;
      return;
   }

   last.object = NULL;

   for (atr=(atom_list_type *)hiearchy_manager->head; atr; atr=(atom_list_type *)atr->next)
      if (QUERY_VALID_TARGET(atr)) {
         subeqarray3(v, source_atom->old_state.center, atr->htree->old_state.center);
         temp = dotproduct3(v, v);

         if (!last.object || temp < dist2) {
            dist2 = temp;
            last.object = atr;
         }

      }

   if (last.object && (range2 < 0 || dist2 <= range2)) {
      target->object = last.object;
      target->specific_parent = last.specific_parent = NULL;
      target->specific = last.specific = NULL;
      return;
   }

   target->object = last.object = NULL;
   target->specific_parent = last.specific_parent = NULL;
   target->specific = last.specific = NULL;
}


/* *****************************************************************************
   get atom closest to center of direction
   note : this doesn't take into account the size/radius of the target...
***************************************************************************** */
void master_targeting_pathway::get_center_target(dbl_llist_manager *hiearchy_manager, target_type *target) {

   atom_list_type *atr;
   vector3f dir, v;
   float front, temp;
   float dist;
   
   if (!(ormask | andmask)) {
      target->object = last.object = NULL;
      target->specific_parent = last.specific_parent = NULL;
      target->specific = last.specific = NULL;
      return;
   }

   last.object = NULL;

   dir[0] = source_atom->old_state.xmx[0][2];   
   dir[1] = source_atom->old_state.xmx[1][2];   
   dir[2] = source_atom->old_state.xmx[2][2];   
   normalize3(dir);

   for (atr=(atom_list_type *)hiearchy_manager->head; atr; atr=(atom_list_type *)atr->next)
      if (QUERY_VALID_TARGET(atr)) {
         subeqarray3(v, atr->htree->old_state.center, source_atom->old_state.center); 
         dist = normalize3(v);

         if (range2 < 0 || dist*dist <= range2) {
            temp = dotproduct3(v, dir);
            if (!last.object || temp > front) {
               front = temp;
               last.object = atr;
            }

         }

      }
   
   target->object = last.object;
   target->specific_parent = last.specific_parent = NULL;
   target->specific = last.specific = NULL;
}


/* *****************************************************************************
   get next quark w/in "actor"
***************************************************************************** */
void sub_targeting_pathway::get_next_subtarget(atom_list_type *subtree, target_type *target) {

   linktype *rtr;

   if (last.object != subtree) {
      last.object = subtree;
      last.specific_parent = NULL;
      last.specific = NULL;
   }

   target->object = last.object;
   target->specific_parent = last.specific_parent;
   target->specific = last.specific;

   for (rtr=(linktype *)target->object->htree->edge.head; rtr; rtr = (linktype *)rtr->next)
      if (find_next(target->object, rtr->link, NULL, NULL)) {
         target->object = last.object;
         target->specific_parent = last.specific_parent;
         target->specific = last.specific;
         return;
      }

   for (rtr=(linktype *)target->object->htree->edge.head; rtr; rtr = (linktype *)rtr->next)
      if (find_next(target->object, rtr->link, NULL, target->specific)) {
         target->object = last.object;
         target->specific_parent = last.specific_parent;
         target->specific = last.specific;
         return;
      }

   if (GQUARK_STATUS(target->specific, (gameatom *)target->object)) { 
      last.specific_parent = target->specific_parent;
      last.specific = target->specific;
      return;
   }

   target->object = last.object = NULL;
   target->specific_parent = last.specific_parent = NULL;
   target->specific = last.specific = NULL;
}


/* *****************************************************************************
***************************************************************************** */
int type_targeting_pathway::find_next(atom_list_type *subtree, quark *target, quark *parent, quark *stop) {

   linktype *ptr;

   if (GQUARK_STATUS(target, (gameatom *)subtree->htree) && target->query_whatwasi(type_mask)) {
      last.specific = target;
      last.specific_parent = parent;
      last.object = subtree;
      return 1;
   }

   for (ptr=(linktype *)target->edge.head; ptr; ptr=(linktype *)ptr->next)
      if (ptr->link != parent && find_next(subtree, ptr->link, target, stop))
         return 1;

   return 0;
}


/* *****************************************************************************
***************************************************************************** */
void type_targeting_pathway::get_next_target(dbl_llist_manager *hiearchy_manager, target_type *target) {}


/* *****************************************************************************
***************************************************************************** */
void type_targeting_pathway::get_center_target(dbl_llist_manager *hiearchy_manager, target_type *target) {}


/* *****************************************************************************
***************************************************************************** */
void type_targeting_pathway::get_nearest_target(dbl_llist_manager *hiearchy_manager, target_type *target) {

   atom_list_type *atr;
   vector3f v;
   linktype *rtr;
      
   if (!(ormask | andmask) || type_mask == 0xffffffff) {
      target->object = last.object = NULL;
      target->specific_parent = last.specific_parent = NULL;
      target->specific = last.specific = NULL;
      return;
   }

   for (atr=(atom_list_type *)hiearchy_manager->head; atr; atr=(atom_list_type *)atr->next)
      if (QUERY_VALID_TARGET(atr))
         if (range2 < 0) {
            for (rtr=(linktype *)atr->htree->edge.head; rtr; rtr = (linktype *)rtr->next)
               if (find_next(atr, rtr->link, NULL, NULL)) {
                  target->object = last.object;
                  target->specific_parent = last.specific_parent;
                  target->specific = last.specific;
                  return;
               }

         }

         else {
            subeqarray3(v, source_atom->old_state.center, atr->htree->old_state.center);

            if (dotproduct3(v, v) <= range2) {
               target->object = last.object;
               target->specific_parent = last.specific_parent;
               target->specific = last.specific;
               return;
            }

         }

   target->object = NULL;
   target->specific_parent = NULL;
   target->specific = NULL;
}


/* *****************************************************************************
   Calculates a new orientation matrix to "point" to the new direction
   NOTE: this function assumes curr_dir and target_dir are unit vectors
***************************************************************************** */
void orient_pathway::calc_orientation(float *curr_dir, float *target_dir, float dangular_vel, vector4f *out, int axis_id) {

   vector3f axis;
   float cangle;
   vector4f pos = { 0.0, 0.0, 0.0, 1.0 };

   cangle = dotproduct3(curr_dir, target_dir); ///(magnitude3(curr_dir)*magnitude3(target_dir));

   if (cangle > ICORRECT) {
      init_mx(out);
      return;
   }

   dangular_vel *= complex->timer.speedscale;

   if (cangle < -ICORRECT) {
      init_mx(out);
      
      switch (axis_id) {
         case AXIS_X:
            rotate_mx_x(out, dangular_vel > PI ? PI : dangular_vel);
            return;
    
         case AXIS_Y:
            rotate_mx_y(out, dangular_vel > PI ? PI : dangular_vel);
            return;

//         case AXIS_Z:
         default:
            rotate_mx_z(out, dangular_vel > PI ? PI : dangular_vel);
            return;
      }

      return;
   }

   cangle = (float)acos(cangle);

   xproduct(axis, curr_dir, target_dir);
   normalize3(axis);

   calc_axis_rotate_mx(pos, axis, cangle > dangular_vel ? dangular_vel : cangle, out);
}


/* *****************************************************************************
   Calculates a new cruising speed
***************************************************************************** */
void chase_pathway::calc_velocity(float *dir, float *destdir, float dist2target, float maxspeed, float accel, float *vel, float speed, float *outvel, float *outspeed) {

   float div;
   float ssaccel;
   float t;
   float target_speed;

   if (accel < CORRECT)
      return;
      
   ssaccel = accel*complex->timer.speedscale;

   // if moving away keep old speed
   if (dotproduct3(dir, destdir) < 0) {
      copyarray3(outvel, dir);
      *outspeed = speed;
   }

   else {
      outvel[0] = vel[0]*speed + dir[0]*ssaccel;
      outvel[1] = vel[1]*speed + dir[1]*ssaccel;
      outvel[2] = vel[2]*speed + dir[2]*ssaccel;

      *outspeed = dotproduct3(outvel, outvel);

      if (*outspeed < CORRECT) {
         *outspeed = 0;
         copyarray3(outvel, dir);
         return;
      }

      *outspeed = (float)sqrt(*outspeed);
      div = (float)(1.0/(*outspeed));

      smultarray3(outvel, div);

      if (*outspeed > maxspeed)
         *outspeed = maxspeed;
   }

   t = *outspeed/accel;

   if (*outspeed*t <= dist2target)
      return;

   target_speed = dist2target/t;
   *outspeed = speed - ssaccel;
   
   if (*outspeed < target_speed)
      *outspeed = target_speed;
}


/* *****************************************************************************
   velocity normalized in world coords
***************************************************************************** */
int avoid_pathway::calc_avoid(atom *source, dbl_llist_manager *hiearchy_manager, float *vel, float speed, float dorient, float *course) {

   atom_list_type *atr;
   avoid_type avoid_data;

   if ((source->old_state.state_flags & STATE_MASK_TREE) != STATE_FLAG_TSPHERE || dorient < CORRECT)
      return NO_COLLISION;

   avoid_data.type = NO_COLLISION;
   avoid_data.red_radius = (float)(source->old_state.tree_radius + 4.0);

   if (dorient > CORRECT)
      avoid_data.red_radius += (speed * HALFPI)/dorient;

   avoid_data.yellow_radius = avoid_data.red_radius + avoid_data.red_radius;

   for (atr=(atom_list_type *)hiearchy_manager->head; atr; atr=(atom_list_type *)atr->next)
      if (atr->htree != source)
         calc_alert(source, atr->htree, NULL, vel, &avoid_data);

   switch (avoid_data.type) {

      case NO_COLLISION:
         return NO_COLLISION;

//      case YELLOW_ALERT:
//      case RED_ALERT;
      default:
         plot_evasive_course(source, &avoid_data, vel, course);
         return avoid_data.type;
   }

}


/* *************************************************************
Note: might want to calculate source's speed/movement into calculation / radius
************************************************************* */
void avoid_pathway::calc_alert(quark *source, quark *obstacle, quark *parent, float *vel, avoid_type *avoid_data) {

   linktype *ptr;
   float radius, work, dist2;
   vector3f diff;
   int i, j;

   if ((obstacle->old_state.state_flags & STATE_MASK_TREE) == STATE_FLAG_TNONE)
      return;

   if ((obstacle->old_state.state_flags & STATE_MASK_TREE) == STATE_FLAG_TSPHERE) {
      radius = obstacle->old_state.tree_radius + avoid_data->yellow_radius;

      subeqarray3(diff, obstacle->old_state.tree_center, source->old_state.center);
      dist2 = dotproduct3(diff, diff);

      if (radius*radius < dist2)
         return;

      // if object and on collision course
      if (QUERY_SOLID_OBJECT(obstacle) && line_sphere_intersect(radius, obstacle->old_state.tree_center, source->old_state.center, vel, &work) && work >=0) {

         switch (avoid_data->type) {

            case NO_COLLISION:
               work = obstacle->old_state.bradius + avoid_data->yellow_radius;

               if (dist2 > work*work)
                  break;

               avoid_data->type = YELLOW_ALERT;
               avoid_data->count = 0;
               // fall through

            case YELLOW_ALERT:
               work = obstacle->old_state.bradius + avoid_data->red_radius;

               if (dist2 <= work*work) {
                  avoid_data->type = RED_ALERT;
                  avoid_data->count = 0;
               }

               // fall through
            default:    // case RED_ALERT:

               if (avoid_data->count < MAX_OBSTACLES) {
                  i = avoid_data->count;
                  avoid_data->count++;
               }

               else {
                  radius = avoid_data->target[0].dist;
                  i = 0;

                  for (j=1; j<MAX_OBSTACLES; j++)
                     if (avoid_data->target[j].dist > radius) {
                        radius = avoid_data->target[j].dist;
                        i = j;
                     }

                  work = obstacle->old_state.bradius + radius;

                  if (dist2 > work*work)
                     break;
               }

               work = (float)(obstacle->old_state.bradius*obstacle->old_state.bradius + CORRECT);

               dist2 = (float)((dist2 < work) ? 0 : sqrt(dist2) - obstacle->old_state.bradius);

               avoid_data->target[i].dist = dist2;
               avoid_data->target[i].ob   = obstacle;
               break;
         }

      }

   }

   for (ptr=(linktype *)obstacle->edge.head; ptr; ptr=(linktype *)ptr->next) {
      if (ptr->link == parent)
         continue;

      calc_alert(source, ptr->link, obstacle, vel, avoid_data);
   }

}


/* *****************************************************************************
***************************************************************************** */
void avoid_pathway::plot_evasive_course(quark *source, avoid_type *avoid_data, float *vel, float *course) {

   int i;
   float temp;
   vector3f pos, xaxis;

   // calculate average avoidance position
   copyarray3(pos, avoid_data->target[0].ob->old_state.center);

   for (i=1; i<avoid_data->count; i++)
      addarray3(pos, avoid_data->target[i].ob->old_state.center);

   temp = (float)(1.0/avoid_data->count);

   smultarray3(pos, temp);

   // calculate reverse course
   subeqarray3(course, source->old_state.center, pos);

   // if overlapp, burn rubber
   if (dotproduct3(course, course) < CORRECT) {
      copyarray3(course, vel);
      return;
   }

   pos[0] = source->old_state.xmx[0][1];
   pos[1] = source->old_state.xmx[1][1];
   pos[2] = source->old_state.xmx[2][1];
   normalize3(pos);

   // if directly ahead, pull up (dont need to check behind - shouldnt happen)
   if (dotproduct3(vel, course) < -CORRECT) {
      copyarray3(course, pos);
      return;
   }

   // if directly above/bellow dont turn - go straight (already 90 deg)
   if (fabs(dotproduct3(pos, course)) < CORRECT) {
      course[0] = source->old_state.xmx[0][2];
      course[1] = source->old_state.xmx[1][2];
      course[2] = source->old_state.xmx[2][2];
      normalize3(course);
      return;
   }

   // else pull up :)
   xproduct(xaxis, pos, course);
   normalize3(xaxis);
   xproduct(course, xaxis, pos);

   if (dotproduct3(course, pos) > 0)
      return;

   course[0] = -course[0];
   course[1] = -course[1];
   course[2] = -course[2];
}


/* *************************************************************
   time units in seconds
************************************************************* */
int intercept_pathway::intercept_prediction(float *target_pos, float *target_vel, float *source_pos, float source_speed, float *intercept_pos, float *intercept_time) {

   vector3f v;
   float dist2target, target_speed, anglecos, work, mag;
   float a, b, c;
   float itime;
   
   subeqarray3(v, source_pos, target_pos);
   dist2target = (float)magnitude3(v);

   mag = dotproduct3(target_vel, target_vel);

   if (mag < CORRECT) {
      copyarray3(intercept_pos, target_pos);
      *intercept_time = dist2target/source_speed;
      return 1;
   }

   mag = (float)sqrt(mag);

   // normalize velocity w/ time
   itime = target_vel[3] > CORRECT ? 1.0f/target_vel[3] : 1;
   
   target_speed = mag*itime;

   anglecos = dotproduct3(target_vel, v) / (dist2target * mag);

   a = target_speed * target_speed - source_speed*source_speed;

   if (!a)
      return 0;

   b = -dist2target*target_speed*anglecos;    // -0.5*b
   c = dist2target * dist2target;

   work = b*b - 2*a*c;

   if (work < 0)
      return 0;

   if (a < 0) {
      b = -b;
      a = -a;
   }

   work = (float)sqrt(work);

   if (b < -work)
      return 0;

   c = (b >= 0 && b >= work) ? b - work : b + work;

   *intercept_time = c/a;

   target_speed = *intercept_time * itime;

   intercept_pos[0] = target_pos[0] + target_speed * target_vel[0];
   intercept_pos[1] = target_pos[1] + target_speed * target_vel[1];
   intercept_pos[2] = target_pos[2] + target_speed * target_vel[2];
   return 1;
}


/* *************************************************************
   time units in seconds
************************************************************* */
int intercept_pathway::intercept_prediction(quark *target, float *source_pos, float source_speed, float *intercept_pos, float *intercept_time) {

   float *target_vel;

   // if target isnt moving, return target's position
   if (!target->query_specific_data(DATAFLAG_PERCEIVED_VELOCITY, &target_vel))
      return 0;
 
   return intercept_prediction(target->old_state.center, target_vel, source_pos, source_speed, intercept_pos, intercept_time);
}


/* *************************************************************
************************************************************* */
int movement_pathway::whereami(vector4f *start_state, float angular_velocity, float time, float *target_pos, vector4f out_state) {


//asdf calculate new position and orientation based on ai books algorithm
   return 1;
}


/* *********************************************************************************
********************************************************************************* */
unsigned int calc_enemy(unsigned int alliance) {

   switch (alliance & GAMEFLAG_ALLIANCE_MASK) {

      case GAMEFLAG_BLUE:
         return GAMEFLAG_RED;

      case GAMEFLAG_RED:
         return GAMEFLAG_BLUE;

      // GAMEFLAG_GREEN:
      default:
         return 0;
   }

}


/* *************************************************************
   "ray" is normalized
************************************************************* */
int query_clear_los(quark *source, quark *target, quark *parent, float *pt, float *ray, quark **obstacle, float *pos, float *normal, int level) {

   linktype *ptr;

   if (source == target || (target->old_state.state_flags & STATE_MASK_TREE) == STATE_FLAG_TNONE)
      return 1;

   if ((target->old_state.state_flags & STATE_MASK_TREE) == STATE_FLAG_TSPHERE && !query_line_sphere_intersect(target->old_state.tree_radius, target->old_state.tree_center, pt, ray))
      return 1;

   if ((target->flags & GAMEFLAG_PHYSICAL) && (target->flags & QUARK_FLAG_ACTIVE) &&
       ((antineutron *)target)->obj_vs_line(pt, ray, pos, normal, level)) {

      *obstacle = target;
      return 0;
   }

   // check w/ subtree
   for (ptr=(linktype *)target->edge.head; ptr; ptr=(linktype *)ptr->next) {
      if (ptr->link == parent)
         continue;

      if (!query_clear_los(source, ptr->link, target, pt, ray, obstacle, pos, normal, level))
         return 0;
   }

   return 1;
}


