

/* *************************************************************
   this file contains all functions to do transforms
************************************************************* */


#include <stdlib.h>
#include <string.h>

#include "pstring.h"
#include "eye.h"
#include "global.h"


/* *************************************************************
************************************************************* */
int eye::query_whatwasi(int type) {

   return (eye::query_whatami() == type) ? 1 : superclass::query_whatwasi(type);
}


/* *************************************************************
   This procedure calculates the Nper matrix
************************************************************* */
void eye::nper() {

//   normalize3(vpn);

   copyarray3(transform[2], vpn);
   transform[2][3] = 0;

   xproduct(transform[0], vup, transform[2]);
   transform[0][3] = 0;

   normalize3(transform[0]);

   xproduct(transform[1], transform[2], transform[0]);
   transform[1][3] = 0;

//   normalize3(transform[1]);

   transform[3][0] = transform[3][1] = transform[3][2] = 0;
   transform[3][3] = 1;

   transform[0][3] = -dotproduct3(location, transform[0]);
   transform[1][3] = -dotproduct3(location, transform[1]);
   transform[2][3] = -dotproduct3(location, transform[2]);

   inversemxrt(transform, Tinverse);            // inverse transformation
}


/* *************************************************************
************************************************************* */
int eye::parse(FILE *infile, char *token) {

   switch(token[0]) {

      case 'l':
         if (!strcmp(token, TOKEN_LOCATION_STR)) {
            get_token(infile, token);
            location[0] = (float)atof(token);
            get_token(infile, token);
            location[1] = (float)atof(token);
            get_token(infile, token);
            location[2] = (float)atof(token);

            return 1;
         }

         break;

      case 'u':
         if (!strcmp(token, TOKEN_UP_STR)) {
            get_token(infile, token);
            vup[0] = (float)atof(token);
            get_token(infile, token);
            vup[1] = (float)atof(token);
            get_token(infile, token);
            vup[2] = (float)atof(token);

            return 1;
         }

         break;

      default:
         break;
   }

   return frameclass::parse(infile, token);
}


/* *************************************************************
************************************************************* */
void eye::calc_clip_plane() {

   vector3f b[4];
   vector3f v;

   // front plane
   frustum[FRUSTUM_FRONT][0] = -transform[2][0];
   frustum[FRUSTUM_FRONT][1] = -transform[2][1];
   frustum[FRUSTUM_FRONT][2] = -transform[2][2];

   v[0] = location[0] - front*frustum[FRUSTUM_FRONT][0];
   v[1] = location[1] - front*frustum[FRUSTUM_FRONT][1];
   v[2] = location[2] - front*frustum[FRUSTUM_FRONT][2];

   v[0] = location[0];
   v[1] = location[1];
   v[2] = location[2];

   frustum[FRUSTUM_FRONT][3] = -dotproduct3(frustum[FRUSTUM_FRONT], v);

   // back plane
   
   copyarray3(frustum[FRUSTUM_BACK], transform[2]);

   v[0] = location[0] + back*frustum[FRUSTUM_BACK][0];
   v[1] = location[1] + back*frustum[FRUSTUM_BACK][1];
   v[2] = location[2] + back*frustum[FRUSTUM_BACK][2];

   frustum[FRUSTUM_BACK][3] = -dotproduct3(frustum[FRUSTUM_BACK], v);

   if (query_whatami() == OBJECT_FAR) {

      // top plane
      frustum[FRUSTUM_TOP][0] = -transform[1][0];
      frustum[FRUSTUM_TOP][1] = -transform[1][1];
      frustum[FRUSTUM_TOP][2] = -transform[1][2];

      v[0] =  location[0] - vrc[3]*frustum[FRUSTUM_TOP][0];
      v[1] =  location[1] - vrc[3]*frustum[FRUSTUM_TOP][1];
      v[2] =  location[2] - vrc[3]*frustum[FRUSTUM_TOP][2];

      frustum[FRUSTUM_TOP][3] = -dotproduct3(frustum[FRUSTUM_TOP], v);

      // bottom plane
      copyarray3(frustum[FRUSTUM_BOTTOM], transform[1]);

      v[0] =  location[0] + vrc[2]*frustum[FRUSTUM_BOTTOM][0];
      v[1] =  location[1] + vrc[2]*frustum[FRUSTUM_BOTTOM][1];
      v[2] =  location[2] + vrc[2]*frustum[FRUSTUM_BOTTOM][2];

      frustum[FRUSTUM_BOTTOM][3] = -dotproduct3(frustum[FRUSTUM_BOTTOM], v);

      // left plane
      copyarray3(frustum[FRUSTUM_LEFT], transform[0]);

      v[0] =  location[0] + vrc[0]*frustum[FRUSTUM_LEFT][0];
      v[1] =  location[1] + vrc[0]*frustum[FRUSTUM_LEFT][1];
      v[2] =  location[2] + vrc[0]*frustum[FRUSTUM_LEFT][2];

      frustum[FRUSTUM_LEFT][3] = -dotproduct3(frustum[FRUSTUM_LEFT], v);

      // right plane
      frustum[FRUSTUM_RIGHT][0] = -transform[0][0];
      frustum[FRUSTUM_RIGHT][1] = -transform[0][1];
      frustum[FRUSTUM_RIGHT][2] = -transform[0][2];

      v[0] =  location[0] - vrc[1]*frustum[FRUSTUM_RIGHT][0];
      v[1] =  location[1] - vrc[1]*frustum[FRUSTUM_RIGHT][1];
      v[2] =  location[2] - vrc[1]*frustum[FRUSTUM_RIGHT][2];

      frustum[FRUSTUM_RIGHT][3] = -dotproduct3(frustum[FRUSTUM_RIGHT], v);
      return;
   }

   b[0][0] = vrc[0];
   b[0][1] = vrc[3];
   b[0][2] = -1;
   matvecmultv(Tinverse, b[0]);

   b[1][0] = vrc[1];
   b[1][1] = vrc[3];
   b[1][2] = -1;
   matvecmultv(Tinverse, b[1]);

   b[2][0] = vrc[0];
   b[2][1] = vrc[2];
   b[2][2] = -1;
   matvecmultv(Tinverse, b[2]);

   b[3][0] = vrc[1];
   b[3][1] = vrc[2];
   b[3][2] = -1;
   matvecmultv(Tinverse, b[3]);

   // top plane
   xproduct(frustum[FRUSTUM_TOP], b[0], b[1]);
   normalize3(frustum[FRUSTUM_TOP]);
   frustum[FRUSTUM_TOP][3] = -dotproduct3(frustum[FRUSTUM_TOP], location);

   // bottom plane
   xproduct(frustum[FRUSTUM_BOTTOM], b[3], b[2]);
   normalize3(frustum[FRUSTUM_BOTTOM]);
   frustum[FRUSTUM_BOTTOM][3] = -dotproduct3(frustum[FRUSTUM_BOTTOM], location);

   // left plane
   xproduct(frustum[FRUSTUM_LEFT], b[2], b[0]);
   normalize3(frustum[FRUSTUM_LEFT]);
   frustum[FRUSTUM_LEFT][3] = -dotproduct3(frustum[FRUSTUM_LEFT], location);

   // right plane
   xproduct(frustum[FRUSTUM_RIGHT], b[1], b[3]);
   normalize3(frustum[FRUSTUM_RIGHT]);
   frustum[FRUSTUM_RIGHT][3] = -dotproduct3(frustum[FRUSTUM_RIGHT], location);
}


/* *************************************************************
************************************************************* */
int eye::query_frustum_clip(float radius, float *center, float *dist, unsigned int frustum_flag) {

   float work;

   work = -radius;
   *dist = dotproduct3(frustum[FRUSTUM_FRONT], center) + frustum[FRUSTUM_FRONT][3] + front;

   return ((frustum_flag & FRUSTUM_CLIP_FRONT)  && *dist - front < work) ||
          ((frustum_flag & FRUSTUM_CLIP_BACK)   && dotproduct3(frustum[FRUSTUM_BACK], center)   + frustum[FRUSTUM_BACK][3]   < work) ||
          ((frustum_flag & FRUSTUM_CLIP_TOP)    && dotproduct3(frustum[FRUSTUM_TOP], center)    + frustum[FRUSTUM_TOP][3]    < work) ||
          ((frustum_flag & FRUSTUM_CLIP_BOTTOM) && dotproduct3(frustum[FRUSTUM_BOTTOM], center) + frustum[FRUSTUM_BOTTOM][3] < work) ||
          ((frustum_flag & FRUSTUM_CLIP_LEFT)   && dotproduct3(frustum[FRUSTUM_LEFT], center)   + frustum[FRUSTUM_LEFT][3]   < work) ||
          ((frustum_flag & FRUSTUM_CLIP_RIGHT)  && dotproduct3(frustum[FRUSTUM_RIGHT], center)  + frustum[FRUSTUM_RIGHT][3]  < work);
}


/* *************************************************************
************************************************************* */
void eye::query_frustum(vector4f *v) {

   int i;

   for (i=0; i<6; i++)
      copyarray4(v[i], frustum[i]);
}
