

#include <stdlib.h>
#include <string.h>

#include "wwdigo.h"
#include "pstring.h"


/* *************************************************************
************************************************************* */
int wwdigo::query_whatwasi(int type) {

   return (wwdigo::query_whatami() == type) ? 1 : quark::query_whatwasi(type);
}


/* ********************************************************
******************************************************** */
wwdigo::wwdigo() {

   turn_rate = (float)ICATCHUP;
   catchup = 0;
   upflag = 0;

   old_vx[0] = 1; old_vx[1] = 0; old_vx[2] = 0;
   old_vy[0] = 0; old_vy[1] = 1; old_vy[2] = 0;
   old_vz[0] = 0; old_vz[1] = 0; old_vz[2] = 1;

   old_local_pos[0] = old_local_pos[1] = old_local_pos[2] = 0;
}


/* ********************************************************
   This function reads in the data for this child
******************************************************** */
int wwdigo::parse(FILE *infile, char *token) {

   switch (token[0]) {

      case 'o':

         if (!strcmp(token, TOKEN_ORIENTATION_MX_STR)) {
            get_token(infile, token);
            old_vx[0] = (float)atof(token);
            get_token(infile, token);
            old_vx[1] = (float)atof(token);
            get_token(infile, token);
            old_vx[2] = (float)atof(token);

            get_token(infile, token);
            old_vy[0] = (float)atof(token);
            get_token(infile, token);
            old_vy[1] = (float)atof(token);
            get_token(infile, token);
            old_vy[2] = (float)atof(token);

            get_token(infile, token);
            old_vz[0] = (float)atof(token);
            get_token(infile, token);
            old_vz[1] = (float)atof(token);
            get_token(infile, token);
            old_vz[2] = (float)atof(token);

            return 1;
         }

         break;

      default:
         break;
   }

   return quark::parse(infile, token);
}


/* ********************************************************
******************************************************** */
void wwdigo::preprocess(void *data) {

   normalize3(old_vx);
   normalize3(old_vy);
   normalize3(old_vz);

   quark::preprocess(data);
}


/* *************************************************************
   place object based on local and parent xforms

1) calc new location
2) vpn = new direction = new loc - old loc
3) if new direction about same as old direction, use old vup, vright
4) else calc new vup/vright based upon plane created by new/old direction vectors
5) 2 possible vups/right -> vup, smallest rotation...

*** need to transpose????
************************************************************* */
void wwdigo::calc_orientation(float *new_dir) {

   vector3f new_vz, new_vy, new_vx, t_v;
   float temp, temp2;
   float one = (float)(1 - CORRECT4);

   copyarray3(new_vz, new_dir);
   temp = normalize3(new_vz);
   temp2 = (float)fabs(dotproduct3(new_vz, old_vz));

   if (temp < CORRECT4 || temp2 > 0.9998) {     // if not significant change in direction
      if (catchup > 0 && upflag) {             // rotate toward "normal" orientation
         vector_interp_eval(start_y, dest_y, 3, inter_param, old_vy);
         inter_param[0] -= inter_param[3];
         inter_param[1] += inter_param[3];

         catchup -= 1;

         xproduct(old_vx, old_vy, old_vz);
      }

      return;
   }


   xproduct(new_vx, new_vz, old_vz);         // calc new xaxis
   normalize3(new_vx);

   if (dotproduct3(new_vx, old_vx) < 0) {    // if somehow the xaxis gets inverted, fix it
      new_vx[0] = -new_vx[0];
      new_vx[1] = -new_vx[1];
      new_vx[2] = -new_vx[2];
   }

   xproduct(new_vy, new_vz, new_vx);         // calc new yaxis

   if (fabs(new_vz[1]) < one) {
      if (new_vy[1] >= one)
         catchup = 0;        // no rotate - should not get here
      else if (new_vy[1] <= -one) {
         dest_y[0] = new_vy[0];
         dest_y[1] = -new_vy[1];
         dest_y[2] = new_vy[2];

         catchup = (float)(1.0/turn_rate);
      }

      else {

         if (fabs(new_vx[1]) > one) {   // 90 deg rotation
            if (new_vx[1] > 0) {
               copyarray3(dest_y, new_vx);
            }

            else {
               dest_y[0] = -new_vx[0];
               dest_y[1] = -new_vx[1];
               dest_y[2] = -new_vx[2];
            }

         }

         else {

            t_v[0] = new_vx[0];
            t_v[1] = 0;
            t_v[2] = new_vx[2];

            normalize3(t_v);

            xproduct(dest_y, new_vz, t_v);  // "y" axis that we want to rotate to...
            normalize3(dest_y);
         }

         vector_interp_setup(new_vy, dest_y, 3, turn_rate, inter_param, &temp);

         if (temp > CORRECT4) { // cos between y axis we have and the one we want
            copyarray3(start_y, new_vy);
            catchup = (float)(1.0/turn_rate);
         }

         else
            catchup = 0;
      }

   }

   else
      catchup = 0;

   old_vx[0] = new_vx[0]*iscale;
   old_vx[1] = new_vx[1]*iscale;
   old_vx[2] = new_vx[2]*iscale;

   old_vy[0] = new_vy[0]*iscale;
   old_vy[1] = new_vy[1]*iscale;
   old_vy[2] = new_vy[2]*iscale;

   old_vz[0] = new_vz[0]*iscale;
   old_vz[1] = new_vz[1]*iscale;
   old_vz[2] = new_vz[2]*iscale;
}


/* ********************************************************
******************************************************** */
void wwdigo::begin(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx) {

   linktype *ptr;                 

   init_mx(state.xmx);
   calc_initmx(state.xmx, state.node);

   copyarray3(state.xmx[0], old_vx);
   copyarray3(state.xmx[1], old_vy);
   copyarray3(state.xmx[2], old_vz);

   old_local_pos[0] = state.xmx[3][0] = state.node[0][3];
   old_local_pos[1] = state.xmx[3][1] = state.node[1][3];
   old_local_pos[2] = state.xmx[3][2] = state.node[2][3];

   transpose(state.xmx);
   matmatmulto(mx, state.xmx);

   copymx4x4o(state.node, state.xmx);
   
   for (ptr=(linktype *)edge.head; ptr; ptr=(linktype *)ptr->next)
      if (ptr->link != parent)                   
         ptr->link->begin(hiearchy_manager, this, state.node);

   state.center[0] = state.xmx[0][3];
   state.center[1] = state.xmx[1][3];
   state.center[2] = state.xmx[2][3];
}


/* ********************************************************
******************************************************** */
void wwdigo::new_action(FILE *infile, float timefactor, char *buffer) {

   char token[MAXSTRLEN];

   if (buffer != (char *)NULL)
      strcpy(token, buffer);
   else {
      get_token(infile, token);
      lower_case(token);
   }

   switch (token[0]) {

      case 'o':

         if (!strcmp(token, TOKEN_ORIENTATION_MX_STR)) {
            get_token(infile, token);
            old_vx[0] = (float)atof(token);
            get_token(infile, token);
            old_vx[1] = (float)atof(token);
            get_token(infile, token);
            old_vx[2] = (float)atof(token);
            normalize3(old_vx);

            get_token(infile, token);
            old_vy[0] = (float)atof(token);
            get_token(infile, token);
            old_vy[1] = (float)atof(token);
            get_token(infile, token);
            old_vy[2] = (float)atof(token);
            normalize3(old_vy);

            get_token(infile, token);
            old_vz[0] = (float)atof(token);
            get_token(infile, token);
            old_vz[1] = (float)atof(token);
            get_token(infile, token);
            old_vz[2] = (float)atof(token);
            return;
         }

         break;

      default:
         break;
   }

   quark::new_action(infile, timefactor, token);
}
