

#include <stdlib.h>
#include <string.h>

#include "photon.h"
#include "pstring.h"


/* *************************************************************
************************************************************* */
int photon::query_whatwasi(int type) {

   return (photon::query_whatami() == type) ? 1 : quark::query_whatwasi(type);
}


/* ********************************************************
******************************************************** */
photon::photon() {

    ob = new far_light;
    ob->id = object_counter;
    object_counter++;

    Ia[0] = Ia[1] = Ia[2] = 0.3f;
    Ip[0] = Ip[1] = Ip[2] = 0.7f;
    vpn[0] = vpn[1] = 0; vpn[2] = 1;
    vup[0] = vup[2] = 0; vup[1] = 1;
    distance2plane = length = width = 1;
    fatt[0] = fatt[1] = fatt[2] = 0.0f;
    fattflag = 0;

    flags &= ~QUARK_FLAG_ACTIVE;
    state.state_flags &= ~STATE_MASK_BOUND;
    state.state_flags |= STATE_FLAG_BALL;
}


/* ********************************************************
   this function reads in camera data
******************************************************** */
int photon::parse(FILE *infile, char *token) {

   switch (token[0]) {

      case '2':
         if (!strcmp(token, TOKEN_2D_TEXTURE_STR)) {
            get_token(infile, token);
            texname.stringcpy(token);
            return 1;
         }

         break;

      case 'a':
         if (!strcmp(token, TOKEN_AMBIENT_STR)) {
            get_token(infile, token);
            Ia[0] = (float)atof(token);
            get_token(infile, token);
            Ia[1] = (float)atof(token);
            get_token(infile, token);
            Ia[2] = (float)atof(token);

            return 1;
         }

         break;

      case 'd':
         if (strlen(token) < 3)
            break;

         switch (token[2]) {
            case 'f':
               if (!strcmp(token, TOKEN_DIFFUSE_STR)) {
                  get_token(infile, token);
                  Ip[0] = (float)atof(token);
                  get_token(infile, token);
                  Ip[1] = (float)atof(token);
                  get_token(infile, token);
                  Ip[2] = (float)atof(token);

                  return 1;
               }

               break;

            case 's':
               if (!strcmp(token, TOKEN_DISTANCE2PLANE_STR)) {
                  get_token(infile, token);
                  distance2plane = (float)atof(token);

                  return 1;
               }

               break;

            case 'r':
               if (!strcmp(token, TOKEN_DIRECTION_STR)) {
                  get_token(infile, token);
                  vpn[0] = (float)-atof(token);
                  get_token(infile, token);
                  vpn[1] = (float)-atof(token);
                  get_token(infile, token);
                  vpn[2] = (float)-atof(token);

                  return 1;
               }

               break;

            default:
               break;
         }

         break;

      case 'f':
         if (!strcmp(token, TOKEN_FATT_STR)) {
            get_token(infile, token);
            fatt[0] = (float)atof(token);
            get_token(infile, token);
            fatt[1] = (float)atof(token);
            get_token(infile, token);
            fatt[2] = (float)atof(token);

            fattflag = 1;

            return 1;
         }

         break;

      case 'l':
         if (!strcmp(token, TOKEN_LENGTH_STR)) {
            get_token(infile, token);
            length = (float)atof(token);

            return 1;
         }

         break;

      case 't':
         if (!strcmp(token, TOKEN_TYPE_STR)) {

            if (ob)
               delete ob;

            get_token(infile, token);
            lower_case(token);

            if (!strcmp(token, TOKEN_BEAM_POINT_STR))
               ob = new beam_point;
            else if (!strcmp(token, TOKEN_BEAM_FAR_STR))
               ob = new beam_far;
            else if (!strcmp(token, TOKEN_POINT_STR))
               ob = new point_light;
            else if (!strcmp(token, TOKEN_FAR_STR))
               ob = new far_light;
            else if (!strcmp(token, TOKEN_SIMPLE_BEAM_POINT_STR))
               ob = new simple_beam_point;
            else if (!strcmp(token, TOKEN_SIMPLE_BEAM_FAR_STR))
               ob = new simple_beam_far;
            else if (!strcmp(token, TOKEN_SIMPLE_POINT_STR))
               ob = new simple_point_light;
            else
               ob = new simple_far_light;

            ob->id = object_counter;
            object_counter++;
            return 1;
         }

         break;

      case 'u':
         if (!strcmp(token, TOKEN_UP_STR)) {
            get_token(infile, token);
            vup[0] = (float)atof(token);
            get_token(infile, token);
            vup[1] = (float)atof(token);
            get_token(infile, token);
            vup[2] = (float)atof(token);

            return 1;
         }

         break;

      case 'w':
         if (!strcmp(token, TOKEN_WIDTH_STR)) {
            get_token(infile, token);
            width = (float)atof(token);

            return 1;
         }

         break;

      default:
         break;
   }

   return quark::parse(infile, token);
}


/* ********************************************************
******************************************************** */
void photon::preprocess(void *data) {

    light *ptr = (light *)ob;
    spotlight *str = (spotlight *)ob;

    copyarray3(ptr->Ia, Ia);
    copyarray3(ptr->Ip, Ip);

    if (fattflag) {
       copyarray3(ptr->fatt, fatt);
       ptr->fattflag = 1;
    }

    if (ptr->query_class() == SPOT_LIGHT) {
        str->distance2plane = distance2plane;
        str->length = length;
        str->width = width;
        str->texname.stringcpy(&texname);
    }

    quark::preprocess(data);
}


/* ********************************************************
   this function calculates the camera position
   and puts data in a list
******************************************************** */
void photon::setup() {

   light *ptr = (light *)ob;

   copyarray3(ptr->vpn, vpn);
   matvecmultv(state.xmx, ptr->vpn);
   normalize3(ptr->vpn);

   if (ptr->query_class() == SPOT_LIGHT) {
      copyarray3(ptr->location, state.center);
      copyarray3(ptr->vup, vup);
      matvecmultv(state.xmx, ptr->vup);
      normalize3(ptr->vup);

      ptr->nper();
   }

   else if (ptr->query_whatami() == OBJECT_POINT)
      copyarray3(ptr->location, state.center);
}

