

#include <stdlib.h>
#include <string.h>

#include "lock.h"
#include "pstring.h"


/* *************************************************************
************************************************************* */
int lock::query_whatwasi(int type) {

   return (lock::query_whatami() == type) ? 1 : wwdigo::query_whatwasi(type);
}


/* *************************************************************
************************************************************* */
lock::lock() {

   init_mx(old_imx);
   target = (quark *)NULL;
   offset[0] = offset[1] = offset[2] = 0;
   offset[3] = 1;
}


/* *************************************************************
************************************************************* */
void lock::calc_orientation(float *new_dir) {

   float pitch, yaw;
   float temp;
   vector4f mx[4];

   pitch = ASIN(new_dir[1]/magnitude3(new_dir));

   temp = new_dir[0]*new_dir[0] + new_dir[2]*new_dir[2];

   yaw = (temp > CORRECT) ? ACOS(new_dir[2]/sqrt(temp)) : 0;

   if (new_dir[0] < 0)
      yaw = -yaw;

   init_mx(mx);

   mx[0][0] = iscale;
   mx[1][1] = iscale;
   mx[2][2] = iscale;

   rotate_mx_x(mx, pitch);
   rotate_mx_y(mx, yaw);

   transpose(mx);
   copyarray3(old_vx, mx[0]);
   copyarray3(old_vy, mx[1]);
   copyarray3(old_vz, mx[2]);
}


/* *************************************************************
************************************************************* */
void lock::begin(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx) {

   wwdigo::begin(hiearchy_manager, parent, mx);

   inversemx(mx, old_imx);
}


/* *************************************************************
************************************************************* */
void lock::whereami(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx) {

   atom_list_type *atr;
   linktype *ptr;
   vector3f new_vz;
   vector4f temp;

   init_mx(state.xmx);
   calc_initmx(state.xmx, state.node);

   if (!target && actor_name.string[0]) {

      for (atr=(atom_list_type *)hiearchy_manager->head; atr && atr->htree->name.stringcmp(&actor_name); atr = (atom_list_type *)atr->next);

      if (atr)
         target = atr->htree->find(NULL, piece.string);
   }

   if (target) {
      copyarray4(temp, target->old_state.center);
      matvecmulto(old_imx, temp);

      new_vz[0] = temp[0] - state.node[0][3] + offset[0];
      new_vz[1] = temp[1] - state.node[1][3] + offset[1];
      new_vz[2] = temp[2] - state.node[2][3] + offset[2];

      calc_orientation(new_vz);
   }

   copyarray3(state.xmx[0], old_vx);
   copyarray3(state.xmx[1], old_vy);
   copyarray3(state.xmx[2], old_vz);
   state.xmx[3][0] = state.node[0][3];
   state.xmx[3][1] = state.node[1][3];
   state.xmx[3][2] = state.node[2][3];
   transpose(state.xmx);

   matmatmulto(mx, state.xmx);
   copymx4x4o(state.node, state.xmx);
   
   for (ptr=(linktype *)edge.head; ptr; ptr=(linktype *)ptr->next)        
      if (ptr->link != parent)                           
         ptr->link->whereami(hiearchy_manager, this, state.node);

   state.center[0] = state.xmx[0][3];
   state.center[1] = state.xmx[1][3];
   state.center[2] = state.xmx[2][3];
   state.center[3] = 1;

   inversemx(mx, old_imx);
}


/* *************************************************************
************************************************************* */
void lock::new_action(FILE *infile, float timefactor, char *buffer) {

   char token[MAXSTRLEN];

   if (buffer != (char *)NULL)
      strcpy(token, buffer);
   else {
      get_token(infile, token);
      lower_case(token);
   }

   switch (token[0]) {

      case 'l':			// target
         if (!strcmp(token, TOKEN_LOCK_STR)) {
            get_token(infile, token);
            actor_name.stringcpy(token);
            get_token(infile, token);
            piece.stringcpy(token);
            target = (quark *)NULL;

            return;
         }

         break;

      case 'o':			// offset

         if (!strcmp(token, TOKEN_OFFSET_STR)) {

            get_token(infile, token);
            offset[0] = (float)atof(token);
            get_token(infile, token);
            offset[1] = (float)atof(token);
            get_token(infile, token);
            offset[2] = (float)atof(token);

            return;
         }

         break;

      case 'u':

         if (!strcmp(token, TOKEN_UNLOCK_STR)) {
            actor_name.stringcpy((char *)NULL);
            piece.stringcpy((char *)NULL);
            target = (quark *)NULL;
            offset[0] = offset[1] = offset[2] = 0;

            return;
         }

         break;

      default:
         break;
   }

   wwdigo::new_action(infile, timefactor, token);
}
