


#include <stdlib.h>

#include "quark.h"
#include "pstring.h"


/* **************************************************
************************************************** */
keyframe::keyframe() {

   status = key = count = auto_flag = 0;
   key_data = NULL;
   frame = 0;
   framesperspline = iframesperspline = 1;
   current[0] = current[1] = current[2] = current[3] = 0;
}


/* **************************************************
************************************************** */
keyframe::~keyframe() {

   if (key_data)
      delete [] key_data;
}


/* **************************************************
************************************************** */
void kinematic::read_spline(FILE *infile, float timefactor) {

   char token[MAXSTRLEN];                     // type of event
   int  i;

   get_token(infile, token);
   pos.count = atoi(token);
   get_token(infile, token);
   pos.catchup = (float)(atof(token) * timefactor);
   get_token(infile, token);
   pos.framesperspline = (float)(atof(token) * timefactor);
   get_token(infile, token);
   pos.auto_flag = atoi(token);

   if (not_zero(pos.catchup)) {
      pos.status = 1;
      copyarray3(pos.old, pos.current);
   }

   else
      pos.status = 0;

   pos.key   = 0;
   pos.frame = 0;

   if (pos.key_data)
      delete [] pos.key_data;

   pos.key_data = new vector4f[pos.count];

   for (i=0; i<pos.count; i++) {
      get_token(infile, token);
      pos.key_data[i][0] = (float)atof(token);
      get_token(infile, token);
      pos.key_data[i][1] = (float)atof(token);
      get_token(infile, token);
      pos.key_data[i][2] = (float)atof(token);
   }

   copyarray3(pos.current, pos.key_data[1]);

   transpose(Q, pos.key_data);
}


/* **************************************************
************************************************** */
void kinematic::read_quaternion(FILE *infile, float timefactor) {

   char token[MAXSTRLEN];                     // type of event
   int  i;
   vector3f temp;
   float theta;

   get_token(infile, token);
   orient.count = atoi(token);
   get_token(infile, token);
   orient.catchup = (float)(atof(token) * timefactor);
   get_token(infile, token);
   orient.framesperspline = (float)(atof(token) * timefactor);
   get_token(infile, token);
   orient.auto_flag = atoi(token);

   if (not_zero(orient.catchup)) {
      orient.status = 1;
      copyarray4(orient.old, orient.current);
   }

   else
      orient.status = 0;

   orient.frame = 0;

   if (orient.key_data)
      delete [] orient.key_data;

   orient.key_data = new vector4f[orient.count+1];

   for (i=0; i<orient.count; i++) {
      get_token(infile, token);
      temp[0] = (float)deg2rad(atof(token));
      get_token(infile, token);
      temp[1] = (float)deg2rad(atof(token));
      get_token(infile, token);
      temp[2] = (float)deg2rad(atof(token));

      euler2quat(temp, orient.key_data[i]);
   }

   copyarray4(orient.current, orient.key_data[0]);

   if (orient.count == 1) {
      orient.count++;
      copyarray4(orient.key_data[1], orient.key_data[0]);
   }

   if (orient.status) {
      orient.key = 0;
      range = orient.catchup;
   }

   else {
      orient.key = 1;
      copyarray4(orient.old, orient.key_data[0]);
      range = orient.framesperspline;
   }

   QUAT_SPECIAL_CASE(inverseflag, theta, delta, orient.old, orient.key_data[orient.key], range);
}


/* ********************************************************
   This procedure creates a orientation mx
******************************************************** */
void kinematic::update_localquat(float deltat) {

   float  t;

   orient.frame += deltat;

   if (orient.frame < range)                    // increment orientation
      return;

   if (orient.key < orient.count-1) {
      copyarray4(orient.old, orient.key_data[orient.key]);
      orient.key++;

      orient.frame -= range;
      range = orient.framesperspline;

      QUAT_SPECIAL_CASE(inverseflag, t, delta, orient.old, orient.key_data[orient.key], range);
      return;
   }

   if (orient.auto_flag) {
      copyarray4(orient.old, orient.key_data[0]);
      orient.key = 1;

      orient.frame -= range;
      range = orient.framesperspline;

      QUAT_SPECIAL_CASE(inverseflag, t, delta, orient.old, orient.key_data[orient.key], range);
      return;
   }

   orient.frame = orient.framesperspline;
}


/* ********************************************************
   This procedure creates a orientation mx

  **** assume framesperspline >= 1
******************************************************** */
void kinematic::calc_localquat(vector4f *mx, float deltat, int liveflag) {

   float  t, it;

   if (!orient.key_data) {
//      calc_quat(mx, orient.current);               // calc rotation
      init_mx(mx);
      return;
   }

   if (liveflag)
      update_localquat(deltat);

   t  = orient.frame*delta[4];
// asdf can precalc orient.framesperspline*delta[4]
   it = orient.framesperspline*delta[4] - t;

   t = SIN(t);
   it = SIN(it);

   if (inverseflag) {
      orient.current[0] = it*delta[0] + t*orient.old[0];
      orient.current[1] = it*delta[1] + t*orient.old[1];
      orient.current[2] = it*delta[2] + t*orient.old[2];
      orient.current[3] = it*delta[3] + t*orient.old[3];
  }

   else {
      orient.current[0] = it*orient.old[0] + t*orient.key_data[orient.key][0];
      orient.current[1] = it*orient.old[1] + t*orient.key_data[orient.key][1];
      orient.current[2] = it*orient.old[2] + t*orient.key_data[orient.key][2];
      orient.current[3] = it*orient.old[3] + t*orient.key_data[orient.key][3];
   }

   calc_quat(mx, orient.current);               // calc rotation

   if (!liveflag)
      update_localquat(deltat);
}


/* ********************************************************
   This function calculates the current xyz DOF

  **** assume framesperspline >= 1
******************************************************** */
void kinematic::update_localsp(float deltat) {

   int i, j;                            // looping var

   pos.frame += deltat;

   if (pos.frame >= pos.framesperspline)      // calc next parameters
      if (pos.key < pos.count-4) {
         pos.frame -= pos.framesperspline;
         pos.key++;

         for (i=0; i<4; i++)
            for (j=0; j<4; j++)
               Q[i][j] = pos.key_data[pos.key+j][i];
      }

      else if (pos.auto_flag) {
         pos.frame -= pos.framesperspline;
         pos.key    = 0;

         for (i=0; i<4; i++)
            for (j=0; j<4; j++)
               Q[i][j] = pos.key_data[j][i];
      }

      else
         pos.frame = pos.framesperspline;

   spline(pos.frame/pos.framesperspline, Q, pos.current, M_CR);
}


/* ********************************************************
   This function calculates the current xyz DOF

  **** assume framesperspline >= 1
******************************************************** */
void kinematic::calc_localsp(float *v, float deltat, int liveflag) {

   if (!pos.key_data) {
      copyarray3(v, pos.current);           // get current pos
      return;
   }
   
   if (liveflag)
      update_localsp(deltat);

   copyarray3(v, pos.current);           // get current pos

   if (!liveflag)
      update_localsp(deltat);
}


/* ********************************************************
   This function calculates the current xyz DOF between
   events
******************************************************** */
int kinematic::update_preparesp(float deltat) {

   pos.frame += deltat;

   if (pos.frame < pos.catchup)
      return 0;

   pos.status = 0;
   pos.frame -= pos.catchup;

   spline(pos.frame/pos.framesperspline, Q, pos.current, M_CR);

   return 1;
}


/* ********************************************************
// calc spline
******************************************************** */
void kinematic::calc_localspline(float *v, float deltat, int liveflag) {

   int    i;                                 // looping var
   float icatchup;

   if (!pos.status) {
      calc_localsp(v, deltat, liveflag);
      return;
   }
   
   if (liveflag && update_preparesp(deltat)) {
      copyarray3(v, pos.current);
      return;
   }
      
   icatchup = pos.frame/pos.catchup;

   for (i=0; i<3; i++)
      v[i] = pos.old[i] + (pos.current[i] - pos.old[i])*icatchup;

   if (!liveflag)
      update_preparesp(deltat);
}
