

#include <stdlib.h>
#include <string.h>

#include "radiant.h"
#include "ion.h"
#include "pstring.h"


/* *************************************************************
************************************************************* */
int ion::query_whatwasi(int type) {

   return (ion::query_whatami() == type) ? 1 : quark::query_whatwasi(type);
}


/* ********************************************************
******************************************************** */
ion::ion() {

    ob = new radiant;

    ob->id = object_counter;
    object_counter++;

    outer_radius = 2;
    inner_radius = 1;
}


/* ********************************************************
******************************************************** */
int ion::parse(FILE *infile, char *token) {

   switch (token[0]) {
      case 'i':
         if (!strcmp(token, TOKEN_INNER_RADIUS_STR)) {
            get_token(infile, token);
            inner_radius = (float)atof(token);
            return 1;
         }

         break;

      case 'o':
         if (!strcmp(token, TOKEN_OUTER_RADIUS_STR)) {
            get_token(infile, token);
            outer_radius = (float)atof(token);
            return 1;
         }

         break;

      default:
         break;
   }

   return quark::parse(infile, token);
}


/* ********************************************************
   this function calculates the camera position
   and puts data in a list
******************************************************** */
void ion::setup() {

   float temp, temp2;
   radiant *ptr = (radiant *)ob;
   vector4f r[4];

   transpose(r, state.xmx);

   temp = dotproduct3(r[0], r[0]);

   temp2 = dotproduct3(r[1], r[1]);
   if (temp2 < temp)
      temp = temp2;

   temp2 = dotproduct3(r[2], r[2]);
   if (temp2 < temp)
      temp = temp2;

   temp = (float)sqrt(temp);

   copyarray3(ptr->center, state.center);
   ptr->inner_circle = temp*inner_radius;
   ptr->radius = temp*outer_radius;
}
