

#include <stdlib.h>
#include <string.h>

#include "electron.h"
#include "pstring.h"


/* *************************************************************
************************************************************* */
int electron::query_whatwasi(int type) {

   return (electron::query_whatami() == type) ? 1 : quark::query_whatwasi(type);
}


/* ********************************************************
******************************************************** */
electron::electron() {

    ob = new camera();
    ob->id = object_counter;
    object_counter++;

    vup[0] = 0;
    vup[1] = 1;
    vup[2] = 0;

    vpn[0] = 0;
    vpn[1] = 0;
    vpn[2] = -1;

    flags &= ~QUARK_FLAG_ACTIVE;      // default camera off
    state.state_flags &= ~STATE_MASK_BOUND;
    state.state_flags |= STATE_FLAG_BALL;
}


/* ********************************************************
******************************************************** */
int electron::parse(FILE *infile, char *token) {

   if (!strcmp(token, TOKEN_UP_STR)) {
      get_token(infile, token);
      vup[0] = (float)atof(token);
      get_token(infile, token);
      vup[1] = (float)atof(token);
      get_token(infile, token);
      vup[2] = (float)atof(token);

      return 1;
   }

   return quark::parse(infile, token);
}


/* ********************************************************
******************************************************** */
void electron::preprocess(void *data) {

   quark::preprocess(data);

   vpn[0] = initxform[0][3] - ((camera *)ob)->coa[0];
   vpn[1] = initxform[1][3] - ((camera *)ob)->coa[1];
   vpn[2] = initxform[2][3] - ((camera *)ob)->coa[2];
}


/* ********************************************************
******************************************************** */
void electron::setup() {

   camera *ptr = (camera *)ob;

   copyarray3(ptr->location, state.center);

   copyarray3(ptr->vpn, vpn);
   matvecmultv(state.xmx, ptr->vpn);
   normalize3(ptr->vpn);

   copyarray3(ptr->vup, vup);
   matvecmultv(state.xmx, ptr->vup);
   normalize3(ptr->vup);

   subeqarray3(ptr->coa, state.center, ptr->vpn);

   ptr->nper();
}
