

#include <stdlib.h>
#include <string.h>

#include "pstring.h"
#include "line.h"
#include "chain.h"


/* *************************************************************
************************************************************* */
int chain::query_whatwasi(int type) {

   return (chain::query_whatami() == type) ? 1 : quark::query_whatwasi(type);
}


/* *************************************************************
************************************************************* */
chain::chain() {

    ob = new line;
    ob->id = object_counter;
    object_counter++;

    endpt[0] = endpt[1] = endpt[2] = 0; endpt[3] = 1;
    decay = 1;
    intensity = 1;
    death = 0;
}


/* *************************************************************
************************************************************* */
int chain::parse(FILE *infile, char *token) {

   switch (token[0]) {

      case 'd':
         if (!strcmp(token, TOKEN_DEATH_STR)) {
            get_token(infile, token);
            death = (float)atof(token);
            return 1;
         }

         if (!strcmp(token, TOKEN_DECAY_STR)) {
            get_token(infile, token);
            decay = (float)(1.0 - atof(token));
            return 1;
         }

         break;

      case 'i':

         if (!strcmp(token, TOKEN_INTENSITY_STR)) {
            get_token(infile, token);
            intensity = (float)atof(token);
            return 1;
         }

         break;

      case 'e':
         if (!strcmp(token, TOKEN_END_POINT_STR)) {
            get_token(infile, token);
            endpt[0] = (float)atof(token);
            get_token(infile, token);
            endpt[1] = (float)atof(token);
            get_token(infile, token);
            endpt[2] = (float)atof(token);

            return 1;
         }

         break;

      case 's':
         if (!strcmp(token, TOKEN_SHADE_STR)) {
            get_token(infile, token);
            lower_case(token);

            switch (token[0]) {
               case 'w':
                  if (!strcmp(token, SHADE_WFBW_STR)) {
                     ((line *)ob)->mctype.set_master(WFBW);
                     return 1;
                  }

                  return 0;

               case 'g':
                  if (!strcmp(token, SHADE_GOURAUD_STR)) {
                     ((line *)ob)->mctype.set_master(GOURAUD);

                     get_token(infile, token);
                     color[0][0] = (float)atof(token);
                     get_token(infile, token);
                     color[0][1] = (float)atof(token);
                     get_token(infile, token);
                     color[0][2] = (float)atof(token);
                     get_token(infile, token);
                     color[1][0] = (float)atof(token);
                     get_token(infile, token);
                     color[1][1] = (float)atof(token);
                     get_token(infile, token);
                     color[1][2] = (float)atof(token);

                     return 1;
                  }

                  return 0;

               default:
                  break;
            }

            return 0;
         }

         break;

      default:
         break;
   }

   return quark::parse(infile, token);
}


/* *************************************************************
   place object based on local and parent xforms
************************************************************* */
void chain::setup() {

   line *ptr = (line *)ob;

   copyarray3(ptr->center, state.center);

   matvecmulto(state.xmx, endpt, ptr->wwi); // note: wwi has 3 elements

   ptr->color[0][0] = color[0][0] * cintensity;
   ptr->color[0][1] = color[0][1] * cintensity;
   ptr->color[0][2] = color[0][2] * cintensity;

   ptr->color[1][0] = color[1][0] * cintensity;
   ptr->color[1][1] = color[1][1] * cintensity;
   ptr->color[1][2] = color[1][2] * cintensity;
}


/* *************************************************************
************************************************************* */
void chain::begin(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx) {

   if (intensity <= death)
      flags &= ~QUARK_FLAG_ACTIVE;

   if (flags & QUARK_FLAG_ACTIVE) {
      cintensity = intensity;
      intensity *= decay;
   }
   
   quark::begin(hiearchy_manager, parent, mx);   
}


/* *************************************************************
************************************************************* */
void chain::whereami(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx) {

   if (intensity <= death)
      flags &= ~QUARK_FLAG_ACTIVE;

   if (flags & QUARK_FLAG_ACTIVE) {
      cintensity = intensity;
      intensity *= decay;
   }
   
   quark::whereami(hiearchy_manager, parent, mx);   
}

