

#include <string.h>

#include "WIN_X.h"
#include "WIN_XOS.h"
#include "global.h"


/************************************************************************
************************************************************************/
unsigned int *XOSwindow::XOSnew_ogl_attrib_list(unsigned int *attribs) {

   int i, j;
   unsigned int *list;

   j = 5;

   for (i=0; attribs[i]; i++)
      switch (attribs[i]) {
         case OGLFLAG_RED_SIZE:
         case OGLFLAG_GREEN_SIZE:
         case OGLFLAG_BLUE_SIZE:
         case OGLFLAG_DEPTH_SIZE:
            i++;
            j += 2;
            break;

        default:
            break;
      }

   list = new unsigned int[j];

   list[0] = GLX_RENDER_TYPE;
   list[1] = GLX_RGBA_BIT;
   list[2] = GLX_DRAWABLE_TYPE;
   list[3] = GLX_PBUFFER_BIT;
   list[j-1] = None;

   j = 4;
   for (i=0; attribs[i]; i++)
      switch (attribs[i]) {
	    
         case OGLFLAG_RED_SIZE:
            i++;
            list[j] = GLX_RED_SIZE;
            list[j+1] = attribs[i];
            j += 2;
            break;
	    
         case OGLFLAG_GREEN_SIZE:
            i++;
            list[j] = GLX_GREEN_SIZE;
            list[j+1] = attribs[i];
            j += 2;
            break;
	    
         case OGLFLAG_BLUE_SIZE:
            i++;
            list[j] = GLX_BLUE_SIZE;
            list[j+1] = attribs[i];
            j += 2;
            break;
	    
         case OGLFLAG_DEPTH_SIZE:
         case OGLFLAG_BPP:
            i++;
            break;
	    
         // case OGLFLAG_DOUBLEBUFFER:
         // case OGLFLAG_RGBA:
         default:
            break;
      }

   return list;      
}


/* **************************************************
************************************************** */
void XOSwindow::XOSsetup_ogl() {

   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();
   glOrtho(0, mapbuffer.maxx, 0, mapbuffer.maxy, -1, 1);
   glMatrixMode(GL_MODELVIEW);
   glLoadIdentity();
   glRasterPos2i(0,0);

   glClearColor(0.0,0.0,0.0,0.0);
   glClear(GL_COLOR_BUFFER_BIT);
   VIRTUALswapbuffers();
   glClear(GL_COLOR_BUFFER_BIT);
}


/* **************************************************
************************************************** */
void XOSwindow::VIRTUALgetdim(int *w, int *h) {

   *w = mapbuffer.maxx;
   *h = mapbuffer.maxy;
}


/************************************************************************
************************************************************************/
int XOSwindow::VIRTUALreset(int argc, char *argv[], int maxx, int maxy, char *winname, void *attribs) {

   GLint *glattribs;
   int i, count;
   XVisualInfo *vid;
   GLXFBConfig *fbconfigs;

   int pbuffer_attribs[] = {
      GLX_PRESERVED_CONTENTS, 1,
      GLX_PBUFFER_WIDTH, maxx,
      GLX_PBUFFER_HEIGHT, maxy,
      None
   };

   int gattribs[] = {
      OGLFLAG_RED_SIZE, 3,
      OGLFLAG_GREEN_SIZE, 3,
      OGLFLAG_BLUE_SIZE, 2,
      OGLFLAG_NULL
   };

   if (!attribs)
      attribs = gattribs;

   if (!(mdisplay = XOpenDisplay(NULL))) {
      sprintf(perror_buffer,
               "Error: Could not open a connection to X on display %s.\n",
               XDisplayName ("V R US"));
      pprintf(perror_buffer);
      return 0;
   }

   glattribs = (GLint *)XOSnew_ogl_attrib_list((unsigned int *)attribs);
   fbconfigs = glXChooseFBConfig(mdisplay, XDefaultScreen(mdisplay), glattribs, &count);
   delete [] glattribs;

   if (!fbconfigs) {
      pprintf("Error: Could not find a frame buffer config...\n");
      XCloseDisplay(mdisplay);
      mdisplay = NULL;
      return 0;
   }

   vid = NULL;
   for (i=0; i<count; i++) {
      vid = glXGetVisualFromFBConfig(mdisplay, fbconfigs[i]);
      if (vid)
         break;
   }

   if (!vid) {
      pprintf("Error: Could not extract visual...\n");
      XFree(fbconfigs);
      XCloseDisplay(mdisplay);
      mdisplay = NULL;
      return 0;
   }

   pbuffer = glXCreatePbuffer(mdisplay, fbconfigs[i], pbuffer_attribs);

   if (!pbuffer) {
      pprintf("Error: Could not find create a pbuffer...\n");
      XFree(vid);
      XFree(fbconfigs);
      XCloseDisplay(mdisplay);
      mdisplay = NULL;
      return 0;
   }

   XFree(fbconfigs);

   XSetIOErrorHandler(IOErrorHandler);

   context = glXCreateContext(mdisplay, vid, NULL, GL_TRUE);

   XFree(vid);

   glXMakeCurrent(mdisplay, pbuffer, context);

   mapbuffer.init_map(maxx, maxy);

   XOSsetup_ogl();
}


/************************************************************************
************************************************************************/
void XOSwindow::VIRTUALcancel() {

   if (!mdisplay)
      return;

   glXMakeCurrent(mdisplay, pbuffer, context);
   glFlush();
   glXMakeCurrent(mdisplay, None, NULL);

   glXDestroyContext(mdisplay, context);
   glXDestroyPbuffer(mdisplay, pbuffer);
   XCloseDisplay(mdisplay);

   mdisplay = NULL;
   context = NULL;
   pbuffer = 0;
}


/************************************************************************
************************************************************************/
void XOSwindow::VIRTUALswapbuffers() {

   glReadPixels(0, 0, mapbuffer.maxx, mapbuffer.maxy, GL_RGBA, GL_UNSIGNED_BYTE, mapbuffer.data);
}


/* ***********************************************************************
*********************************************************************** */
void XOSwindow::OSset_context() {
   
   glXMakeCurrent(mdisplay, pbuffer, context);
}

