

#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "WIN_XOGL.h"

#include <X11/Xatom.h>

#include "global.h"


/************************************************************************
************************************************************************/
unsigned int *XOGLwindow::XOGLnew_ogl_attrib_list(unsigned int *attribs) {

   int i, j;
   unsigned int *list;
   
   for (i=0; attribs[i]; i++)
      switch (attribs[i]) {
         case OGLFLAG_RED_SIZE:
         case OGLFLAG_GREEN_SIZE:
         case OGLFLAG_BLUE_SIZE:
         case OGLFLAG_DEPTH_SIZE:
            i++;
            break;
	   
        default:
            break;
      }
        
   list = new unsigned int[i+1];
   
   for (i=j=0; attribs[i]; i++)
      switch (attribs[i]) {
         case OGLFLAG_DOUBLEBUFFER:
            list[j] = GLX_DOUBLEBUFFER;
            j++;
            break;
	    
         case OGLFLAG_RGBA:
            list[j] = GLX_RGBA;
            j++;
            break;
	    
         case OGLFLAG_RED_SIZE:
            list[j] = GLX_RED_SIZE;
            list[j+1] = attribs[i+1];
            i++;
            j += 2;
            break;
	    
         case OGLFLAG_GREEN_SIZE:
            list[j] = GLX_GREEN_SIZE;
            list[j+1] = attribs[i+1];
            i++;
            j += 2;
            break;
	    
         case OGLFLAG_BLUE_SIZE:
            list[j] = GLX_BLUE_SIZE;
            list[j+1] = attribs[i+1];
            i++;
            j += 2;
            break;
	    
         case OGLFLAG_DEPTH_SIZE:
            list[j] = GLX_DEPTH_SIZE;
            list[j+1] = attribs[i+1];
            i++;
            j += 2;
            break;
	    
         case OGLFLAG_BPP:
            i++;
            break;

         default:
            break;
      }

   list[j] = 0;
   return list;      
}


/* **************************************************
************************************************** */
void XOGLwindow::XOGLsetup_ogl() {

   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();
   glOrtho(0, mapbuffer.maxx, 0, mapbuffer.maxy, -1, 1);
   glMatrixMode(GL_MODELVIEW);
   glLoadIdentity();
   glRasterPos2i(0,0);

   glClearColor(0.0,0.0,0.0,0.0);
   glClear(GL_COLOR_BUFFER_BIT);
   VIRTUALswapbuffers();
   glClear(GL_COLOR_BUFFER_BIT);
}


/* **************************************************
************************************************** */
void XOGLwindow::VIRTUALgetdim(int *w, int *h) {

   int oldx, oldy;

   oldx = mapbuffer.maxx;
   oldy = mapbuffer.maxy;

   Xwindow::VIRTUALgetdim(w, h);

   if (*w != oldx || *h != oldy)
      XOGLsetup_ogl();
}


/************************************************************************
************************************************************************/
int XOGLwindow::VIRTUALreset(int argc, char *argv[], int maxx, int maxy, char *winname, void *attribs) {

   GLint *glattribs;
   GLXContext cparent = NULL;
   
   XSetWindowAttributes mattrib;
   XTextProperty wname;
   char *wn = "gemstone";
   XClassHint *cl;

   Window mroot;
   XVisualInfo *vid;
   
   XWindowAttributes wa;
   Window parent_id;
   int parent_flag = 0;
   int i;
   int mdepth;
   int mscreen;

   unsigned int gattribs[] = {
                OGLFLAG_RGBA,
                OGLFLAG_RED_SIZE, 3,
                OGLFLAG_GREEN_SIZE, 3,
                OGLFLAG_BLUE_SIZE, 2,
                OGLFLAG_DEPTH_SIZE, 1,
                OGLFLAG_DOUBLEBUFFER,
                OGLFLAG_NULL
   };

   if (!attribs)
     attribs = (void *)gattribs;

   flags = OGLFLAG_NULL;
   
   for (i=0; ((unsigned int *)attribs)[i]; i++)
      switch (((unsigned int *)attribs)[i]) {
      
         case OGLFLAG_DOUBLEBUFFER:
            flags |= OGLFLAG_DOUBLEBUFFER;
            break;

         case OGLFLAG_ICONIFY:
            flags |= OGLFLAG_ICONIFY;
            break;
	    
         case OGLFLAG_BPP:
         case OGLFLAG_RED_SIZE:
         case OGLFLAG_GREEN_SIZE:
         case OGLFLAG_BLUE_SIZE:
         case OGLFLAG_DEPTH_SIZE:
            i++;
            break;
	    
         case OGLFLAG_MAPBUFFER:
            flags |= OGLFLAG_MAPBUFFER;
            mapbuffer.init_map(maxx, maxy, 1);
            break;

         case OGLFLAG_SHARE_CONTEXT:
            i++;

            if (((unsigned int *)attribs)[i] == OGLFLAG_NULL)
               break;

            cparent = (GLXContext)((int *)attribs)[i];
            i++;

            if (((unsigned int *)attribs)[i] == OGLFLAG_NULL)
               break;

            fontid = ((int *)attribs)[i];
            flags |= OGLFLAG_SHARE_CONTEXT;
            break;
	    
         default:
            break;
      }

   if (!(flags & OGLFLAG_MAPBUFFER)) {
      mapbuffer.maxx = maxx;
      mapbuffer.maxy = maxy;
   }

   if (!(mdisplay = XOpenDisplay(NULL))) {
      sprintf(perror_buffer,
               "ERROR: Could not open a connection to X on display %s.\n",
               XDisplayName ("V R US"));
      pprintf(perror_buffer);
      return 0;
   }

   mscreen = XDefaultScreen(mdisplay);

   glattribs = (GLint *)XOGLnew_ogl_attrib_list((unsigned int *)attribs);
   vid = glXChooseVisual(mdisplay, mscreen, glattribs);
   delete [] glattribs;

   if (!vid) {
      pprintf("Could not create 24 bit visual... Aborting...\n");
      XCloseDisplay(mdisplay);
      return 0;
   }

   mroot = RootWindow(mdisplay, vid->screen);

   mdepth = vid->depth;
   mattrib.colormap = XCreateColormap(mdisplay, mroot, vid->visual, AllocNone);
   mattrib.border_pixel = 0x0;
   mattrib.event_mask = ButtonPressMask | ButtonReleaseMask |
                        KeyPressMask | KeyReleaseMask | ExposureMask |
                        PointerMotionMask | StructureNotifyMask;

   for (i=0; i<argc; i++)
      if (!strcmp(argv[i], TOKEN_WINPARENT_STR)) {
         i++;
         if (i >= argc)
            break;
         parent_id = atoi(argv[i]);
         parent_flag = 1;
      }

   if (parent_flag) {
      XGetWindowAttributes(mdisplay, parent_id, &wa);

      if (flags & OGLFLAG_MAPBUFFER)
         mapbuffer.init_map(wa.width, wa.height, 1);
      else {
         mapbuffer.maxx = wa.width;
         mapbuffer.maxy = wa.height;
      }

      mroot = parent_id;
   }

   mwindow = XCreateWindow(mdisplay, mroot, 0, 0, mapbuffer.maxx, mapbuffer.maxy, 0,
                           mdepth, InputOutput, vid->visual,
//                           CWBackPixel | CWBorderPixel | CWColormap | CWEventMask,
                           CWBorderPixel | CWColormap | CWEventMask,
                           &mattrib);

   mGC = NULL;

   XStringListToTextProperty(&winname, 1, &wname);
   XSetTextProperty(mdisplay, mwindow, &wname, XA_WM_NAME);
   XSetTextProperty(mdisplay, mwindow, &wname, XA_WM_ICON_NAME);
   XFree(wname.value);
//   XSetWMName(mdisplay, mwindow, &wname);
//   XSetWMIconName(mdisplay, mwindow, &wname);

   cl = XAllocClassHint();
   cl->res_class = wn;
   XSetClassHint(mdisplay, mwindow, cl);
   cl->res_class = NULL;
   XFree(cl);

   XMapWindow(mdisplay, mwindow);
   XSetIOErrorHandler(IOErrorHandler);

   flags |= OGLFLAG_INIT;

   context = glXCreateContext( mdisplay, vid, cparent, GL_TRUE );
   XFree(vid);
   
   glXMakeCurrent(mdisplay, mwindow, context);

   XOGLsetup_ogl();

   return XOGLinit_font();
}


/************************************************************************
************************************************************************/
void XOGLwindow::VIRTUALcancel() {

   if (!(flags & OGLFLAG_INIT))
      return;
      
   flags = OGLFLAG_NULL;

   glXMakeCurrent(mdisplay, mwindow, context);

   if (!(flags & OGLFLAG_SHARE_CONTEXT))
      glDeleteLists(fontid, fontcount);

   glFlush();

   glXMakeCurrent(mdisplay, None, NULL);
   glXDestroyContext(mdisplay, context);

   Xwindow::VIRTUALcancel();
}


/************************************************************************
************************************************************************/
void XOGLwindow::VIRTUALswapbuffers() {

   if (flags & OGLFLAG_DOUBLEBUFFER)
      glXSwapBuffers(mdisplay, mwindow);
}


/************************************************************************
************************************************************************/
void XOGLwindow::BLTbitmap(mapul *mcanvas) {

/*
   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();
   glOrtho(0, mapbuffer.maxx, 0, mapbuffer.maxy, -1, 1);
   glMatrixMode(GL_MODELVIEW);
   glLoadIdentity();
   glRasterPos2i(0,0);
*/

   glDrawPixels(mcanvas->query_x(), mcanvas->query_y(), GL_RGBA, GL_UNSIGNED_BYTE, mcanvas->data);
   VIRTUALswapbuffers();
}


/************************************************************************
************************************************************************/
void XOGLwindow::BLTbitmap(int framenum, linelist *mcanvas) {

   line_type *ptr;

/*
   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();
   glOrtho(0, mapbuffer.maxx, 0, mapbuffer.maxy, -1, 1);
   glMatrixMode(GL_MODELVIEW);
   glLoadIdentity();
   glRasterPos2i(0,0);
*/

   glClear(GL_COLOR_BUFFER_BIT);

   if (framenum >= mcanvas->count)
      return;

   glColor3f(1.0f, 1.0f, 1.0f);

   glBegin(GL_LINES);

      for (ptr=(line_type *)mcanvas->list[framenum].head; ptr; ptr=(line_type *)ptr->next) {
         glVertex2i(ptr->pt[0] >> 16, ptr->pt[0] & 0xffff);
         glVertex2i(ptr->pt[1] >> 16, ptr->pt[1] & 0xffff);
      }

   glEnd();

   VIRTUALswapbuffers();
}


/************************************************************************
************************************************************************/
void XOGLwindow::BLTbitblt(mapul *mcanvas) {

   XEvent mevent;

/*
   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();
   glOrtho(0, mapbuffer.maxx, 0, mapbuffer.maxy, -1, 1);
   glMatrixMode(GL_MODELVIEW);
   glLoadIdentity();
   glRasterPos2i(0,0);
*/
   
   glDrawPixels(mcanvas->query_x(), mcanvas->query_y(), GL_RGBA, GL_UNSIGNED_BYTE, mcanvas->data);
   VIRTUALswapbuffers();

   while (1) {
      XNextEvent (mdisplay, &mevent);
      if (mevent.type == KeyPress || mevent.type == ButtonPress)
         return;

      glDrawPixels(mcanvas->query_x(), mcanvas->query_y(), GL_RGBA, GL_UNSIGNED_BYTE, mcanvas->data);
      VIRTUALswapbuffers();
   }

}


/************************************************************************
************************************************************************/
void XOGLwindow::BLTbitblt(int framenum, linelist *mcanvas) {

   XEvent mevent;

   BLTbitmap(framenum, mcanvas);

   while (1) {
      XNextEvent (mdisplay, &mevent);
      if (mevent.type == KeyPress || mevent.type == ButtonPress)
         return;

      BLTbitmap(framenum, mcanvas);
   }

}


/************************************************************************
************************************************************************/
void XOGLwindow::BLTanimate(int numframes, mapul *mcanvas) {

   int     i;
   float  offset;
   clock_t otime, ntime;
   XEvent mevent;

/*
   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();
   glOrtho(0, mapbuffer.maxx, 0, mapbuffer.maxy, -1, 1);
   glMatrixMode(GL_MODELVIEW);
   glLoadIdentity();
   glRasterPos2i(0,0);
*/

   offset = CLOCKS_PER_SEC/((float)FRAMESPERSEC);
   otime = clock();

   while (1) {
      for (i=0; i<numframes; i++) {
         XCheckMaskEvent (mdisplay,KeyPressMask | ButtonPressMask, &mevent);
         if (mevent.type == KeyPress || mevent.type == ButtonPress)
            return;

         glDrawPixels(mcanvas[i].query_x(), mcanvas[i].query_y(), GL_RGBA, GL_UNSIGNED_BYTE, mcanvas[i].data);
         VIRTUALswapbuffers();
         while ( (ntime=clock()) - otime < offset && ntime >= otime);
         otime = ntime;
      }

   }

}


/************************************************************************
************************************************************************/
void XOGLwindow::BLTanimate(linelist *mcanvas) {

   int     i;
   float  offset;
   clock_t otime, ntime;
   XEvent mevent;

   offset = CLOCKS_PER_SEC/((float)FRAMESPERSEC);
   otime = clock();

   while (1) {
      for (i=0; i<mcanvas->count; i++) {
         XCheckMaskEvent (mdisplay,KeyPressMask | ButtonPressMask, &mevent);
         if (mevent.type == KeyPress || mevent.type == ButtonPress)
            return;

         BLTbitmap(i, mcanvas);
         while ( (ntime=clock()) - otime < offset && ntime >= otime);
         otime = ntime;
      }

   }

}


/************************************************************************
************************************************************************/
int XOGLwindow::XOGLinit_font() {

   int fontoffset;
   XFontStruct *fontInfo;
   
//   fontInfo = XLoadQueryFont(mdisplay, "-adobe-helvetica-medium-r-normal--14-140-75-75-p-77-iso8859-1");
   fontInfo = XLoadQueryFont(mdisplay, "-adobe-helvetica-medium-r-normal--17-120-100-100-p-88-iso8859-1");

   if (!fontInfo) {
      pprintf("no font found\n");
      return 0;
   }

   fontcount = fontInfo->max_char_or_byte2 + 1;
   fontid = glGenLists(fontcount);

   if (!fontid) {
      pprintf("out of display lists\n");
      return 0;
   }

   fontoffset = fontInfo->min_char_or_byte2;

   glXUseXFont(fontInfo->fid, fontoffset, fontcount-fontoffset, fontid+fontoffset);
   XFreeFont(mdisplay, fontInfo);
   return 1;
}


/* ***********************************************************************
  assumes we're in ortho2 and matricies are initiallized
*********************************************************************** */
void XOGLwindow::XOGLprint(int x, int y, char *buffer) {

   glRasterPos2i(x, y);
   glPushAttrib (GL_LIST_BIT);
   glListBase(fontid);
   glCallLists(strlen(buffer), GL_UNSIGNED_BYTE, (unsigned char *)buffer);
   glPopAttrib();
}


/* ***********************************************************************
*********************************************************************** */
int XOGLwindow::VIRTUALreparent(void *data) {

   Xwindow::VIRTUALreparent(data);

   glXMakeCurrent(mdisplay, mwindow, context);
   XOGLsetup_ogl();
   return 1;
}


/* ***********************************************************************
*********************************************************************** */
void XOGLwindow::XOGLset_context() {
   
   glXMakeCurrent(mdisplay, mwindow, context);
}


