

#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "WIN_X.h"
#include "global.h"

#include <X11/Xatom.h>
#include <X11/Xutil.h>


/************************************************************************
   This is the main function that initializes a window
************************************************************************/
int IOErrorHandler(Display *display) {

   exit(0);
   return 1;
}


/* ***********************************************************************
*********************************************************************** */
int Xwindow::VIRTUALreparent(void *data) {

   XWindowAttributes wa;

   if (!data)
      return 0;

   XWithdrawWindow(mdisplay, mwindow, XDefaultScreen(mdisplay));
   XSync(mdisplay, mwindow);

   XReparentWindow(mdisplay, mwindow, (Window)data, 0, 0);
   XMapWindow(mdisplay, mwindow);
   XSync(mdisplay, mwindow);

   XGetWindowAttributes(mdisplay, (Window)data, &wa);

   if (flags & OGLFLAG_MAPBUFFER)
      mapbuffer.init_map(wa.width, wa.height, 1);
   else {
      mapbuffer.maxx = wa.width;
      mapbuffer.maxy = wa.height;
   }

   XResizeWindow(mdisplay, mwindow, mapbuffer.maxx, mapbuffer.maxy);
   return 1;
}


/************************************************************************
   This is the main function that initializes a window
************************************************************************/
int Xwindow::VIRTUALreset(int argc, char *argv[], int maxx, int maxy, char *winname, void *attribs) {

   XVisualInfo y;
   int TWENTYFOUR = 0;

   XSetWindowAttributes mattrib;
   XTextProperty wname;
   char *wn = "gemstone";
   XClassHint *cl;
   XEvent mevent;
   Window mroot;
   XVisualInfo *vid;

   XWindowAttributes wa;
   Window parent_id;
   int parent_flag = 0;
   int i;
   int mdepth;
   int mscreen;

   unsigned int gattribs[] = {
                OGLFLAG_RGBA,
                OGLFLAG_RED_SIZE, 3,
                OGLFLAG_GREEN_SIZE, 3,
                OGLFLAG_BLUE_SIZE, 2,
                OGLFLAG_DEPTH_SIZE, 1,
                OGLFLAG_DOUBLEBUFFER,
                OGLFLAG_NULL
   };

   if (!attribs)
     attribs = (void *)gattribs;

   flags = OGLFLAG_NULL;

   for (i=0; ((unsigned int *)attribs)[i]; i++)
      switch (((unsigned int *)attribs)[i]) {
      
         case OGLFLAG_BPP:
         case OGLFLAG_RED_SIZE:
         case OGLFLAG_GREEN_SIZE:
         case OGLFLAG_BLUE_SIZE:
         case OGLFLAG_DEPTH_SIZE:
            i++;
            break;
	    
         case OGLFLAG_MAPBUFFER:
            flags |= OGLFLAG_MAPBUFFER;
            mapbuffer.init_map(maxx, maxy, 1);
            break;

         case OGLFLAG_SHARE_CONTEXT:
            i += 2;
            break;

         default:
            break;
      }

   if (!(flags & OGLFLAG_MAPBUFFER)) {
      mapbuffer.maxx = maxx;
      mapbuffer.maxy = maxy;
   }

   if (!(mdisplay = XOpenDisplay(NULL))) {
      sprintf(perror_buffer,
               "ERROR: Could not open a connection to X on display %s.\n",
               XDisplayName ("V R US"));
      pprintf(perror_buffer);
      return 0;
   }

   mscreen = XDefaultScreen(mdisplay);

   y.screen = mscreen;
   y.depth = 24;
   y.c_class = TrueColor;

   if (!(vid = XGetVisualInfo(mdisplay, VisualScreenMask | VisualDepthMask | VisualClassMask, &y, &TWENTYFOUR))) {
      pprintf("Could not create 24 bit visual... Aborting...\n");
      XCloseDisplay(mdisplay);
      return 0;
   }

   mroot = RootWindow(mdisplay, mscreen);

   mdepth = y.depth;
   mattrib.colormap = XCreateColormap(mdisplay, mroot, vid->visual, AllocNone);
   mattrib.border_pixel = 0x0;
   mattrib.event_mask = ButtonPressMask | ButtonReleaseMask |
                        KeyPressMask | KeyReleaseMask | ExposureMask | 
                        PointerMotionMask | StructureNotifyMask;

   for (i=0; i<argc; i++)
      if (!strcmp(argv[i], TOKEN_WINPARENT_STR)) {
         i++;
         if (i >= argc)
            break;
         parent_id = atoi(argv[i]);
         parent_flag = 1;
      }

   if (parent_flag) {
      XGetWindowAttributes(mdisplay, parent_id, &wa);

      if (flags & OGLFLAG_MAPBUFFER)
         mapbuffer.init_map(wa.width, wa.height, 1);
      else {
         mapbuffer.maxx = wa.width;
         mapbuffer.maxy = wa.height;
      }

      mroot = parent_id;
   } 

   mwindow = XCreateWindow(mdisplay, mroot, 0, 0, mapbuffer.maxx, mapbuffer.maxy, 0,
                           mdepth, InputOutput, vid->visual,
//                           CWBackPixel | CWBorderPixel | CWColormap | CWEventMask,
                           CWBorderPixel | CWColormap | CWEventMask,
                           &mattrib);

   XFree(vid);
   
   mGC = XCreateGC(mdisplay, mwindow, 0, NULL);

   XStringListToTextProperty(&winname, 1, &wname);
   XSetTextProperty(mdisplay, mwindow, &wname, XA_WM_NAME);
   XSetTextProperty(mdisplay, mwindow, &wname, XA_WM_ICON_NAME);
   XFree(wname.value);
//   XSetWMName(mdisplay, mwindow, &wname);
//   XSetWMIconName(mdisplay, mwindow, &wname);
   
   cl = XAllocClassHint();
   cl->res_class = wn;
   XSetClassHint(mdisplay, mwindow, cl);
   cl->res_class = NULL;
   XFree(cl);

   XMapWindow(mdisplay, mwindow);
   XSetIOErrorHandler(IOErrorHandler);
   
   flags |= OGLFLAG_INIT;

   do {
      XNextEvent (mdisplay, &mevent);
   } while (mevent.type != Expose);

   XSetForeground(mdisplay, mGC, 0);   // 0xbbggrr sgi
   XFillRectangle(mdisplay, mwindow, mGC, 0, 0, mapbuffer.maxx, mapbuffer.maxy);
   XFlush(mdisplay);
   
   xcanvas = XGetImage(mdisplay, mwindow, 0, 0, mapbuffer.maxx, mapbuffer.maxy, AllPlanes, ZPixmap);
   return 1;
}


/************************************************************************
************************************************************************/
void Xwindow::VIRTUALswapbuffers() {

   XPutImage(mdisplay, mwindow, mGC, xcanvas, 0, 0, 0, 0, mapbuffer.maxx, mapbuffer.maxy);
   XFlush(mdisplay);
}


/************************************************************************
************************************************************************/
void Xwindow::VIRTUALcancel() {

   if (!(flags & OGLFLAG_INIT))
      return;
      
   if (mGC)
      XFreeGC(mdisplay, mGC);

   if (xcanvas)
      XDestroyImage(xcanvas);
   
   XFlush(mdisplay);
   XCloseDisplay(mdisplay);
}


/************************************************************************
************************************************************************/
void Xwindow::VIRTUALgetdim(int *w, int *h) {

   XWindowAttributes wa;

   XGetWindowAttributes(mdisplay, mwindow, &wa);

   *w = wa.width;
   *h = wa.height;
   
   if (*w != mapbuffer.maxx || *h != mapbuffer.maxy)
      if (flags & OGLFLAG_MAPBUFFER)
         mapbuffer.init_map(*w, *h, 1);
      else {
         mapbuffer.maxx = *w;
         mapbuffer.maxy = *h;
      }

}


/************************************************************************
************************************************************************/
void Xwindow::Xmapcpy(XImage * mcanvas, mapul *tob) {

   int i, j;
   int mapsize;
   int yinc2;
   unsigned int *base, *dbase;

   yinc2  = tob->maxx<<2;

   mapsize = tob->maxy*tob->maxx;
   base    = tob->data;
   dbase   = (unsigned int *)mcanvas->data;

   for (i=0, j=mapsize-tob->maxx; i<mapsize; j-=tob->maxx, i+=tob->maxx)
      memcpy(&dbase[j], &base[i], yinc2);
}


/************************************************************************
************************************************************************/
void Xwindow::BLTbitblt(mapul *mcanvas) {

   XEvent mevent;

   Xmapcpy(xcanvas, mcanvas);
   VIRTUALswapbuffers();

   while (1) {
      XNextEvent (mdisplay, &mevent);
      if (mevent.type == KeyPress || mevent.type == ButtonPress)
         return;

      VIRTUALswapbuffers();
   }

}


/************************************************************************
************************************************************************/
void Xwindow::BLTbitblt(int framenum, linelist *mcanvas) {

   XEvent mevent;

   while (1) {
      BLTbitmap(framenum, mcanvas);

      XNextEvent (mdisplay, &mevent);
      if (mevent.type == KeyPress || mevent.type == ButtonPress)
         return;
   }

}


/************************************************************************
************************************************************************/
void Xwindow::BLTbitmap(mapul *mcanvas) {

   Xmapcpy(xcanvas, mcanvas);
   VIRTUALswapbuffers();
}


/************************************************************************
************************************************************************/
void Xwindow::BLTbitmap(int framenum, linelist *mcanvas) {

   line_type *ptr;

   memset(xcanvas->data, 0, xcanvas->height*xcanvas->width<<2);

   if (framenum >= mcanvas->count)
      return;

   for (ptr=(line_type *)mcanvas->list[framenum].head; ptr; ptr=(line_type *)ptr->next)
      Xline(ptr->pt[0] >> 16, ptr->pt[0] & 0xffff, ptr->pt[1] >> 16, ptr->pt[1] & 0xffff, 0xffffffff, xcanvas);

   VIRTUALswapbuffers();
}


/************************************************************************
************************************************************************/
void Xwindow::BLTanimate(int numframes, mapul *mcanvas) {

   int     i;
   float  offset;
   clock_t otime, ntime;
   XEvent mevent;

   offset = CLOCKS_PER_SEC/((float)FRAMESPERSEC);
   otime = clock();

   while (1) {
      for (i=0; i<numframes; i++) {

         XCheckMaskEvent (mdisplay, KeyPressMask | ButtonPressMask, &mevent);
         if (mevent.type == KeyPress || mevent.type == ButtonPress)
            return;

         Xmapcpy(xcanvas, &mcanvas[i]);
         VIRTUALswapbuffers();

         while ( (ntime=clock()) - otime < offset && ntime >= otime);
         otime = ntime;
      }

   }

}


/************************************************************************
************************************************************************/
void Xwindow::BLTanimate(linelist *mcanvas) {

   int     i;
   float  offset;
   clock_t otime, ntime;
   XEvent mevent;

   offset = CLOCKS_PER_SEC/((float)FRAMESPERSEC);
   otime = clock();

   while (1) {
      for (i=0; i<mcanvas->count; i++) {
         XCheckMaskEvent (mdisplay, KeyPressMask | ButtonPressMask, &mevent);
         if (mevent.type == KeyPress || mevent.type == ButtonPress)
            return;

         BLTbitmap(i, mcanvas);

         while ( (ntime=clock()) - otime < offset && ntime >= otime);
         otime = ntime;
      }

   }

}


/************************************************************************
************************************************************************/
int Xwindow::Xqtest(unsigned int x) {

   XEvent mevent;

   if (XCheckMaskEvent (mdisplay, x, &mevent)) {
      XPutBackEvent(mdisplay, &mevent);
      return 1;
   }

   return 0;
}


/************************************************************************
************************************************************************/
int Xwindow::Xpollkeyboard(char *x) {

   XQueryKeymap(mdisplay, x);
   return 1;
}


/************************************************************************
************************************************************************/
int Xwindow::Xcode2sym(unsigned int x) {

   return XKeycodeToKeysym(mdisplay, x, 0);
}


/************************************************************************
************************************************************************/
XEvent Xwindow::Xqread(unsigned int *x) {

   XEvent mevent;

   XNextEvent (mdisplay, &mevent);

   if (mevent.type == KeyPress)
      *x = XKeycodeToKeysym( mdisplay, mevent.xkey.keycode, 0 );

   return mevent;
}


/************************************************************************
************************************************************************/
void Xwindow::Xqenter(XEvent *mevent) {

   XPutBackEvent(mdisplay, mevent);
}


/* **************************************************
   bressem run-length line
************************************************** */
void Xwindow::Xline(int x0, int y0, int x1, int y1, unsigned int color, mapul *mcanvas) {

   int         i, x;
   int          absdeltax, absdeltay;
   int          deltax, deltay;
   int          j, k;                   // loop counter
   int          yinc;
   int          run_length, rlplus, rlinc, rlflag;

   if (x0 < x1) {
      if (x0 < 0 || x1 >= mapbuffer.maxx)
         return;
   }

   else
      if (x1 < 0 || x0 >= mapbuffer.maxx)
         return;

   if (y0 < y1) {
      if (y0 < 0 || y1 >= mapbuffer.maxy)
         return;
   }

   else
      if (y1 < 0 || y0 >= mapbuffer.maxy)
         return;

   if (y0 == y1) {                      // horizontal
      if (x1 < x0) {
         j  = x0;
         x0 = x1;
         x1 = j;
      }

      x = (mcanvas->maxy-1-y0)*mcanvas->maxx+x0;

      for (i=x+(x1-x0); x<=i; x++)
         mcanvas->data[x] = color;

      return;
   }

   if (x0 == x1) {                      // vertical
      if (y1 < y0) {
         j  = y0;
         y0 = y1;
         y1 = j;
      }

      i = (mcanvas->maxy-1-y0)*mcanvas->maxx+x0;
      x = (mcanvas->maxy-1-y1)*mcanvas->maxx+x0;

      for (; x<i; x+=mcanvas->maxx)
         mcanvas->data[x] = color;

      return;
   }

   deltax = x1 - x0;
   absdeltax = abs(deltax);
   deltay = y0 - y1;                 // (WINY-y1)-(WINY-y0)
   absdeltay = abs(deltay);

   if (deltax < 0) {                    // deltax is pos
      j = x1;
      x1 = x0;
      x0 = j;

      j = y1;
      y1 = y0;
      y0 = j;

      yinc = mcanvas->maxx*sgn(-deltay);
   }

   else
      yinc = mcanvas->maxx*sgn(deltay);

   x = (mcanvas->maxy-1-y0)*mcanvas->maxx+x0;

   k = 0;
   if (absdeltax > absdeltay) {         // left to right

      run_length = absdeltax / absdeltay;
      rlinc = absdeltax % absdeltay;

      if (run_length < 3) {             // bresseham's

         for (j=0; j < absdeltax; j++, x++) {
            mcanvas->data[x] = color;

            k += absdeltay;

            if (k > absdeltax) {
               k -= absdeltax;
               x += yinc;
            }

         }

         return;
      }
                                // bresseham's run length
      rlflag = 0;
      rlplus = run_length + 1;

      for (j=run_length; j <= absdeltax;) {

         for (i=x+run_length; x<i; x++)
            mcanvas->data[x] = color;

         k += rlinc;
         x += yinc;

         if (rlflag) {
            mcanvas->data[x] = color;
            x++;
            rlflag = 0;
         }

         if (k > absdeltax) {
            j += rlplus;
            k -= absdeltax;
            rlflag = 1;
         }

         else
            j += run_length;
      }

      for (j -= (rlflag ? rlplus : run_length), i=x+(absdeltax-j); x < i; x++)
         mcanvas->data[x] = color;

      return;
   }
                                // down to up
   run_length = absdeltay / absdeltax;
   rlinc = absdeltay % absdeltax;

   if (run_length < 3) {                // bresseham's

      for (j=0; j<absdeltay; j++) {     // down to up
         mcanvas->data[x] = color;

         x += yinc;
         k += absdeltax;

         if (k > absdeltay) {
            k -= absdeltay;
            x++;
         }

      }

       return;
   }
                                        // bresseham's run length
   rlflag = 0;
   rlplus = run_length + 1;

   for (j=run_length; j <= absdeltay;) {

      for (i=0; i<run_length; i++, x+=yinc)
         mcanvas->data[x] = color;

      k += rlinc;
      x++;

      if (rlflag) {
         mcanvas->data[x] = color;
         x += yinc;
         rlflag = 0;
      }

      if (k > absdeltay) {
         j += rlplus;
         k -= absdeltay;
         rlflag = 1;
      }

      else
         j += run_length;
   }

   for (j -= (rlflag ? rlplus : run_length); j < absdeltay; j++, x+=yinc)
      mcanvas->data[x] = color;
}


/* **************************************************
                              bressem line
************************************************** */
void Xwindow::Xline(int x0, int y0, int x1, int y1, unsigned int color, XImage *mcanvas) {

   int         i, x;
   int          absdeltax, absdeltay;
   int          deltax, deltay;
   int          j, k;                   // loop counter
   int          yinc;
   int          run_length, rlplus, rlinc, rlflag;

   if (x0 < x1) {
      if (x0 < 0 || x1 >= mapbuffer.maxx)
         return;
   }

   else
      if (x1 < 0 || x0 >= mapbuffer.maxx)
         return;

   if (y0 < y1) {
      if (y0 < 0 || y1 >= mapbuffer.maxy)
         return;
   }

   else
      if (y1 < 0 || y0 >= mapbuffer.maxy)
         return;

   if (y0 == y1) {                      // horizontal
      if (x1 < x0) {
         j  = x0;
         x0 = x1;
         x1 = j;
      }

      x = (mapbuffer.maxy-1-y0)*mcanvas->width+x0;

      for (i=x+(x1-x0); x<=i; x++)
         ((unsigned int *)mcanvas->data)[x] = color;

      return;
   }

   if (x0 == x1) {                      // vertical
      if (y1 < y0) {
         j  = y0;
         y0 = y1;
         y1 = j;
      }

      i = (mcanvas->height-1-y0)*mcanvas->width+x0;
      x = (mcanvas->height-1-y1)*mcanvas->width+x0;

      for (; x<i; x+=mcanvas->width)
         ((unsigned int *)mcanvas->data)[x] = color;

      return;
   }

   deltax = x1 - x0;
   absdeltax = abs(deltax);
   deltay = y0 - y1;                 // (WINY-y1)-(WINY-y0)
   absdeltay = abs(deltay);

   if (deltax < 0) {                    // deltax is pos
      j = x1;
      x1 = x0;
      x0 = j;

      j = y1;
      y1 = y0;
      y0 = j;

      yinc = mcanvas->width*sgn(-deltay);
   }

   else
      yinc = mcanvas->width*sgn(deltay);

   x = (mcanvas->height-1-y0)*mcanvas->width+x0;

   k = 0;
   if (absdeltax > absdeltay) {         // left to right

      run_length = absdeltax / absdeltay;
      rlinc = absdeltax % absdeltay;

      if (run_length < 3) {             // bresseham's

         for (j=0; j < absdeltax; j++, x++) {
            ((unsigned int *)mcanvas->data)[x] = color;

            k += absdeltay;

            if (k > absdeltax) {
               k -= absdeltax;
               x += yinc;
            }

         }

         return;
      }
                                // bresseham's run length
      rlflag = 0;
      rlplus = run_length + 1;

      for (j=run_length; j <= absdeltax;) {

         for (i=x+run_length; x<i; x++)
            ((unsigned int *)mcanvas->data)[x] = color;

         k += rlinc;
         x += yinc;

         if (rlflag) {
            ((unsigned int *)mcanvas->data)[x] = color;
            x++;
            rlflag = 0;
         }

         if (k > absdeltax) {
            j += rlplus;
            k -= absdeltax;
            rlflag = 1;
         }

         else
            j += run_length;
      }

      for (j -= (rlflag ? rlplus : run_length), i=x+(absdeltax-j); x < i; x++)
         ((unsigned int *)mcanvas->data)[x] = color;

      return;
   }
                                // down to up
   run_length = absdeltay / absdeltax;
   rlinc = absdeltay % absdeltax;

   if (run_length < 3) {                // bresseham's

      for (j=0; j<absdeltay; j++) {     // down to up
         ((unsigned int *)mcanvas->data)[x] = color;

         x += yinc;
         k += absdeltax;

         if (k > absdeltay) {
            k -= absdeltay;
            x++;
         }

      }

       return;
   }
                                        // bresseham's run length
   rlflag = 0;
   rlplus = run_length + 1;

   for (j=run_length; j <= absdeltay;) {

      for (i=0; i<run_length; i++, x+=yinc)
         ((unsigned int *)mcanvas->data)[x] = color;

      k += rlinc;
      x++;

      if (rlflag) {
         ((unsigned int *)mcanvas->data)[x] = color;
         x += yinc;
         rlflag = 0;
      }

      if (k > absdeltay) {
         j += rlplus;
         k -= absdeltay;
         rlflag = 1;
      }

      else
         j += run_length;
   }

   for (j -= (rlflag ? rlplus : run_length); j < absdeltay; j++, x+=yinc)
      ((unsigned int *)mcanvas->data)[x] = color;
}

