

#ifdef LINUX

#include <linux/joystick.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/ioctl.h>

#define JOY_AXIS_INDEX   0
#define JOY_BUTTON_INDEX 1

#endif


#include "WIN_X.h"
#include "user_io_x.h"
#include "global.h"


/* **********************************************************************
********************************************************************** */
user_io_X::user_io_X() {

#ifdef LINUX

   joy_fd = -1;
   joy_count[JOY_AXIS_INDEX] = joy_count[JOY_BUTTON_INDEX] = 2;

#endif

}


/* **********************************************************************
********************************************************************** */
user_io_X::~user_io_X() {

#ifdef LINUX

   if (joy_fd > -1)
      close(joy_fd);

#endif

}


/* **********************************************************************
********************************************************************** */
void user_io_X::set_win(Display *d, Window w) {

   mdisplay = d;

   flags |= FLAG_IO_MOUSE_RECENTER;

   // use XQueryKeymap() instead of XCheckMaskEvent(), so turn off events
   if (w)
      XSelectInput(d, w, 0x0);

#ifdef LINUX

   int i;

   if (joy_fd >= 0)
      close(joy_fd);

   joy_fd = open("/dev/js0", O_NONBLOCK | O_RDONLY);

   if (joy_fd < 0) {
      pprintf("Warning:  Unable to open joystick driver /dev/js0...\n");
      return;
   }

   // get # of axis
   ioctl(joy_fd, JSIOCGAXES, &joy_count[JOY_AXIS_INDEX]);

   // get # of buttons
   ioctl(joy_fd, JSIOCGBUTTONS, &joy_count[JOY_BUTTON_INDEX]);

   fcntl(joy_fd, F_SETFL, O_NONBLOCK);

   if (joy_count[JOY_BUTTON_INDEX] > MAXBUTTON)
      joy_count[JOY_BUTTON_INDEX] = MAXBUTTON;

   if (joy_count[JOY_AXIS_INDEX] > MAXJOYAXIS)
      joy_count[JOY_AXIS_INDEX] = MAXJOYAXIS;

   for (i=0; i<MAXJOYAXIS; i++)
      axis[i] = 0;

   for (i=0; i<MAXBUTTON; i++)
      button[i] = 0;

   pov[0] = pov[1] = 0;   
#endif

   povdegree = POV_DEFAULT;
}


/* **********************************************************************
********************************************************************** */
void user_io_X::set_win(VIRTUALwindow *win) {

   set_win(((Xwindow *)win)->mdisplay, ((Xwindow *)win)->mwindow);
}


/* **********************************************************************
********************************************************************** */
void user_io_X::flush_event_queue() {

//   XEvent mevent;

//   while(XCheckMaskEvent (mdisplay, KeyReleaseMask | KeyPressMask | ButtonPressMask | ButtonReleaseMask | PointerMotionMask | StructureNotifyMask, &mevent));
}

   
/* **********************************************************************
********************************************************************** */
void user_io_X::poll_mouse() {

   int rootx, rooty, mousex, mousey;
   Window rootwin, childwin, w;
   unsigned int mask;
   XWindowAttributes wa;
   int winx, winy;

//   XQueryPointer(mdisplay, mwindow, &rootwin, &childwin, &rootx, &rooty, &mousex, &mousey, &mask);
   w = RootWindow(mdisplay, XDefaultScreen(mdisplay));
   XQueryPointer(mdisplay, w, &rootwin, &childwin, &rootx, &rooty, &mousex, &mousey, &mask);

   XGetWindowAttributes(mdisplay, w, &wa);
   winx = wa.width;
   winy = wa.height;

   if (mask & Button1Mask)
      status_buttonpress |= BUTTONLEFT;
	    
   if (mask & Button2Mask)
      status_buttonpress |= BUTTONMIDDLE;
	    
   if (mask & Button3Mask)
      status_buttonpress |= BUTTONRIGHT;
	    
   if (flags & FLAG_IO_MOUSE_RECENTER) {
      flags &= ~FLAG_IO_MOUSE_RECENTER;
      center[0] = winx>>1;
      center[1] = winy>>1;
   }

   joyaxis[AXIS_MOUSE_X] = ((mousex - center[0])*2.0)/winx;
   joyaxis[AXIS_MOUSE_Y] = ((mousey - center[1])*2.0)/winy;

   tether_mouse(mousex, mousey, winx, winy);
}


/* **********************************************************************
********************************************************************** */
void user_io_X::poll_joystick() {

#ifdef LINUX
   int j;
   static struct js_event js;
   unsigned int mask;
   float fj;
   vector2f v;

   if (joy_fd < 0)
      return;

   while (read(joy_fd, &js, sizeof(struct js_event)) > 0)
      switch (js.type & ~JS_EVENT_INIT) {
         case JS_EVENT_BUTTON:
            if (js.number < MAXBUTTON)
               button[js.number] = js.value;
            break;

         case JS_EVENT_AXIS:
            if (js.number > 4)
               break;

            // -0.1 < x < 0.1
            fj = (js.value < 3276 && js.value > -3276) ? 0 : js.value/32767.0;

            switch (js.number) {
               case 0: // x axis
                  axis[AXIS_X] = -fj;
                  break;

               case 1: // y axis
                  axis[AXIS_Y] = fj;
                  break;

               case 2: // throttle 
                  axis[AXIS_THROTTLE] = -fj;
                  break;

               case 3: // hat horizontal
                  pov[AXIS_X] = fj;
                  break;

               case 4: // hat vertical
                  pov[AXIS_Y] = -fj;
                  break;

               default:
                  break;
            }

            break;

         default:
            break;
      }

   for (j=0, mask = BUTTON1; j<joy_count[JOY_BUTTON_INDEX]; j++, mask += mask)
      if (button[j])
         status_buttonpress |= mask;

   for (j=0; j<MAXJOYAXIS; j++)
      joyaxis[j] = axis[j];

   if (fabs(pov[AXIS_X]) < 0.05 && fabs(pov[AXIS_Y]) < 0.05)
      povdegree = POV_DEFAULT;
   else {
      copyarray2(v, pov);
      normalize2(v);
      povdegree = acos(v[AXIS_Y]);
      povdegree = v[AXIS_X] < 0 ? 360.0-rad2deg(povdegree) : rad2deg(povdegree);
   }

#endif

}


/* **********************************************************************
********************************************************************** */
void user_io_X::poll_keyboard() {

/*
   XEvent mevent;

   while(XCheckMaskEvent (mdisplay, KeyReleaseMask | KeyPressMask | ButtonPressMask | ButtonReleaseMask | PointerMotionMask | StructureNotifyMask, &mevent))
      switch (mevent.type) {
	 
         case KeyPress:
            status_keypress[XKeycodeToKeysym(mdisplay, mevent.xkey.keycode, 0) & 0x1ff] = 1;
            break;
	       
         default:
            break;
      }	    
*/

   char buffer[32];
   int i, j, k;
   char bitmask[8] = { 0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80 };
          
   if (!XQueryKeymap(mdisplay, buffer))
      return;

   for (i=k=0; i<32; i++) 
      for (j=0; j<8; j++, k++)
         if (buffer[i] & bitmask[j])
            status_keypress[XKeycodeToKeysym(mdisplay, k, 0) & 0x1ff] = 1;
}
