

#include "winsnd.h"
#include "global.h"
#include "pstring.h"


/* **************************************************************************
************************************************************************** */
midi_play_type::~midi_play_type() {

   if (sound)
      sound->Release();
}


/* **************************************************************************
************************************************************************** */
void midi_play_type::volume(int v) {

   long vol;

   vol = DMUS_VOLUME_MIN + (int)(*volumex*v*0.0001*(DMUS_VOLUME_MAX - DMUS_VOLUME_MIN));
   parent->midi_performer->SetGlobalParam(GUID_PerfMasterVolume, &vol, sizeof(long));
}


/* **************************************************************************
   NOTE: this will ignore the lock field...
************************************************************************** */
void midi_manager::dest() {

   sound_type *ptr;

   for (ptr = (sound_type *)play_manager.head; ptr; ptr = (sound_type *)ptr->next)
      parent->midi_performer->Stop(((midi_play_type *)ptr)->sound, NULL, 0, 0);

   play_manager.dest();
   sample_manager.dest();
}


/* **************************************************************************
************************************************************************** */
int midi_manager::find(sound_id_type *sound_id) {

   midi_sample_type *mtr;
   char buffer[MAXSTRLEN];
   
   for (mtr = (midi_sample_type *)sample_manager.head; mtr; mtr = (midi_sample_type *)mtr->next)
      if (!mtr->name.stringcmp(&sound_id->name)) {
         sound_id->id = mtr;
         return 1;
      }

   if (!find_file(sound_id->name.string, "rb", NULL, PLATFORM_SLASH, buffer, NULL))
      return 0;
      
   sample_manager.append(mtr = new midi_sample_type, NULL);
   mtr->name.stringcpy(&sound_id->name);
   sound_id->id = mtr;
   return 1;
}


/* **************************************************************************
************************************************************************** */
sound_type *midi_manager::play(sound_id_type *sound_id, int *volumex) {

   midi_sample_type *mtr;
   IDirectMusicSegment8 *midi_sample = NULL;
   WCHAR wbuffer[MAXSTRLEN];
   midi_play_type *ptr;
   
   if (!parent->midi_loader)
      return NULL;

   mtr = (midi_sample_type *)sound_id->id;

   if (!mtr)
      return NULL;

   mbstowcs(wbuffer, mtr->name.string, MAXSTRLEN);
   if (FAILED(parent->midi_loader->LoadObjectFromFile(CLSID_DirectMusicSegment, IID_IDirectMusicSegment8, wbuffer, (LPVOID*)&midi_sample)))
      return NULL;

   // Download the segment's instruments to the synthesizer
   midi_sample->Download(parent->midi_performer);
   
   midi_sample->SetRepeats((sound_id->flags & FLAG_SOUND_LOOPING) ? -1 : 0);

   // Play segment on the default audio path
   parent->midi_performer->PlaySegmentEx(midi_sample, NULL, NULL, 0, 0, NULL, NULL, NULL);

   play_manager.insert(ptr = new midi_play_type, NULL);
   ptr->id = mtr;
   ptr->sound = midi_sample;
   ptr->flags = FLAG_SOUND_PLAYING | sound_id->flags;
   ptr->volumex = volumex;
   ptr->parent = parent;
   ptr->volume(sound_id->db);
   
   return ptr;
}


/* **************************************************************************
************************************************************************** */
void midi_manager::update() {

   sound_type *ptr, *qtr;

   if (!parent->midi_performer)
      return;

   ptr = (sound_type *)play_manager.head;
   while (ptr) {
      ptr->update();
      if (ptr->flags & (FLAG_SOUND_PLAYING | FLAG_SOUND_LOCK)) {
         ptr = (sound_type *)ptr->next;
         continue;
      }

      qtr = ptr;
      ptr = (sound_type *)ptr->next;
      play_manager.remove(qtr);
      parent->midi_performer->Stop(((midi_play_type *)qtr)->sound, NULL, 0, 0);
      delete qtr;
   }

}


