

#include "WIN_WOS.h"

#include "global.h"


/* **************************************************
************************************************** */
void WOSwindow::WOSsetup_ogl() {

   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();
   glOrtho(0, mapbuffer.maxx, 0, mapbuffer.maxy, -1, 1);
   glMatrixMode(GL_MODELVIEW);
   glLoadIdentity();
   glRasterPos2i(0,0);

   glClearColor(0.0,0.0,0.0,0.0);
   glClear(GL_COLOR_BUFFER_BIT);
   VIRTUALswapbuffers();
   glClear(GL_COLOR_BUFFER_BIT);
}


/* **************************************************
************************************************** */
void WOSwindow::VIRTUALgetdim(int *w, int *h) {

   *w = mapbuffer.maxx;
   *h = mapbuffer.maxy;
}


/************************************************************************
************************************************************************/
int WOSwindow::VIRTUALreset(int argc, char *argv[], int maxx, int maxy, char *winname, void *attribs) {

   int i, pixelformat;
   unsigned int count;
   PIXELFORMATDESCRIPTOR pfd;
   WNDCLASSEX bgwinclass;

   int glattribs[] = {
      WGL_RED_BITS_ARB, 8,
      WGL_GREEN_BITS_ARB, 8,
      WGL_BLUE_BITS_ARB, 8,
      WGL_DEPTH_BITS_ARB, 16,
      //WGL_ALPHA_BITS_ARB, 8,
      WGL_SUPPORT_OPENGL_ARB, TRUE,
      WGL_DRAW_TO_PBUFFER_ARB, TRUE,
      WGL_DOUBLE_BUFFER_ARB, FALSE,
      0
   };

   int pbattribs[] = {0};
   int gattribs[] = {OGLFLAG_NULL};

   memset(&bgwinclass, 0, sizeof(WNDCLASSEX));

   bgwinclass.lpszClassName = winname;
   bgwinclass.cbSize = sizeof(WNDCLASSEX);
   bgwinclass.lpfnWndProc = DefWindowProc;
   bgwinclass.hInstance = GetModuleHandle(NULL);
   bgwinclass.hCursor = LoadCursor(NULL, IDC_ARROW);  // returns a handle for cursor resource 

   RegisterClassEx(&bgwinclass);

   bgwin = CreateWindowEx(NULL, winname, winname, 0, 0, 0, maxx, maxy, NULL, NULL, GetModuleHandle(NULL), NULL);

   memset(&pfd, 0, sizeof(PIXELFORMATDESCRIPTOR));

   pfd.nSize = sizeof(PIXELFORMATDESCRIPTOR);
   pfd.nVersion = 1;
   pfd.dwFlags = PFD_SUPPORT_OPENGL;
   pfd.iPixelType = PFD_TYPE_RGBA;
   pfd.cColorBits = 16;
   pfd.cDepthBits = 16;

   if (!attribs)
      attribs = gattribs;

   for (i=0; ((unsigned int *)attribs)[i] != OGLFLAG_NULL; i++)
      switch (((unsigned int *)attribs)[i]) {
         case OGLFLAG_MAPBUFFER:
         case OGLFLAG_DOUBLEBUFFER:
            break;

         case OGLFLAG_BPP:
            i++;

            if (((unsigned int *)attribs)[i] == OGLFLAG_NULL) {
               i--;
               break;
            }

            pfd.cColorBits = ((unsigned int *)attribs)[i];
            break;

         case OGLFLAG_RED_SIZE:
            i++;

            if (((unsigned int *)attribs)[i] == OGLFLAG_NULL) {
               i--;
               break;
            }

            glattribs[1] = ((unsigned int *)attribs)[i];
            break;

         case OGLFLAG_GREEN_SIZE:
            i++;

            if (((unsigned int *)attribs)[i] == OGLFLAG_NULL) {
               i--;
               break;
            }

            glattribs[3] = ((unsigned int *)attribs)[i];
            break;

         case OGLFLAG_BLUE_SIZE:
            i++;

            if (((unsigned int *)attribs)[i] == OGLFLAG_NULL) {
               i--;
               break;
            }

            glattribs[5] = ((unsigned int *)attribs)[i];
            break;

         case OGLFLAG_DEPTH_SIZE:
            i++;

            if (((unsigned int *)attribs)[i] == OGLFLAG_NULL) {
               i--;
               break;
            }

            pfd.cDepthBits =  glattribs[7] = ((unsigned int *)attribs)[i];
            break;


         case OGLFLAG_SHARE_CONTEXT:
            i += 2;
            break;
	    
         default:
            break;
      }

   // get device context for entire screen
   mdisplay = GetDC(bgwin);

   pixelformat = ChoosePixelFormat(mdisplay, &pfd);
   SetPixelFormat(mdisplay, pixelformat, &pfd);

   bcontext = wglCreateContext(mdisplay);
   wglMakeCurrent(mdisplay, bcontext);

   init_wgl();

   if (!glChoosePixelFormat || !glCreatePbuffer || !glQueryPbuffer ||
       !glGetPbufferDC || !glReleasePbufferDC || !glDestroyPbuffer) {
      VIRTUALcancel();
      return 0;
   }

   count = 0;
   glChoosePixelFormat(mdisplay, glattribs, NULL, 1, &pixelformat, &count);

   if (!count) {
      pprintf("Warning: Unable to match pixel format.\n");
      VIRTUALcancel();
      return 0;
   }

   pbuffer = glCreatePbuffer(mdisplay, pixelformat, maxx, maxy, pbattribs);

   if (!count) {
      pprintf("Warning: Unable to create pbuffer.\n");
      VIRTUALcancel();
      return 0;
   }

   glQueryPbuffer(pbuffer, WGL_PBUFFER_WIDTH_ARB, &i);

   if (i != maxx) {
      pprintf("Warning: Unable to create pbuffer of desired width.\n");
      VIRTUALcancel();
      return 0;
   }

   glQueryPbuffer(pbuffer, WGL_PBUFFER_HEIGHT_ARB, &i);

   if (i != maxy) {
      pprintf("Warning: Unable to create pbuffer of desired height.\n");
      VIRTUALcancel();
      return 0;
   }

   pdisplay = glGetPbufferDC(pbuffer);
   context = wglCreateContext(pdisplay);

   wglMakeCurrent(pdisplay, context);

   WOSsetup_ogl();

   return 1;
}


/************************************************************************
************************************************************************/
void WOSwindow::VIRTUALcancel() {

   if (pdisplay && context) {
      wglMakeCurrent(pdisplay, context);
      glFlush();
      wglMakeCurrent(pdisplay, NULL);
   }

   if (context) {
      wglDeleteContext(context);
      context = NULL;
   }

   if (pdisplay) {
      glReleasePbufferDC(pbuffer, pdisplay);
      pdisplay = NULL;
   }

   if (pbuffer) {
      glDestroyPbuffer(pbuffer);
      pbuffer = NULL;
   }

   if (bcontext) {
      wglMakeCurrent(NULL, NULL);
      wglDeleteContext(bcontext);
      bcontext = NULL;
   }

   if (mdisplay) {
      ReleaseDC(bgwin, mdisplay);
      mdisplay = NULL;
   }

   if (bgwin) {
      DestroyWindow(bgwin);
      bgwin = NULL;
   }
}


/************************************************************************
************************************************************************/
void WOSwindow::VIRTUALswapbuffers() {

   if (context)
      glReadPixels(0, 0, mapbuffer.maxx, mapbuffer.maxy, GL_RGBA, GL_UNSIGNED_BYTE, mapbuffer.data);
}


/* ***********************************************************************
*********************************************************************** */
void WOSwindow::OSset_context() {
   
   if (context)
      wglMakeCurrent(pdisplay, context);
}

