

#include <string.h>
#include <time.h>

#include "WIN_WOGL.h"
#include "win_wgl.h"

#include "global.h"


/* **************************************************
************************************************** */
void WOGLwindow::WOGLsetup_ogl() {

   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();
   glOrtho(0, mapbuffer.maxx, 0, mapbuffer.maxy, -1, 1);
   glMatrixMode(GL_MODELVIEW);
   glLoadIdentity();
   glRasterPos2i(0,0);

   glClearColor(0.0,0.0,0.0,0.0);
   glClear(GL_COLOR_BUFFER_BIT);
   VIRTUALswapbuffers();
   glClear(GL_COLOR_BUFFER_BIT);
}


/* **************************************************
************************************************** */
void WOGLwindow::VIRTUALgetdim(int *w, int *h) {

   int oldx, oldy;

   oldx = mapbuffer.maxx;
   oldy = mapbuffer.maxy;

   WIN32window::VIRTUALgetdim(w, h);

   if (*w != oldx || *h != oldy)
      WOGLsetup_ogl();
}


/* **************************************************
************************************************** */
int WOGLwindow::VIRTUALreset(int argc, char *argv[], int maxx, int maxy, char *winname, void *attribs) {

   int parent_flag;
   int pixelformat;
   int generic_format;
   int generic_accelerated;
   char error_msg[] = "No OpenGL acceleration for current video resolution...";
   int i;
   HGLRC cparent;

   PIXELFORMATDESCRIPTOR pfd_new;

   PIXELFORMATDESCRIPTOR pfd = {
      sizeof(PIXELFORMATDESCRIPTOR),
      1, 				// version
      PFD_DRAW_TO_WINDOW | PFD_SUPPORT_OPENGL | PFD_GENERIC_ACCELERATED,
      PFD_TYPE_RGBA,
      24,   // bpp
      0,0,0,0,0,0,0,0,
      0,0,0,0,
      0, 				
//      16,                       // depth buffer
      32,                       // depth buffer
      0, 0,
      PFD_MAIN_PLANE,			// draw in the main plane
      0,0,0,0
   };

   unsigned int gattribs[] = {
      OGLFLAG_BPP, 32,
      OGLFLAG_DOUBLEBUFFER,
      OGLFLAG_NULL
   };

   flags = OGLFLAG_INIT;

   if (!attribs)
     attribs = (void *)gattribs;

   for (i=0; ((unsigned int *)attribs)[i] != OGLFLAG_NULL; i++)
      switch (((unsigned int *)attribs)[i]) {
         case OGLFLAG_DOUBLEBUFFER:
            flags |= OGLFLAG_DOUBLEBUFFER;
            pfd.dwFlags |= PFD_DOUBLEBUFFER;
            break;

         case OGLFLAG_BPP:
            i++;
            pfd.cColorBits = ((unsigned int *)attribs)[i];
            break;

         case OGLFLAG_MAPBUFFER:
            flags |= OGLFLAG_MAPBUFFER;
            break;

         case OGLFLAG_RED_SIZE:
         case OGLFLAG_GREEN_SIZE:
         case OGLFLAG_BLUE_SIZE:
         case OGLFLAG_DEPTH_SIZE:
            i++;
            break;

         case OGLFLAG_SHARE_CONTEXT:
            i++;

            if (((unsigned int *)attribs)[i] == OGLFLAG_NULL) {
               i--;
               break;
            }

            cparent = (HGLRC)((int *)attribs)[i];
            i++;

            if (((unsigned int *)attribs)[i] == OGLFLAG_NULL) {
               i--;
               break;
            }

            fontid = ((int *)attribs)[i];
            flags |= OGLFLAG_SHARE_CONTEXT;
            break;
	    
         default:
            break;
      }

   parent_flag = WIN32create_window(argc, argv,maxx, maxy, winname);

   if (!mwindow) {
      pprintf("Error: Couldn't open a window\n");
      return 0;
   }

   mdisplay = GetDC(mwindow);

   pixelformat = ChoosePixelFormat(mdisplay, &pfd);

   if (!pixelformat) {
      pprintf("Error: Couldn't find an acceptable pixel format\n");
      return 0;
   }

   DescribePixelFormat (mdisplay, pixelformat, sizeof(PIXELFORMATDESCRIPTOR), &pfd_new);

   generic_format = pfd_new.dwFlags & PFD_GENERIC_FORMAT;
   generic_accelerated = pfd_new.dwFlags & PFD_GENERIC_ACCELERATED;

   if (generic_format && ! generic_accelerated)
      pprintf(error_msg);

   // set the pixel format for the device context
   if (!SetPixelFormat(mdisplay, pixelformat, &pfd)) {
      pprintf("Error: Couldn't set pixel format\n");
      return 0;
   }

   // create the rendering context and make it current
   context = wglCreateContext(mdisplay);
   if (flags & OGLFLAG_SHARE_CONTEXT)
      wglShareLists(cparent, context);

   wglMakeCurrent(mdisplay, context);

   init_wgl();

   ShowWindow(mwindow, SW_SHOW);
   ShowCursor(0);

   WOGLsetup_ogl();

   return WOGLinit_font();
}


/* **************************************************
************************************************** */
void WOGLwindow::VIRTUALcancel() {

   if (!(flags & OGLFLAG_INIT))
      return;

   flags = OGLFLAG_NULL;

   wglMakeCurrent(mdisplay, context);

   if (!(flags & OGLFLAG_SHARE_CONTEXT))
      glDeleteLists(fontid, 256);

   glFlush();

   wglMakeCurrent(mdisplay, NULL);
   wglDeleteContext(context);

   ReleaseDC(mwindow, mdisplay);
   DestroyWindow(mwindow);

   ShowCursor(1);
}


/* **************************************************
************************************************** */
void WOGLwindow::VIRTUALswapbuffers() {

   if (flags & OGLFLAG_DOUBLEBUFFER)
      SwapBuffers(mdisplay);
}


/************************************************************************
************************************************************************/
void WOGLwindow::BLTbitmap(mapul *mcanvas) {

   glDrawPixels(mcanvas->query_x(), mcanvas->query_y(), GL_RGBA, GL_UNSIGNED_BYTE, mcanvas->data);
   VIRTUALswapbuffers();
}


/************************************************************************
************************************************************************/
void WOGLwindow::WOGLbitmap(dbl_llist_manager *mcanvas) {

   line_type *ptr;

   glBegin(GL_LINES);

      for (ptr=(line_type *)mcanvas->head; ptr; ptr=(line_type *)ptr->next) {
         glVertex2i(ptr->pt[0] >> 16, ptr->pt[0] & 0xffff);
         glVertex2i(ptr->pt[1] >> 16, ptr->pt[1] & 0xffff);
      }

   glEnd();

   VIRTUALswapbuffers();
}


/************************************************************************
************************************************************************/
void WOGLwindow::BLTbitmap(int framenum, linelist *mcanvas) {

   glClear(GL_COLOR_BUFFER_BIT);

   if (framenum >= mcanvas->count)
      return;

   glColor3f(1.0f, 1.0f, 1.0f);
   WOGLbitmap(&mcanvas->list[framenum]);
}


/************************************************************************
************************************************************************/
void WOGLwindow::BLTbitblt(mapul *mcanvas) {

   MSG message;
   HWND oldwindow;
   int quit = 0;

   oldwindow = (HWND)SetWindowLong(mwindow, GWL_WNDPROC, (long)VIRTUALWindowProc);
   glDrawPixels(mcanvas->query_x(), mcanvas->query_y(), GL_RGBA, GL_UNSIGNED_BYTE, mcanvas->data);
   VIRTUALswapbuffers();

   while (!quit)
      if (PeekMessage(&message, NULL, 0, 0, PM_REMOVE))
         switch (message.message) {
            case WM_QUIT:
               quit = 1;
               break;

            case WM_PAINT:
               glDrawPixels(mcanvas->query_x(), mcanvas->query_y(), GL_RGBA, GL_UNSIGNED_BYTE, mcanvas->data);
               VIRTUALswapbuffers();
               break;

            default:
               DispatchMessage(&message);
         }

   SetWindowLong(mwindow, GWL_WNDPROC, (long)oldwindow);
}


/************************************************************************
************************************************************************/
void WOGLwindow::BLTbitblt(int framenum, linelist *mcanvas) {

   MSG message;
   HWND oldwindow;
   int quit = 0;

   glClear(GL_COLOR_BUFFER_BIT);

   if (framenum >= mcanvas->count)
      return;

   oldwindow = (HWND)SetWindowLong(mwindow, GWL_WNDPROC, (long)VIRTUALWindowProc);
   glColor3f(1.0f, 1.0f, 1.0f);

   while (!quit)
      if (PeekMessage(&message, NULL, 0, 0, PM_REMOVE))
         switch (message.message) {
            case WM_QUIT:
               quit = 1;
               break;

            case WM_PAINT:
               glClear(GL_COLOR_BUFFER_BIT);
               WOGLbitmap(&mcanvas->list[framenum]);
               break;

            default:
               DispatchMessage(&message);
         }

   SetWindowLong(mwindow, GWL_WNDPROC, (long)oldwindow);
}


/************************************************************************
************************************************************************/
void WOGLwindow::BLTanimate(int numframes, mapul *mcanvas) {

   MSG message;
   HWND oldwindow;
   int quit = 0;
   int i;
   float offset;
   clock_t otime, ntime;

   offset = CLOCKS_PER_SEC/((float)FRAMESPERSEC);
   otime = clock();

   oldwindow = (HWND)SetWindowLong(mwindow, GWL_WNDPROC, (long)VIRTUALWindowProc);

   i = 0;
   numframes--;

   while (!quit) {
      if (PeekMessage(&message, NULL, 0, 0, PM_REMOVE))
         switch (message.message) {
            case WM_QUIT:
               quit = 1;
               break;

            default:
               DispatchMessage(&message);
         }

      ntime = clock();
      if (ntime - otime > offset || ntime < offset) {
         glDrawPixels(mcanvas[i].query_x(), mcanvas[i].query_y(), GL_RGBA, GL_UNSIGNED_BYTE, mcanvas[i].data);
         VIRTUALswapbuffers();
         i = i == numframes ? 0 : i+1;
         otime = ntime;

      }

   }

   SetWindowLong(mwindow, GWL_WNDPROC, (long)oldwindow);
}


/************************************************************************
************************************************************************/
void WOGLwindow::BLTanimate(linelist *mcanvas) {

   MSG message;
   HWND oldwindow;
   int quit = 0;
   int i, j;
   float offset;
   clock_t otime, ntime;

   offset = CLOCKS_PER_SEC/((float)FRAMESPERSEC);
   otime = clock();

   oldwindow = (HWND)SetWindowLong(mwindow, GWL_WNDPROC, (long)VIRTUALWindowProc);

   i = 0;
   j = mcanvas->count-1;

   while (!quit) {
      if (PeekMessage(&message, NULL, 0, 0, PM_REMOVE))
         switch (message.message) {
            case WM_QUIT:
               quit = 1;
               break;

            default:
               DispatchMessage(&message);
         }

      ntime = clock();
      if (ntime - otime > offset || ntime < offset) {
         BLTbitmap(i, mcanvas);
         i = i == j ? 0 : i+1;
         otime = ntime;

      }

   }

   SetWindowLong(mwindow, GWL_WNDPROC, (long)oldwindow);
}


/* ******************************************************************
****************************************************************** */
int WOGLwindow::WOGLinit_font() {

   HFONT font;

   if (flags & OGLFLAG_SHARE_CONTEXT)
      return 1;

   font = CreateFont( 16, 0, 0, 0, FW_NORMAL, 0, 0, 0, ANSI_CHARSET,
               OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY,
               DEFAULT_PITCH | FF_MODERN, "Courier New" );

   // select font object, obtain old object
   font = (HFONT)SelectObject(mdisplay, font);

   fontid = glGenLists(256);
   wglUseFontBitmaps(mdisplay, 0, 256, fontid);

   // reset old object, get font object back
   font = (HFONT)SelectObject(mdisplay, font);

   // free old object
   DeleteObject(font);
   return 1;
}


/* ***********************************************************************
  assumes we're in ortho2 and matricies are initiallized
*********************************************************************** */
void WOGLwindow::WOGLprint(int x, int y, char *buffer) {

   glRasterPos2i(x, y);
   glPushAttrib (GL_LIST_BIT);
   glListBase(fontid);
   glCallLists(strlen(buffer), GL_UNSIGNED_BYTE, (unsigned char *)buffer);
   glPopAttrib();
}


/* ***********************************************************************
*********************************************************************** */
int WOGLwindow::VIRTUALreparent(void *data) {

   WIN32window::VIRTUALreparent(data);

   wglMakeCurrent(mdisplay, context);
   WOGLsetup_ogl();

   return 1;
}


/* ***********************************************************************
*********************************************************************** */
void WOGLwindow::WOGLset_context() {
   
   wglMakeCurrent(mdisplay, context);
}

