

#include <stdio.h>

#include "win_wgl.h"
#include "global.h"
#include "matrix.h"

char glblendequation[3][32]        = {"glBlendEquation",
                                      "glBlendEquationEXT",
                                      "glBlendEquationARB"};
char glcolortable[3][32]           = {"glColorTable",
                                      "glColorTableEXT",
                                      "glColorTableARB"};
char glloadtransposematrixf[3][32] = {"glLoadTransposeMatrixf",
                                      "glLoadTransposeMatrixfEXT",
                                      "glLoadTransposeMatrixfARB"};
char glmulttransposematrixf[3][32] = {"glMultTransposeMatrixf",
                                      "glMultTransposeMatrixfEXT",
                                      "glMultTransposeMatrixfARB"};

char glcreatepbuffer[3][32]        = {"wglCreatePbuffer",
                                      "wglCreatePbufferEXT",
                                      "wglCreatePbufferARB"};
char glgetpbufferdc[3][32]         = {"wglGetPbufferDC",
                                      "wglGetPbufferDCEXT",
                                      "wglGetPbufferDCARB"};
char glreleasepbufferdc[3][32]     = {"wglReleasePbufferDC",
                                      "wglReleasePbufferDCEXT",
                                      "wglReleasePbufferDCARB"};
char gldestroypbuffer[3][32]       = {"wglDestroyPbuffer",
                                      "wglDestroyPbufferEXT",
                                      "wglDestroyPbufferARB"};
char glquerypbuffer[3][32]         = {"wglQueryPbuffer",
                                      "wglQueryPbufferEXT",
                                      "wglQueryPbufferARB"};
char glchoosepixelformat[3][32]    = {"wglChoosePixelFormat",
                                      "wglChoosePixelFormatEXT",
                                      "wglChoosePixelFormatARB"};

glPROC   glBlendEquation = NULL;
glPROCCT glColorTable = NULL;
glLTM    glLoadTransposeMatrixf = NULL;
glMTM    glMultTransposeMatrixf = NULL;

glCP     glCreatePbuffer = NULL;
glGPDC   glGetPbufferDC = NULL;
glRPDC   glReleasePbufferDC = NULL;
glDP     glDestroyPbuffer = NULL;
glQP     glQueryPbuffer = NULL;
glCPF    glChoosePixelFormat = NULL;


/* *************************************************************
************************************************************* */
void WINAPI aglLoadTransposeMatrixf(const GLfloat *m) {

   vector4f mx[4];

   transpose(mx, (vector4f *)m);
   glLoadMatrixf((GLfloat *)mx);
}


/* *************************************************************
************************************************************* */
void WINAPI aglMultTransposeMatrixf(const GLfloat *m) {

   vector4f mx[4];

   transpose(mx, (vector4f *)m);
   glMultMatrixf((GLfloat *)mx);
}


/* *************************************************************
************************************************************* */
void print_wgl(void *func, char str[][32], int i) {

   if (func) {
      sprintf(perror_buffer, "init_wgl(): Located %s\n", str[i]);
      pprintf(perror_buffer);
   }

   else {
      sprintf(perror_buffer, "init_wgl(): Unable to locate %s\n", str[0]);
      pprintf(perror_buffer);
   }

}


/* *************************************************************
************************************************************* */
void init_wgl() {

   int i;

   if (!glBlendEquation) {
      for (i=0; i<3 && !glBlendEquation; i++)
         glBlendEquation = (glPROC)wglGetProcAddress(glblendequation[i]);

      print_wgl(glBlendEquation, glblendequation, i-1);
   }

   if (!glColorTable) {
      for (i=0; i<3 && !glColorTable; i++)
         glColorTable = (glPROCCT)wglGetProcAddress(glcolortable[i]);

      print_wgl(glColorTable, glcolortable, i-1);
   }

   if (!glLoadTransposeMatrixf) {
      for (i=0; i<3 && !glLoadTransposeMatrixf; i++)
         glLoadTransposeMatrixf = (glLTM)wglGetProcAddress(glloadtransposematrixf[i]);

      print_wgl(glLoadTransposeMatrixf, glloadtransposematrixf, i-1);

      if (!glLoadTransposeMatrixf)
         glLoadTransposeMatrixf = aglLoadTransposeMatrixf;
   }

   if (!glMultTransposeMatrixf) {
      for (i=0; i<3 && !glMultTransposeMatrixf; i++)
         glMultTransposeMatrixf = (glMTM)wglGetProcAddress(glmulttransposematrixf[i]);

      print_wgl(glMultTransposeMatrixf, glmulttransposematrixf, i-1);

      if (!glMultTransposeMatrixf)
         glMultTransposeMatrixf = aglMultTransposeMatrixf;
   }

   if (!glCreatePbuffer) {
      for (i=0; i<3 && !glCreatePbuffer; i++)
         glCreatePbuffer = (glCP)wglGetProcAddress(glcreatepbuffer[i]);

      print_wgl(glCreatePbuffer, glcreatepbuffer, i-1);
   }

   if (!glGetPbufferDC) {
      for (i=0; i<3 && !glGetPbufferDC; i++)
         glGetPbufferDC = (glGPDC)wglGetProcAddress(glgetpbufferdc[i]);

      print_wgl(glGetPbufferDC, glgetpbufferdc, i-1);
   }

   if (!glReleasePbufferDC) {
      for (i=0; i<3 && !glReleasePbufferDC; i++)
         glReleasePbufferDC = (glRPDC)wglGetProcAddress(glreleasepbufferdc[i]);

      print_wgl(glReleasePbufferDC, glreleasepbufferdc, i-1);
   }

   if (!glDestroyPbuffer) {
      for (i=0; i<3 && !glDestroyPbuffer; i++)
         glDestroyPbuffer = (glDP)wglGetProcAddress(gldestroypbuffer[i]);

      print_wgl(glDestroyPbuffer, gldestroypbuffer, i-1);
   }

   if (!glQueryPbuffer) {
      for (i=0; i<3 && !glQueryPbuffer; i++)
         glQueryPbuffer = (glQP)wglGetProcAddress(glquerypbuffer[i]);

      print_wgl(glQueryPbuffer, glquerypbuffer, i-1);
   }

   if (!glChoosePixelFormat) {
      for (i=0; i<3 && !glChoosePixelFormat; i++)
         glChoosePixelFormat = (glCPF)wglGetProcAddress(glchoosepixelformat[i]);

      print_wgl(glChoosePixelFormat, glchoosepixelformat, i-1);
   }

}

