

#include <string.h>

#include "WIN_W32.h"


/* **************************************************
************************************************** */
LRESULT CALLBACK VIRTUALWindowProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam) {

   switch (msg) {

      case WM_KEYUP:
      case WM_LBUTTONUP:
      case WM_RBUTTONUP:
      case WM_MBUTTONUP:
      case WM_DESTROY:
         PostQuitMessage( 0 );
         return 0;

      default:
         break;
   }

   return DefWindowProc(hwnd, msg, wparam, lparam);
}

 
/* **************************************************
************************************************** */
void WIN32window::VIRTUALgetdim(int *w, int *h) {

   RECT rect;

   if (!GetWindowRect(mwindow, &rect)) {
      *w = *h = 0;
      return;
   }

   *w = rect.right-rect.left;
   *h = rect.bottom-rect.top;

   if (*w != mapbuffer.maxx || *h != mapbuffer.maxy)
      if (flags & OGLFLAG_MAPBUFFER)
         mapbuffer.init_map(*w, *h, 1);
      else {
         mapbuffer.maxx = *w;
         mapbuffer.maxy = *h;
      }

}


/* **************************************************
************************************************** */
int WIN32window::WIN32create_window(int argc, char *argv[], int maxx, int maxy, char *winname) {

   WNDCLASS windowClass;        // window class attributes to be registered
   RECT     rect;
   int      i;
   int      parent_flag  = 0;
   HWND     parent_winid = NULL;

   for (i=0; i<argc; i++)
      if (!strcmp(argv[i], TOKEN_WINPARENT_STR)) {
         i++;
	       
         if (i >= argc)
	        break;

         parent_flag = 1;
         parent_winid = (HWND)atoi(argv[i]);
         break;
      }
   
   // Fill the slots of and register the window class
//   windowClass.style = CS_HREDRAW | CS_VREDRAW | CS_OWNDC;
   windowClass.style = 0;
   windowClass.lpfnWndProc = DefWindowProc;
   windowClass.cbClsExtra = 0;
   windowClass.cbWndExtra = 0;
   windowClass.hInstance = GetModuleHandle(NULL);
   windowClass.hIcon = NULL;
   windowClass.hCursor = LoadCursor(NULL, IDC_ARROW);  // returns a handle for cursor resource 
   windowClass.hbrBackground = NULL;
   windowClass.lpszMenuName = NULL;
   windowClass.lpszClassName = winname;

   RegisterClass(&windowClass);

   if (parent_flag) {
      GetWindowRect(parent_winid, &rect);

      if (flags & OGLFLAG_MAPBUFFER)
         mapbuffer.init_map(rect.right-rect.left, rect.bottom-rect.top, 1);
      else {
         mapbuffer.maxx = rect.right-rect.left;
         mapbuffer.maxy = rect.bottom-rect.top;
      }

      // Create the main window
      mwindow = CreateWindowEx(
            0,
            winname,        // class 
            winname,        // caption 
            WS_CHILD,                              // style
            0,              /* init. x pos */
            0,              /* init. y pos */
            mapbuffer.maxx,                       /* init. x size */
            mapbuffer.maxy,                       /* init. y size */
            parent_winid,           // parent window
            NULL,                   // menu handle
            GetModuleHandle(NULL),  // program handle
            NULL);                  // create parms 
   }

   else {
      if (flags & OGLFLAG_MAPBUFFER)
         mapbuffer.init_map(maxx, maxy, 1);
      else {
         mapbuffer.maxx = maxx;
         mapbuffer.maxy = maxy;
      }

      // Create the main window
      mwindow = CreateWindowEx(
//asdf            WS_EX_TOPMOST,
0,
            winname,                    /* class */
            winname,                    /* caption */
            WS_POPUP,                              // style
            0,              /* init. x pos */
            0,              /* init. y pos */
            mapbuffer.maxx,         // init. x size
            mapbuffer.maxy,         // init. y size
            NULL,                   // parent window
            NULL,                   // menu handle
            GetModuleHandle(NULL),  // program handle
            NULL);                  // create parms 
   }

   return parent_flag;
}

   
/* ***********************************************************************
*********************************************************************** */
int WIN32window::VIRTUALreparent(void *data) {

   RECT rect;

   if (!data || !GetWindowRect((HWND)data, &rect))
      return 0;

   SetParent(mwindow, (HWND)data);

   if (flags & OGLFLAG_MAPBUFFER)
      mapbuffer.init_map(rect.right-rect.left, rect.bottom-rect.top, 1);
   else {
      mapbuffer.maxx = rect.right-rect.left;
      mapbuffer.maxy = rect.bottom-rect.top;
   }

   SetWindowPos(mwindow, HWND_TOP, 0, 0, mapbuffer.maxx, mapbuffer.maxy, SWP_SHOWWINDOW | SWP_NOCOPYBITS);
   PostMessage(mwindow, WM_SIZE, SIZE_RESTORED, mapbuffer.maxx | (mapbuffer.maxy<<16));
   return 1;
}

