

#include <string.h>
#include <time.h>

#include "WIN_D3D.h"
#include "global.h"


/* **************************************************
************************************************** */
void DXGLwindow::VIRTUALswapbuffers() {

   ddevice->Present(NULL, NULL, NULL, NULL);
}


/* **************************************************
************************************************** */
void DXGLwindow::VIRTUALcancel() {

   if (background) {
      background->Release();
      background = NULL;
   }
   
   if (ddtr) {
      ddtr->Release();
      ddtr=NULL;
   }

   if (ddevice) {
      ddevice->Release();
      ddevice=NULL;
   }

   DestroyWindow(mwindow);
   ShowCursor(1);
}
   
   
/* **************************************************
************************************************** */
int DXGLwindow::VIRTUALreset(int argc, char *argv[], int maxx, int maxy, char *winname, void *attribs) {

   int parent_flag;
   int oglbpp = 32;
   int i;

   unsigned int gattribs[] = {
      OGLFLAG_BPP, 32,
      OGLFLAG_DOUBLEBUFFER,
      OGLFLAG_NULL
   };

   flags = OGLFLAG_INIT;

   if (!attribs)
     attribs = (void *)gattribs;

   for (i=0; ((unsigned int *)attribs)[i] != OGLFLAG_NULL; i++)
      switch (((unsigned int *)attribs)[i]) {
         case OGLFLAG_BPP:
            i++;
            oglbpp = ((unsigned int *)attribs)[i];
            break;
   
         case OGLFLAG_MAPBUFFER:
            flags |= OGLFLAG_MAPBUFFER;
            break;

         case OGLFLAG_RED_SIZE:
         case OGLFLAG_GREEN_SIZE:
         case OGLFLAG_BLUE_SIZE:
         case OGLFLAG_DEPTH_SIZE:
            i++;
            break;

         case OGLFLAG_SHARE_CONTEXT:
            i += 2;
            break;

         default:
            break;
      }

   parent_flag = WIN32create_window(argc, argv,maxx, maxy, winname);

   if (!mwindow) {
      pprintf("Error: Couldn't open a window\n");
      return 0;
   }

   ShowWindow(mwindow, SW_SHOW);

   if (oglbpp == 32) {
      bpp = 32;
      if (DXGL_DDInit(!parent_flag))
         return 1;

      bpp = 24;
      if (DXGL_DDInit(!parent_flag))
         return 1;
   }

   else {
      bpp = 16;
      if (DXGL_DDInit(!parent_flag))
         return 1;
   }

   sprintf(perror_buffer, "Error: Couldn't set video mode... %dx%dx%d\n", maxx, maxy, oglbpp);
   pprintf(perror_buffer);
   return 0;
}


/* **************************************************
************************************************** */
void DXGLwindow::BLTbitblt(mapul *mcanvas) {

// asdf
}


/* **************************************************
************************************************** */
void DXGLwindow::BLTbitblt(int framenum, linelist *mcanvas) {

// asdf
}


/* **************************************************
************************************************** */
void DXGLwindow::BLTbitmap(mapul *mcanvas) {

   D3DLOCKED_RECT canvas;
   RECT rect;
   int i;
   unsigned int *data;
   int winx, winy, winxnt;
   char *screen;

   rect.left = 0;
   rect.top = 0;
   rect.right = mapbuffer.maxx;
   rect.bottom = mapbuffer.maxy;
   
   if (background->LockRect(&canvas, &rect, D3DLOCK_NOSYSLOCK) != D3D_OK) {
      pprintf("WARNING: Unknown error code while locking background surface...\n");
      return;
   }
   
   screen = (char *)canvas.pBits;

   winx = (bpp == 16) ? (mapbuffer.maxx>>1) : mapbuffer.maxx;
   winy = mapbuffer.maxy;

   data = mcanvas->data + (winy-1)*winx;

   if (bpp != 24) {		// 16 or 32 bit
      winxnt = winx<<2;

      for (i=0; i<winy; i++) {

         _asm {				// copy a row
            push edx
            push ecx
            mov edx, winxnt
            xor ecx, ecx
            push esi
            push edi
            mov esi, data
            mov edi, screen
            push eax
            push ebx

loop1:
               mov eax,            [esi+ecx]
               mov ebx,            [esi+ecx+ 4]
               mov [edi+ecx],      eax
               mov [edi+ecx+ 4],   ebx

               mov eax,            [esi+ecx+8]
               mov ebx,            [esi+ecx+12]
               mov [edi+ecx+8],    eax
               mov [edi+ecx+12],   ebx

               mov eax,            [esi+ecx+16]
               mov ebx,            [esi+ecx+20]
               mov [edi+ecx+16],   eax
               mov [edi+ecx+20],   ebx

               mov eax,            [esi+ecx+24]
               mov ebx,            [esi+ecx+28]
               mov [edi+ecx+24],   eax
               mov [edi+ecx+28],   ebx

               add ecx, 32
               cmp edx, ecx
               jne loop1

            pop ebx
            pop eax
            pop edi
            pop esi
            pop ecx
            pop edx
         }

         screen += canvas.Pitch;
         data -= winx;
      }

   }

   else {		// 24 bit
      for (i=0; i<winy; i++) {

         _asm {
            push eax
            push ebx
            push ecx
            push edx
            mov ecx, winx
            push edi
            push esi
            mov edi, screen
            mov esi, data

loop2:
            mov eax, [esi]
            mov ebx, [esi + 8]
            mov [edi], ax
            mov [edi + 6], bx
            shr eax, 8
            shr ebx, 8
            mov [edi + 2], ah
            mov [edi + 8], bh

            mov eax, [esi + 4]
            mov ebx, [esi + 12]
            mov [edi + 3], al
            mov [edi + 9], bl
            shr eax, 8
            shr ebx, 8
            mov [edi + 4], ax
            mov [edi + 10], bx
            fst qword ptr [esi + 8]

            add edi, 12
            add esi, 16
            sub ecx, 4
            jnz loop2

            pop esi
            pop edi
            pop edx
            pop ecx
            pop ebx
            pop eax
         }

         screen += canvas.Pitch;
         data -= winx;
      }

   }

   background->UnlockRect();
   ddevice->Present(NULL, NULL, NULL, NULL);
}


/* **************************************************
************************************************** */
void DXGLwindow::BLTbitmap(int framenum, linelist *mcanvas) {

// asdf
}


/* **************************************************
************************************************** */
void DXGLwindow::BLTanimate(int numframes, mapul *mcanvas) {

// asdf
}


/* **************************************************
************************************************** */
void DXGLwindow::BLTanimate(linelist *mcanvas) {

// asdf
}


/* **************************************************
************************************************** */
int DXGLwindow::DXGL_DDInit(int fullscreen_flag) {

   D3DDISPLAYMODE d3ddm;
   D3DPRESENT_PARAMETERS d3dpp;

   // get device
   ddtr = Direct3DCreate8(D3D_SDK_VERSION);
   if (!ddtr)
      return 0;
 
   // get current mode
   if (FAILED(ddtr->GetAdapterDisplayMode(D3DADAPTER_DEFAULT, &d3ddm)))
      return 0;
        
   if ((bpp == 16 && d3ddm.Format != D3DFMT_R5G6B5) ||
       (bpp == 24 && d3ddm.Format != D3DFMT_R8G8B8) ||
       (bpp == 32 && d3ddm.Format != D3DFMT_X8R8G8B8 && d3ddm.Format != D3DFMT_A8R8G8B8))
      return 0;
       
   memset(&d3dpp, 0, sizeof(D3DPRESENT_PARAMETERS));

   d3dpp.SwapEffect = D3DSWAPEFFECT_DISCARD;
   d3dpp.BackBufferCount = 1;
   d3dpp.BackBufferFormat = d3ddm.Format;
   d3dpp.hDeviceWindow = mwindow;
   d3dpp.Flags = D3DPRESENTFLAG_LOCKABLE_BACKBUFFER;
   
   if (fullscreen_flag) {
      d3dpp.Windowed = FALSE;
      d3dpp.BackBufferWidth = d3ddm.Width;
      d3dpp.BackBufferHeight = d3ddm.Height;
      d3dpp.FullScreen_RefreshRateInHz = D3DPRESENT_RATE_DEFAULT;
//      d3dpp.FullScreen_PresentationInterval = D3DPRESENT_INTERVAL_IMMEDIATE;
   }
   
   else
      d3dpp.Windowed = TRUE;

   switch (ddtr->CreateDevice(D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, mwindow, D3DCREATE_SOFTWARE_VERTEXPROCESSING, &d3dpp, &ddevice)) {
      
      case D3D_OK:
         break;

      case D3DERR_INVALIDCALL:
         pprintf("DX Error: Invalid Call\n");
         ddtr->Release();
         ddtr = NULL;
         return 0;

      case D3DERR_NOTAVAILABLE:
         pprintf("DX Error: Not Available\n");
         ddtr->Release();
         ddtr = NULL;
         return 0;

      case D3DERR_OUTOFVIDEOMEMORY:
         pprintf("DX Error: Out Of Video Memory\n");
         ddtr->Release();
         ddtr = NULL;
         return 0;

      default:
         pprintf("Unknown DX error\n");
         ddtr->Release();
         ddtr = NULL;
         return 0;
   }

   if (FAILED(ddevice->GetBackBuffer(0, D3DBACKBUFFER_TYPE_MONO, &background))) {
      ddevice->Release();
      ddevice = NULL;
      
      ddtr->Release();
      ddtr = NULL;
      return 0;
   }
   
   ShowCursor(0);
   return 1;
}

