

#include <stdlib.h>
#include <time.h>


#ifdef WIN32
#include "WIN_WOGL.h"
#include <GL/gl.h>

#define WINDOWTYPE WOGLwindow
#else
#include "WIN_XOGL.h"

#define WINDOWTYPE XOGLwindow
#endif

#include "datatype.h"
#include "texture.h"
#include "global.h"

void init_coder();


/* **************************************************
   main: program controller
************************************************** */
int main (int argc, char *argv[]) {

   texture    *tex;
   int WINX, WINY;
   WINDOWTYPE  gwindow;

   if (argc < 2) {
      printf("usage: viewer <image>\n");
      exit(0);
   }

   init_coder();
   ((frame_manager *)global_resource_manager)->set_palette_support(0);

   tex = (texture *)((frame_manager *)global_resource_manager)->read_tex(argv[1]);

   if (!tex)
      return 0;
      
   WINX = tex->maxx;
   WINY = tex->maxy;

   printf("%s:%d %d\n", argv[1], WINX, WINY);

   if (gwindow.VIRTUALreset(argc, argv, WINX, WINY, "Viewer", NULL)) {
      gwindow.BLTbitblt(&((texture_block *)tex->query_data())->tob);
      gwindow.VIRTUALcancel();
   }

   delete tex;

   return 1;
}

