

#include <stdlib.h>
#include <string.h>

#include "image.h"
#include "global.h"
#include "pstring.h"

#include "spb_load.h"
#include "gamegine.h"


int lowercase_flag = 0;


int process_tob(texpolygon *tob) {

   int ret = 0;
   int i, j;
   string_type buffer;
   
   texface *data = (texface *)tob->query_data();

   for (i=0; i<tob->countobject; i++) {
      if (!data[i].ob)
         continue;

      buffer.stringcpy(&data[i].ob->dataname);
      lower_case(buffer.string);
      for (j = buffer.stringlen()-1; j > -1 && buffer.string[j] != '.'; j--);

      j++;

      if (!j)
         continue;

      if (!strcmp(&buffer.string[j], "inta") ||
          !strcmp(&buffer.string[j], "ilbm") ||
          !strcmp(&buffer.string[j], "tif") ||
          !strcmp(&buffer.string[j], "ppm") ||
          !strcmp(&buffer.string[j], "bmp") ||
          !strcmp(&buffer.string[j], "jpg") ||
          !strcmp(&buffer.string[j], "gif") ||
          !strcmp(&buffer.string[j], "int") ||
          !strcmp(&buffer.string[j], "rgb")) {
	 
         if (lowercase_flag)
            data[i].ob->dataname.stringcpy(&buffer);

         data[i].ob->dataname.string[j] = 0;
         data[i].ob->dataname.recalc();
         data[i].ob->dataname.stringcat("rtf");
         ret = 1;
      }
      
   }
   
   return ret;
}


int main(int argc, char **argv) {

   spb_loader spb;
   sfile sinfile;

   polytype *dob = NULL;
   shadelist *lob = NULL;
   texpolygon *tob = NULL;
//   shaderlisttype *wob = NULL;
   spheretype *sob = NULL;

   if (argc < 2)
      return 0;

   DYNAMIC_LOADER = 1;

   init_lut();
        
   global_resource_manager = new game_manager;

   global_resource_manager->register_resource_object(RESOURCE_IMAGE_LOADER, new tiff);
   global_resource_manager->register_resource_object(RESOURCE_IMAGE_LOADER, new ppm);
   global_resource_manager->register_resource_object(RESOURCE_IMAGE_LOADER, new ilbm);
   global_resource_manager->register_resource_object(RESOURCE_IMAGE_LOADER, new bmp);
   global_resource_manager->register_resource_object(RESOURCE_IMAGE_LOADER, new jpeg);
   global_resource_manager->register_resource_object(RESOURCE_IMAGE_LOADER, new gif);
   global_resource_manager->register_resource_object(RESOURCE_IMAGE_LOADER, new rgb);
   global_resource_manager->register_resource_object(RESOURCE_IMAGE_LOADER, new rtf);

   if (!sinfile.scan_data(argv[1], OBJECT_PATH.string,(char)PLATFORM_SLASH)) {
      sprintf(perror_buffer, "Warning: \"%s\" not found...\n", argv[1]);
      pprintf(perror_buffer);
      return 0;
   }

   if (!spb.find_loader(&sinfile) || !spb.read_data()) {
      printf("ERROR: Could not load \"%s\"... Aborting...\n", argv[1]);
      exit(1);
   }

   if (argc > 2)
      lowercase_flag = !strcmp(argv[2], "-l");

   // extract object
   dob = (polytype *)spb.extract(FILETYPE_SPG, argv[1]);

   if (!dob || !dob->countobject) {
      printf("ERROR: Invalid data file \"%s\"... Aborting...\n", argv[1]);
      exit(1);
   }
   
   lob = (shadelist *)spb.extract(FILETYPE_ILM, argv[1]);
   tob = (texpolygon *)spb.extract(FILETYPE_TEX, argv[1]);
//   wob = (shaderlisttype *)spb.extract(FILETYPE_TEX3D, argv[1]);
   sob = (spheretype *)spb.extract(FILETYPE_SPHERE, argv[1]);

   if (!tob || !process_tob(tob))
      return 1;
   
   printf("%s: Converting texture references...\n", argv[1]);
   spb.write_data(argv[1], dob, lob, tob, NULL, sob);
   return 1;
}

