

#include <string.h>

#include "texture.h"
#include "global.h"
#include "image.h"


void init_coder();

int flag_check = 0;


/* ********************************************************************
******************************************************************** */
void parse_args(int argc, char **argv) {

   flag_check = !strcmp(argv[1], "-c");
}


/* ********************************************************************
******************************************************************** */
void check_textures(int argc, char **argv) {

   texbase *tmap;
   int i;
   
   for (i=2; i<argc; i++) {
      global_resource_manager->reset();
      tmap = (texbase *)((frame_manager *)global_resource_manager)->read_tex(argv[i]);

      if (!tmap) {
         printf("Error: invalid texture %s\n", argv[i]);
         continue;
      }

      tmap->pre_process_texture();

      if (tmap->oldx != tmap->maxx || tmap->oldy != tmap->maxy)
         printf("%s %d %d -> %d %d\n", tmap->dataname.string, tmap->oldx, tmap->oldy, tmap->maxx, tmap->maxy);
      if (tmap->query_whatami() != TEXTURE256)
         printf("%s is verbatim.\n", tmap->dataname.string);
   }

}


/* ********************************************************************
******************************************************************** */
int main(int argc, char **argv) {

   texbase *tmap;
   int i;
   texture_block256 *tblock256;
   texture_block *tblock;
   rtf rtfcoder;
   
   if (global_resource_manager)
      delete global_resource_manager;

   global_resource_manager = new frame_manager;
   RENDER_MODE = RENDERER_OPENGL;

   ((frame_manager *)global_resource_manager)->set_color_byte_order(CBYTE_ORDER_RGBA);
   global_resource_manager->register_resource_object(RESOURCE_IMAGE_LOADER, new rtf);

   parse_args(argc, argv);
   
   if (flag_check) {
      check_textures(argc, argv);
      return 1;
   }
      
   for (i=1; i<argc; i++) {
      global_resource_manager->reset();
      tmap = (texbase *)((frame_manager *)global_resource_manager)->read_tex(argv[i]);

      if (!tmap) {
         printf("Error: invalid texture %s\n", argv[i]);
         continue;
      }

      tmap->pre_process_texture();

      if (tmap->oldx == tmap->maxx && tmap->oldy == tmap->maxy)
         continue;

      if (tmap->query_whatami() == TEXTURE256) {
         tblock256 = (texture_block256 *)tmap->query_data();
         rtfcoder.write_compress256(tmap->dataname.string, &tblock256->tob, tblock256->ipalette, ((frame_manager *)global_resource_manager)->query_color_byte_order());
         printf("%s %d %d -> %d %d\n", tmap->dataname.string, tmap->oldx, tmap->oldy, tmap->maxx, tmap->maxy);
      }
      
      else {
         tblock = (texture_block *)tmap->query_data();
         rtfcoder.write_data(tmap->dataname.string, &tblock->tob, ((frame_manager *)global_resource_manager)->query_color_byte_order());
         printf("%s %d %d -> %d %d\n", tmap->dataname.string, tmap->oldx, tmap->oldy, tmap->maxx, tmap->maxy);

      }

   }

   return 1;
}
