

#include "pixcon.h"


/* *************************************************************
************************************************************* */
render_manager::render_manager() {

   frame = NULL;
}


/* *************************************************************
************************************************************* */
render_manager::~render_manager() {

   if (frame)
      delete [] frame;
}


/* *************************************************************
************************************************************* */
void render_manager::init(int x) {

   frame_manager::init(x);

   if (frame)
      delete [] frame;
      
   frame = new frame_data[x];
}

/* *************************************************************
************************************************************* */
void render_manager::register_resource_object(int type, void *data) {

   switch (type) {
      case RESOURCE_FRAME_OBJECT:
         switch (((frameclass *)data)->query_category()) {
            case CLASS_CAMERA:
               ((frameclass *)data)->next = frame[((frameclass *)data)->frame].camdtr;
               frame[((frameclass *)data)->frame].camdtr = (camera *)data;
               return;

            case CLASS_LIGHT:
               if (((light *)data)->query_class() == SPOT_LIGHT) {
                  ((frameclass *)data)->next = frame[((frameclass *)data)->frame].beamdtr;
                  frame[((frameclass *)data)->frame].beamdtr = (light *)data;
                  return;
               }

               ((frameclass *)data)->next = frame[((frameclass *)data)->frame].lightdtr;
               frame[((frameclass *)data)->frame].lightdtr = (light *)data;
               return;

            default:
               ((frameclass *)data)->next = frame[((frameclass *)data)->frame].solidtr[0];
               frame[((frameclass *)data)->frame].solidtr[0] = (pc *)data;
               return;
         }

      default:
         frame_manager::register_resource_object(type, data);
         return;
   }

}


/* *******************************************************************
******************************************************************* */
void *render_manager::get_resource_object(int type) {

   switch (type) {
      case RESOURCE_FRAME_OBJECT:
         return frame;

      default:
         return frame_manager::get_resource_object(type);
   }

}

